/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.struts.action;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.PropertyDesc;
import org.seasar.framework.beans.factory.BeanDescFactory;
import org.seasar.struts.action.WrapperUtil;

public class BeanWrapper
implements Map {
    protected Object bean;
    protected BeanDesc beanDesc;

    public BeanWrapper(Object bean) {
        this.bean = bean;
        this.beanDesc = BeanDescFactory.getBeanDesc(bean.getClass());
    }

    public Object get(Object key) {
        PropertyDesc pd = this.beanDesc.getPropertyDesc(key.toString());
        if (!pd.isReadable()) {
            return null;
        }
        return WrapperUtil.convert(pd.getValue(this.bean));
    }

    public Object put(Object key, Object value) {
        PropertyDesc pd = this.beanDesc.getPropertyDesc(key.toString());
        pd.setValue(this.bean, value);
        return null;
    }

    public void clear() {
        throw new UnsupportedOperationException("clear");
    }

    public boolean containsKey(Object key) {
        if (key == null) {
            return false;
        }
        return this.beanDesc.hasPropertyDesc(key.toString());
    }

    public boolean containsValue(Object value) {
        throw new UnsupportedOperationException("containsValue");
    }

    public Set entrySet() {
        HashSet<BeanEntry> set = new HashSet<BeanEntry>();
        int size = this.beanDesc.getPropertyDescSize();
        for (int i = 0; i < size; ++i) {
            PropertyDesc pd = this.beanDesc.getPropertyDesc(i);
            set.add(new BeanEntry(this.bean, pd));
        }
        return set;
    }

    public boolean isEmpty() {
        throw new UnsupportedOperationException("isEmpty");
    }

    public Set keySet() {
        HashSet<String> set = new HashSet<String>();
        int size = this.beanDesc.getPropertyDescSize();
        for (int i = 0; i < size; ++i) {
            PropertyDesc pd = this.beanDesc.getPropertyDesc(i);
            set.add(pd.getPropertyName());
        }
        return set;
    }

    public void putAll(Map t) {
        throw new UnsupportedOperationException("putAll");
    }

    public Object remove(Object key) {
        return this.put(key, (Object)null);
    }

    public int size() {
        return this.beanDesc.getPropertyDescSize();
    }

    public Collection values() {
        throw new UnsupportedOperationException("values");
    }

    public String toString() {
        return this.bean.toString();
    }

    protected static class BeanEntry
    implements Map.Entry {
        protected PropertyDesc propDesc;
        protected Object bean;

        public BeanEntry(Object bean, PropertyDesc propDesc) {
            this.propDesc = propDesc;
            this.bean = bean;
        }

        public Object getKey() {
            return this.propDesc.getPropertyName();
        }

        public Object getValue() {
            if (!this.propDesc.isReadable()) {
                return null;
            }
            return WrapperUtil.convert(this.propDesc.getValue(this.bean));
        }

        public Object setValue(Object value) {
            this.propDesc.setValue(this.bean, value);
            return null;
        }
    }
}

