/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.flex2.rpc.remoting.message.io.writer.impl;

import java.io.DataOutputStream;
import java.io.IOException;
import org.seasar.flex2.core.format.amf.io.writer.factory.AmfDataWriterFactory;
import org.seasar.flex2.core.format.amf0.type.Amf0SharedObject;
import org.seasar.flex2.rpc.remoting.message.data.Message;
import org.seasar.flex2.rpc.remoting.message.data.MessageBody;
import org.seasar.flex2.rpc.remoting.message.io.writer.MessageWriter;

public class AmfMessageWriterImpl
implements MessageWriter {
    protected Message message;
    protected DataOutputStream outputStream;
    private AmfDataWriterFactory amfDataWriterFactory;
    private Amf0SharedObject sharedObject;

    public void config(Message message, DataOutputStream outputStream) {
        this.message = message;
        this.outputStream = outputStream;
    }

    public AmfDataWriterFactory getAmfDataWriterFactory() {
        return this.amfDataWriterFactory;
    }

    public Amf0SharedObject getSharedObject() {
        return this.sharedObject;
    }

    public void setAmfDataWriterFactory(AmfDataWriterFactory writerFactory) {
        this.amfDataWriterFactory = writerFactory;
    }

    public void setSharedObject(Amf0SharedObject sharedObject) {
        this.sharedObject = sharedObject;
    }

    public void write() throws IOException {
        this.outputStream.writeShort(0);
        this.outputStream.writeShort(0);
        this.writeBodies();
    }

    protected void clean() {
        this.sharedObject.initialize();
    }

    protected void writeBodies() throws IOException {
        this.outputStream.writeShort(this.message.getBodySize());
        for (int i = 0; i < this.message.getBodySize(); ++i) {
            this.clean();
            this.writeBody(this.message.getBody(i));
        }
    }

    protected void writeBody(MessageBody body) throws IOException {
        this.outputStream.writeUTF(body.getTarget());
        this.outputStream.writeUTF(body.getResponse());
        this.outputStream.writeInt(-1);
        this.writeData(body.getData());
    }

    protected final void writeData(Object value) throws IOException {
        this.amfDataWriterFactory.createDataWriter(value).writeAmfData(value, this.outputStream);
    }
}

