/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.flex2.core.format.amf3.io.writer.impl;

import java.io.DataOutputStream;
import java.io.IOException;
import org.seasar.flex2.core.format.amf3.io.writer.impl.AbstractAmf3ClassObjectWriterImpl;
import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.PropertyDesc;
import org.seasar.framework.beans.factory.BeanDescFactory;

public class Amf3TypedObjectWriterImpl
extends AbstractAmf3ClassObjectWriterImpl {
    public int getDataTypeValue() {
        return 10;
    }

    public boolean isWritableValue(Object value) {
        return value instanceof Object;
    }

    protected void writeClassDefine(BeanDesc beanDesc, DataOutputStream outputStream) throws IOException {
        int classDef = 1;
        classDef |= 2;
        classDef |= 0;
        classDef = beanDesc.getPropertyDescSize() << 4 | classDef;
        Amf3TypedObjectWriterImpl.writeIntData(classDef, outputStream);
    }

    protected final void writeClassName(Object object, DataOutputStream outputStream) throws IOException {
        int index;
        String type = object.getClass().getName();
        if (type.startsWith("$$") && (index = type.lastIndexOf("$$EnhancedByS2AOP$$")) > 0) {
            type = type.substring(2, index);
        }
        this.writeTypeString(type, outputStream);
    }

    protected final void writeClassObject(Object value, DataOutputStream outputStream) throws IOException {
        this.addObjectReference(value);
        this.writeClassReference(value, outputStream);
        this.writeClassObjectProperties(value, outputStream);
    }

    protected void writeClassObjectProperties(Object value, DataOutputStream outputStream) throws IOException {
        BeanDesc beanDesc = BeanDescFactory.getBeanDesc(value.getClass());
        for (int i = 0; i < beanDesc.getPropertyDescSize(); ++i) {
            this.writeClassObjectProperty(beanDesc.getPropertyDesc(i), value, outputStream);
        }
    }

    protected void writeClassProperties(BeanDesc beanDesc, DataOutputStream outputStream) throws IOException {
        for (int i = 0; i < beanDesc.getPropertyDescSize(); ++i) {
            this.writeClassPropertyName(outputStream, beanDesc.getPropertyDesc(i));
        }
    }

    protected final void writeClassReferenceDefine(Object object, DataOutputStream outputStream) throws IOException {
        this.addClassReference(object.getClass());
        BeanDesc beanDesc = BeanDescFactory.getBeanDesc(object.getClass());
        this.writeClassDefine(beanDesc, outputStream);
        this.writeClassName(object, outputStream);
        this.writeClassProperties(beanDesc, outputStream);
    }

    protected void writeInlineObject(Object object, DataOutputStream outputStream) throws IOException {
        this.writeClassObject(object, outputStream);
    }

    private final void writeClassObjectProperty(PropertyDesc propertyDef, Object value, DataOutputStream outputStream) throws IOException {
        if ("stackTrace".equals(propertyDef.getPropertyName())) {
            return;
        }
        if (propertyDef.isReadable()) {
            this.writeObjectElement(propertyDef.getValue(value), outputStream);
        } else if (propertyDef.hasReadMethod()) {
            this.writeObjectElement(propertyDef.getValue(value), outputStream);
        }
    }

    private final void writeClassPropertyName(DataOutputStream outputStream, PropertyDesc propertyDef) throws IOException {
        if (propertyDef.isReadable()) {
            this.writeTypeString(propertyDef.getPropertyName(), outputStream);
        }
    }
}

