/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.flex2.core.format.amf3.io.reader.impl;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.seasar.flex2.core.format.amf3.io.reader.impl.AbstractAmf3ObjectReaderImpl;

public abstract class AbstractAmf3UTF8StringReaderImpl
extends AbstractAmf3ObjectReaderImpl {
    private static final String EMPTY_STRING = "";

    private static final String getUTF8String(byte[] bytearr, int utflen) {
        try {
            return new String(bytearr, 0, utflen, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    protected static final String readStringData(int stringDef, DataInputStream inputStream) throws IOException {
        String string;
        int stringBytes = stringDef >> 1;
        if (stringBytes > 0) {
            byte[] chars = new byte[stringBytes];
            inputStream.readFully(chars, 0, stringBytes);
            string = AbstractAmf3UTF8StringReaderImpl.getUTF8String(chars, stringBytes);
        } else {
            string = EMPTY_STRING;
        }
        return string;
    }
}

