/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.flex2.rpc.remoting.service.impl;

import java.lang.reflect.Method;
import org.seasar.flex2.rpc.remoting.service.RemotingServiceInvoker;
import org.seasar.flex2.rpc.remoting.service.RemotingServiceLocator;
import org.seasar.flex2.rpc.remoting.service.adjustor.ArgumentAdjustor;
import org.seasar.flex2.rpc.remoting.service.exception.InvaildServiceArgumentRuntimeException;
import org.seasar.flex2.rpc.remoting.service.validator.RemotingServiceValidator;
import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.factory.BeanDescFactory;
import org.seasar.framework.log.Logger;

public abstract class AbstractRemotingServiceInvokerImpl
implements RemotingServiceInvoker {
    protected static final Logger logger = Logger.getLogger((Class)RemotingServiceInvoker.class);
    protected RemotingServiceLocator remotingServiceLocator;
    private ArgumentAdjustor[] argumentAdjustors;
    private RemotingServiceValidator[] remotingServiceValidators;

    public RemotingServiceLocator getServiceLocator() {
        return this.remotingServiceLocator;
    }

    public Object invoke(String serviceName, String methodName, Object[] args) throws Throwable {
        Object service = this.remotingServiceLocator.getService(serviceName);
        if (!this.checkMethodArgumentsValidation(service, methodName, args)) {
            throw new InvaildServiceArgumentRuntimeException(serviceName, methodName);
        }
        return this.doInvoke(service, methodName, args);
    }

    public void setArgumentAdjustors(ArgumentAdjustor[] argumentAdjustors) {
        this.argumentAdjustors = argumentAdjustors;
    }

    public void setRemotingServiceValidators(RemotingServiceValidator[] remotingServiceValidators) {
        this.remotingServiceValidators = remotingServiceValidators;
    }

    public void setServiceLocator(RemotingServiceLocator serviceLocator) {
        this.remotingServiceLocator = serviceLocator;
    }

    public boolean supports(String serviceName, String methodName, Object[] args) {
        return this.canServiceCallValidation(serviceName, methodName, args) && this.remotingServiceLocator.isSupportService(serviceName);
    }

    protected abstract Object doInvoke(Object var1, String var2, Object[] var3) throws Throwable;

    protected final Object invokeServiceMethod(Object service, String methodName, Object[] args) throws Throwable {
        BeanDesc beanDesc = BeanDescFactory.getBeanDesc(service.getClass());
        try {
            logger.log("DFLX0201", new Object[]{service.getClass().getName(), methodName});
            return beanDesc.invoke(service, methodName, args);
        }
        catch (Throwable throwable) {
            logger.log("EFLX0201", new Object[]{service.getClass().getName(), methodName}, throwable);
            throw throwable;
        }
    }

    private final Object adjustArgument(Class clazz, Object arg) {
        Object result = arg;
        for (int i = 0; i < this.argumentAdjustors.length; ++i) {
            if (!this.argumentAdjustors[i].isTarget(clazz, result)) continue;
            result = this.argumentAdjustors[i].adjust(clazz, result);
        }
        return result;
    }

    private final void adjustArguments(Class[] classes, Object[] args) {
        if (this.argumentAdjustors.length > 0) {
            for (int i = 0; i < args.length; ++i) {
                args[i] = this.adjustArgument(classes[i], args[i]);
            }
        }
    }

    private final boolean canServiceCallValidation(String serviceName, String methodName, Object[] args) {
        boolean isValid = true;
        for (int i = 0; i < this.remotingServiceValidators.length; ++i) {
            if (this.remotingServiceValidators[i].isValidate(serviceName, methodName, args)) continue;
            isValid = false;
            break;
        }
        return isValid;
    }

    private final boolean checkMethodArgumentsValidation(Object service, String methodName, Object[] args) {
        BeanDesc beanDesc = BeanDescFactory.getBeanDesc(service.getClass());
        Method[] methods = beanDesc.getMethods(methodName);
        boolean isValid = false;
        for (int i = 0; i < methods.length; ++i) {
            Class[] classes = methods[i].getParameterTypes();
            if (classes.length != args.length) continue;
            this.adjustArguments(classes, args);
            isValid = true;
            break;
        }
        return isValid;
    }
}

