/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.flex2.rpc.remoting.message.data.factory.impl;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import org.seasar.flex2.rpc.remoting.message.data.Fault;
import org.seasar.flex2.rpc.remoting.message.data.factory.FaultFactory;
import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.PropertyDesc;
import org.seasar.framework.beans.factory.BeanDescFactory;
import org.seasar.framework.container.S2Container;

public class FaultFactoryImpl
implements FaultFactory {
    private S2Container container;

    private static final String getStackTraceString(Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        pw.flush();
        return sw.toString();
    }

    public Fault createFault(String type, String details, String description, Throwable throwable) {
        Fault fault = (Fault)this.container.getComponent((Object)Fault.class);
        fault.setType(type);
        fault.setFaultDetail(details);
        fault.setFaultString(description);
        fault.setRootCause(this.createMap(throwable, true));
        return fault;
    }

    private Map createMap(Throwable t, boolean hierarchicalAcquisition) {
        HashMap<String, Object> m = new HashMap<String, Object>();
        BeanDesc beanDesc = BeanDescFactory.getBeanDesc(t.getClass());
        PropertyDesc propertyDesc = null;
        for (int i = 0; i < beanDesc.getPropertyDescSize(); ++i) {
            propertyDesc = beanDesc.getPropertyDesc(i);
            if ("stackTrace".equals(propertyDesc.getPropertyName())) continue;
            if ("cause".equals(propertyDesc.getPropertyName())) {
                Throwable cause = (Throwable)propertyDesc.getValue((Object)t);
                if (cause == null) continue;
                m.put(propertyDesc.getPropertyName(), this.createMap(cause, false));
                continue;
            }
            if (propertyDesc.getValue((Object)t) instanceof Throwable) continue;
            if (propertyDesc.isReadable() && propertyDesc.isWritable()) {
                m.put(propertyDesc.getPropertyName(), propertyDesc.getValue((Object)t));
                continue;
            }
            if (!propertyDesc.hasReadMethod() || !propertyDesc.hasWriteMethod()) continue;
            m.put(propertyDesc.getPropertyName(), propertyDesc.getValue((Object)t));
        }
        return m;
    }

    public Fault createFault(Throwable throwable) {
        return this.createFault(throwable.getClass().getName(), FaultFactoryImpl.getStackTraceString(throwable), throwable.getMessage(), throwable);
    }

    public void setContainer(S2Container container) {
        this.container = container;
    }
}

