/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.flex2.core.format.amf3.io.writer.impl;

import java.io.DataOutputStream;
import java.io.IOException;
import org.seasar.flex2.core.format.amf3.io.writer.impl.AbstractAmf3UTF8StringWriterImpl;
import org.seasar.flex2.core.format.amf3.type.Amf3References;
import org.seasar.flex2.core.format.amf3.type.factory.Amf3ReferencesFactory;

public abstract class AbstractAmf3ObjectWriterImpl
extends AbstractAmf3UTF8StringWriterImpl {
    protected Amf3ReferencesFactory referencesFactory;

    public abstract int getDataTypeValue();

    public void setReferencesFactory(Amf3ReferencesFactory referencesFactory) {
        this.referencesFactory = referencesFactory;
    }

    public void writeAmfData(Object value, DataOutputStream outputStream) throws IOException {
        this.writeAMF3DataMaker(outputStream);
        this.writeAmf3Data(value, outputStream);
    }

    public void writeAmf3Data(Object value, DataOutputStream outputStream) throws IOException {
        outputStream.writeByte(this.getDataTypeValue());
        this.writeObject(value, outputStream);
    }

    protected final void addClassProperties(Class clazz, String[] properties) {
        this.getReferences().addClassProperties(clazz, properties);
    }

    protected final void addClassReference(Class clazz) {
        this.getReferences().addClassReference(clazz);
    }

    protected final void addObjectReference(Object object) {
        this.getReferences().addObjectReference(object);
    }

    protected final void addStringReference(String object) {
        this.getReferences().addStringReference(object);
    }

    protected final int getClassReferenceIndex(Class clazz) {
        return this.getReferences().getClassReferenceIndex(clazz);
    }

    protected final int getObjectReferenceIndex(Object object) {
        return this.getReferences().getObjectReferenceIndex(object);
    }

    protected final int getStringReferenceIndex(String object) {
        return this.getReferences().getStringReferenceIndex(object);
    }

    protected abstract void writeInlineObject(Object var1, DataOutputStream var2) throws IOException;

    protected final void writeObject(Object object, DataOutputStream outputStream) throws IOException {
        int referenceIndex = this.getObjectReferenceIndex(object);
        if (referenceIndex >= 0) {
            this.writeReferenceIndex(referenceIndex, outputStream);
        } else {
            this.writeInlineObject(object, outputStream);
        }
    }

    protected final void writeReferenceIndex(int index, DataOutputStream outputStream) throws IOException {
        AbstractAmf3ObjectWriterImpl.writeIntData(index << 1, outputStream);
    }

    private final Amf3References getReferences() {
        return this.referencesFactory.createReferences();
    }

    private final void writeAMF3DataMaker(DataOutputStream outputStream) throws IOException {
        outputStream.writeByte(17);
    }
}

