/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.flex2.rpc.remoting.processor.impl;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.seasar.flex2.rpc.remoting.message.processor.MessageProcessor;
import org.seasar.flex2.rpc.remoting.processor.RemotingMessageProcessor;
import org.seasar.flex2.util.io.InputStreamUtil;
import org.seasar.flex2.util.io.OutputStreamUtil;

public class RemotingMessageProcessorImpl
implements RemotingMessageProcessor {
    private MessageProcessor messageProcessor;

    public MessageProcessor getMessageProcessor() {
        return this.messageProcessor;
    }

    public void process(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        try {
            DataInputStream inputStream = InputStreamUtil.toBufferedDataInputStream((InputStream)request.getInputStream());
            DataOutputStream outputStream = OutputStreamUtil.toBufferedDataOutputStream((OutputStream)response.getOutputStream());
            this.messageProcessor.process(inputStream, outputStream);
            response.setContentLength(outputStream.size());
            outputStream.flush();
        }
        catch (Throwable throwable) {
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            if (throwable instanceof IOException) {
                throw (IOException)throwable;
            }
            if (throwable instanceof ServletException) {
                throw (ServletException)throwable;
            }
            throw new ServletException(throwable);
        }
    }

    public void setMessageProcessor(MessageProcessor processor) {
        this.messageProcessor = processor;
    }
}

