/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.flex2.rpc.remoting.message.processor.impl;

import org.seasar.flex2.rpc.remoting.message.data.Message;
import org.seasar.flex2.rpc.remoting.message.data.MessageHeader;
import org.seasar.flex2.rpc.remoting.message.data.factory.MessageHeaderFactory;
import org.seasar.flex2.rpc.remoting.message.processor.MessageHeaderCreator;
import org.seasar.flex2.rpc.remoting.message.processor.MessageHeaderProcessor;

public class MessageHeaderProcessorImpl
implements MessageHeaderProcessor {
    private MessageHeaderCreator[] headerCreators;
    private MessageHeaderFactory headerFactory;

    private static final void addHeader(Message message, MessageHeaderCreator creator) {
        MessageHeader header = creator.createHeader(message);
        if (header != null) {
            message.addHeader(header);
        }
    }

    public MessageHeaderFactory getHeaderFactory() {
        return this.headerFactory;
    }

    public void processRequest(Message requestMessage) {
    }

    public void processResponse(Message responseMessage) {
        this.createMessageHeaders(responseMessage);
    }

    public void setHeaderCreators(MessageHeaderCreator[] headerCreators) {
        this.headerCreators = headerCreators;
    }

    public void setHeaderFactory(MessageHeaderFactory headerFactory) {
        this.headerFactory = headerFactory;
    }

    private final void createMessageHeaders(Message message) {
        for (int i = 0; i < this.headerCreators.length; ++i) {
            MessageHeaderProcessorImpl.addHeader(message, this.headerCreators[i]);
        }
    }
}

