/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.flex2.rpc.remoting.message.processor.impl;

import org.seasar.flex2.rpc.remoting.message.data.Message;
import org.seasar.flex2.rpc.remoting.message.data.MessageBody;
import org.seasar.flex2.rpc.remoting.message.data.factory.FaultFactory;
import org.seasar.flex2.rpc.remoting.message.data.factory.MessageBodyFactory;
import org.seasar.flex2.rpc.remoting.message.data.factory.MessageFactory;
import org.seasar.flex2.rpc.remoting.message.processor.MessageBodyProcessor;
import org.seasar.flex2.rpc.remoting.service.RemotingServiceInvoker;
import org.seasar.flex2.rpc.remoting.service.RemotingServiceInvokerChooser;
import org.seasar.framework.log.Logger;

public class MessageBodyProcessorImpl
implements MessageBodyProcessor {
    private static final Logger logger = Logger.getLogger((Class)MessageBodyProcessor.class);
    private static final String RESPONSE_RESULT = "/onResult";
    private static final String RESPONSE_STATUS = "/onStatus";
    private MessageBodyFactory bodyFactory;
    private FaultFactory faultFactory;
    private MessageFactory messageFactory;
    private RemotingServiceInvokerChooser serviceInvokerChooser;

    public MessageBodyFactory getBodyFactory() {
        return this.bodyFactory;
    }

    public FaultFactory getFaultFactory() {
        return this.faultFactory;
    }

    public MessageFactory getMessageFactory() {
        return this.messageFactory;
    }

    public RemotingServiceInvokerChooser getServiceInvokerChooser() {
        return this.serviceInvokerChooser;
    }

    public Message process(Message requestMessage) {
        Message responseMessage = this.messageFactory.createResponseMessage();
        requestMessage.setVersion(requestMessage.getVersion());
        for (int i = 0; i < requestMessage.getBodySize(); ++i) {
            responseMessage.addBody(this.processBody(requestMessage.getBody(i)));
        }
        return responseMessage;
    }

    public void setBodyFactory(MessageBodyFactory bodyFactory) {
        this.bodyFactory = bodyFactory;
    }

    public void setFaultFactory(FaultFactory faultFactory) {
        this.faultFactory = faultFactory;
    }

    public void setMessageFactory(MessageFactory messageFactory) {
        this.messageFactory = messageFactory;
    }

    public void setServiceInvokerChooser(RemotingServiceInvokerChooser serviceInvokerChooser) {
        this.serviceInvokerChooser = serviceInvokerChooser;
    }

    protected final MessageBody processBody(MessageBody requestBody) {
        String responseTarget;
        Object result;
        try {
            logger.log("DFLX0101", new Object[]{requestBody.getServiceName(), requestBody.getServiceMethodName()});
            RemotingServiceInvoker invoker = this.serviceInvokerChooser.chooseInvoker(requestBody);
            result = invoker.invoke(requestBody.getServiceName(), requestBody.getServiceMethodName(), requestBody.getArgs());
            responseTarget = requestBody.getResponse() + RESPONSE_RESULT;
        }
        catch (Throwable throwable) {
            result = this.faultFactory.createFault(throwable);
            responseTarget = requestBody.getResponse() + RESPONSE_STATUS;
            logger.log("EFLX0101", new Object[]{requestBody.getServiceName(), requestBody.getServiceMethodName()}, throwable);
        }
        return this.createResponseBody(responseTarget, result);
    }

    private final MessageBody createResponseBody(String target, Object result) {
        return this.bodyFactory.createBody(target, null, result);
    }
}

