/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.flex2.rpc.remoting.message.io.reader.impl;

import java.io.IOException;
import org.seasar.flex2.core.format.amf3.type.Amf3References;
import org.seasar.flex2.rpc.remoting.message.data.Message;
import org.seasar.flex2.rpc.remoting.message.io.reader.MessageReader;
import org.seasar.flex2.rpc.remoting.message.io.reader.impl.AmfMessageReaderImpl;

public class Amf3MessageReaderImpl
extends AmfMessageReaderImpl
implements MessageReader {
    private Amf3References references;

    public Amf3References getReferences() {
        return this.references;
    }

    public Message read() throws IOException {
        this.readVersion();
        this.readHeader();
        this.readBodies();
        return this.message;
    }

    public void setReferences(Amf3References references) {
        this.references = references;
    }

    protected void clean() {
        super.clean();
        this.references.initialize();
    }

    protected void readHeader() throws IOException {
        int headerCount = this.inputStream.readUnsignedShort();
        for (int i = 0; i < headerCount; ++i) {
            String name = this.inputStream.readUTF();
            boolean isRequired = this.inputStream.readBoolean();
            this.inputStream.readInt();
            this.message.addHeader(this.messageHeaderFactory.createHeader(name, this.readData(), isRequired));
        }
    }
}

