/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.flex2.rpc.remoting.service.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.seasar.flex2.rpc.remoting.service.RemotingServiceRepository;
import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.log.Logger;

public class RemotingServiceRepositoryImpl
implements RemotingServiceRepository {
    private static final Logger logger = Logger.getLogger((Class)RemotingServiceRepository.class);
    protected final Map serviceCache = Collections.synchronizedMap(new HashMap(32));

    public void addService(String serviceName, ComponentDef service) {
        if (!this.serviceCache.containsKey(serviceName)) {
            this.serviceCache.put(serviceName, service);
            logger.log("DFLX0001", (Object[])new String[]{serviceName, service.getComponentClass().getName()});
        }
    }

    public void clearService() {
        this.serviceCache.clear();
    }

    public ComponentDef getService(String serviceName) {
        return (ComponentDef)this.serviceCache.get(serviceName);
    }

    public Set getServiceNames() {
        return this.serviceCache.keySet();
    }

    public boolean hasService(String serviceName) {
        return this.serviceCache.containsKey(serviceName);
    }

    public void removeService(String serviceName) {
        this.serviceCache.remove(serviceName);
    }
}

