/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.flex2.rpc.remoting.message.processor.impl;

import javax.servlet.http.HttpServletRequest;
import org.seasar.flex2.rpc.remoting.message.data.Message;
import org.seasar.flex2.rpc.remoting.message.data.MessageHeader;
import org.seasar.flex2.rpc.remoting.message.data.factory.MessageHeaderFactory;
import org.seasar.flex2.rpc.remoting.message.processor.MessageHeaderCreator;
import org.seasar.flex2.util.http.HttpSessionUtil;
import org.seasar.flex2.util.http.SessionDecorator;
import org.seasar.framework.container.S2Container;

public class AppendToGatewayUrlHeaderCreatorImpl
implements MessageHeaderCreator {
    private S2Container container;
    private MessageHeaderFactory messageHeaderFactory;
    private SessionDecorator sessionDecorator;

    public MessageHeader createHeader(Message requestMessage) {
        HttpServletRequest request = (HttpServletRequest)this.container.getComponent((Object)HttpServletRequest.class);
        MessageHeader header = null;
        if (!request.isRequestedSessionIdValid()) {
            String sessionId = HttpSessionUtil.getSessionId(request, false);
            header = this.messageHeaderFactory.createHeader("AppendToGatewayUrl", this.sessionDecorator.formatSessionId(sessionId), false);
        }
        return header;
    }

    public S2Container getContainer() {
        return this.container;
    }

    public MessageHeaderFactory getMessageHeaderFactory() {
        return this.messageHeaderFactory;
    }

    public SessionDecorator getSessionDecorator() {
        return this.sessionDecorator;
    }

    public void setContainer(S2Container container) {
        this.container = container;
    }

    public void setMessageHeaderFactory(MessageHeaderFactory amfHeaderFactory) {
        this.messageHeaderFactory = amfHeaderFactory;
    }

    public void setSessionDecorator(SessionDecorator sessionDecorator) {
        this.sessionDecorator = sessionDecorator;
    }
}

