/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.flex2.rpc.remoting.message.io.writer.impl;

import java.io.IOException;
import org.seasar.flex2.core.format.amf3.type.Amf3References;
import org.seasar.flex2.rpc.remoting.message.data.MessageHeader;
import org.seasar.flex2.rpc.remoting.message.io.writer.impl.AmfMessageWriterImpl;

public class Amf3MessageWriterImpl
extends AmfMessageWriterImpl {
    protected Amf3References references;

    public Amf3References getReferences() {
        return this.references;
    }

    public void setReferences(Amf3References references) {
        this.references = references;
    }

    public void write() throws IOException {
        this.writeVersion();
        this.writeHeaders();
        this.writeBodies();
    }

    protected void clean() {
        super.clean();
        this.references.initialize();
    }

    protected void writeHeader(MessageHeader header) throws IOException {
        this.outputStream.writeUTF(header.getName());
        this.outputStream.writeBoolean(header.isRequired());
        this.outputStream.writeInt(header.getLength());
        this.writeData(header.getValue());
    }

    protected void writeHeaders() throws IOException {
        int headerNumber = this.message.getHeaderSize();
        this.outputStream.writeShort(headerNumber);
        for (int i = 0; i < headerNumber; ++i) {
            this.writeHeader(this.message.getHeader(i));
        }
    }

    protected final void writeVersion() throws IOException {
        this.outputStream.writeShort(this.message.getVersion());
    }
}

