/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.s2dao.sqlhandler;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.dbflute.CallbackContext;
import org.seasar.dbflute.QLog;
import org.seasar.dbflute.exception.handler.SQLExceptionHandler;
import org.seasar.dbflute.jdbc.SqlLogHandler;
import org.seasar.dbflute.jdbc.SqlResultHandler;
import org.seasar.dbflute.jdbc.StatementFactory;
import org.seasar.dbflute.jdbc.ValueType;
import org.seasar.dbflute.resource.InternalMapContext;
import org.seasar.dbflute.resource.ResourceContext;
import org.seasar.dbflute.s2dao.extension.TnSqlLogRegistry;
import org.seasar.dbflute.s2dao.valuetype.TnValueTypes;
import org.seasar.dbflute.twowaysql.DisplaySqlBuilder;
import org.seasar.dbflute.util.DfSystemUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TnBasicHandler {
    private static final Log _log = LogFactory.getLog(TnBasicHandler.class);
    protected final DataSource _dataSource;
    protected final StatementFactory _statementFactory;
    protected String _sql;
    protected Object[] _exceptionMessageSqlArgs;

    public TnBasicHandler(DataSource dataSource, StatementFactory statementFactory) {
        this(dataSource, statementFactory, null);
    }

    public TnBasicHandler(DataSource dataSource, StatementFactory statementFactory, String sql) {
        this._dataSource = dataSource;
        this._statementFactory = statementFactory;
        this.setSql(sql);
    }

    protected void bindArgs(Connection conn, PreparedStatement ps, Object[] args, ValueType[] valueTypes) {
        if (args == null) {
            return;
        }
        try {
            for (int i = 0; i < args.length; ++i) {
                ValueType valueType = valueTypes[i];
                valueType.bindValue(conn, ps, i + 1, args[i]);
            }
        }
        catch (SQLException e) {
            this.handleSQLException(e, ps);
        }
    }

    protected void bindArgs(Connection conn, PreparedStatement ps, Object[] args, Class<?>[] argTypes) {
        this.bindArgs(conn, ps, args, argTypes, 0);
    }

    protected void bindArgs(Connection conn, PreparedStatement ps, Object[] args, Class<?>[] argTypes, int beginIndex) {
        if (args == null) {
            return;
        }
        try {
            for (int i = beginIndex; i < args.length; ++i) {
                ValueType valueType = this.findValueType(argTypes[i], args[i]);
                valueType.bindValue(conn, ps, i + 1, args[i]);
            }
        }
        catch (SQLException e) {
            this.handleSQLException(e, ps);
        }
    }

    protected ValueType findValueType(Class<?> type, Object instance) {
        return TnValueTypes.findByTypeOrValue(type, instance);
    }

    protected Class<?>[] getArgTypes(Object[] args) {
        if (args == null) {
            return null;
        }
        Class[] argTypes = new Class[args.length];
        for (int i = 0; i < args.length; ++i) {
            Object arg = args[i];
            if (arg == null) continue;
            argTypes[i] = arg.getClass();
        }
        return argTypes;
    }

    protected void logSql(Object[] args, Class<?>[] argTypes) {
        boolean existsSqlLogRegistry;
        SqlLogHandler sqlLogHandler = this.getSqlLogHander();
        boolean existsSqlLogHandler = sqlLogHandler != null;
        SqlResultHandler sqlResultHander = this.getSqlResultHander();
        boolean existsSqlResultHandler = sqlResultHander != null;
        Object sqlLogRegistry = TnSqlLogRegistry.findContainerSqlLogRegistry();
        boolean bl = existsSqlLogRegistry = sqlLogRegistry != null;
        if (this.isLogEnabled() || existsSqlLogHandler || existsSqlResultHandler || existsSqlLogRegistry) {
            if (this.isInternalDebugEnabled()) {
                _log.debug((Object)("...Building displaySql because of " + this.isLogEnabled() + ", " + existsSqlLogHandler + ", " + existsSqlResultHandler + ", " + existsSqlLogRegistry));
            }
            String displaySql = this.getDisplaySql(args);
            if (this.isLogEnabled()) {
                this.log((this.isContainsLineSeparatorInSql() ? this.ln() : "") + displaySql);
            }
            if (existsSqlLogHandler) {
                sqlLogHandler.handle(this.getSql(), displaySql, args, argTypes);
            }
            if (existsSqlLogRegistry) {
                TnSqlLogRegistry.push(this.getSql(), displaySql, args, argTypes, sqlLogRegistry);
            }
            this.putObjectToMapContext("df:DisplaySql", displaySql);
        }
    }

    protected void putObjectToMapContext(String key, Object value) {
        InternalMapContext.setObject(key, value);
    }

    protected boolean isLogEnabled() {
        return QLog.isLogEnabled();
    }

    protected void log(String msg) {
        QLog.log(msg);
    }

    protected String getDisplaySql(Object[] args) {
        String logDateFormat = ResourceContext.getLogDateFormat();
        String logTimestampFormat = ResourceContext.getLogTimestampFormat();
        return DisplaySqlBuilder.buildDisplaySql(this._sql, args, logDateFormat, logTimestampFormat);
    }

    protected SqlLogHandler getSqlLogHander() {
        if (!CallbackContext.isExistCallbackContextOnThread()) {
            return null;
        }
        return CallbackContext.getCallbackContextOnThread().getSqlLogHandler();
    }

    protected SqlResultHandler getSqlResultHander() {
        if (!CallbackContext.isExistCallbackContextOnThread()) {
            return null;
        }
        return CallbackContext.getCallbackContextOnThread().getSqlResultHandler();
    }

    protected boolean isContainsLineSeparatorInSql() {
        return this._sql != null ? this._sql.contains(this.ln()) : false;
    }

    protected String getBindVariableText(Object bindVariable) {
        String logDateFormat = ResourceContext.getLogDateFormat();
        String logTimestampFormat = ResourceContext.getLogTimestampFormat();
        return DisplaySqlBuilder.getBindVariableText(bindVariable, logDateFormat, logTimestampFormat);
    }

    protected void handleSQLException(SQLException e, Statement st) {
        this.handleSQLException(e, st, false);
    }

    protected void handleSQLException(SQLException e, Statement st, boolean uniqueConstraintValid) {
        String executedSql = this._sql;
        String displaySql = this.buildExceptionMessageSql();
        this.createSQLExceptionHandler().handleSQLException(e, st, uniqueConstraintValid, executedSql, displaySql);
    }

    protected SQLExceptionHandler createSQLExceptionHandler() {
        return ResourceContext.createSQLExceptionHandler();
    }

    protected String buildExceptionMessageSql() {
        String displaySql = null;
        if (this._sql != null && this._exceptionMessageSqlArgs != null) {
            try {
                displaySql = this.getDisplaySql(this._exceptionMessageSqlArgs);
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        return displaySql;
    }

    protected Connection getConnection() {
        if (this._dataSource == null) {
            throw new IllegalStateException("The dataSource should not be null!");
        }
        try {
            return this._dataSource.getConnection();
        }
        catch (SQLException e) {
            this.handleSQLException(e, null);
            return null;
        }
    }

    protected PreparedStatement prepareStatement(Connection conn) {
        if (this._sql == null) {
            throw new IllegalStateException("The sql should not be null!");
        }
        return this._statementFactory.createPreparedStatement(conn, this._sql);
    }

    protected int executeUpdate(PreparedStatement ps) {
        try {
            return ps.executeUpdate();
        }
        catch (SQLException e) {
            this.handleSQLException(e, ps, true);
            return 0;
        }
    }

    protected void setFetchSize(Statement statement, int fetchSize) {
        if (statement == null) {
            return;
        }
        try {
            statement.setFetchSize(fetchSize);
        }
        catch (SQLException e) {
            this.handleSQLException(e, statement);
        }
    }

    protected void setMaxRows(Statement statement, int maxRows) {
        if (statement == null) {
            return;
        }
        try {
            statement.setMaxRows(maxRows);
        }
        catch (SQLException e) {
            this.handleSQLException(e, statement);
        }
    }

    protected void close(Statement statement) {
        if (statement == null) {
            return;
        }
        try {
            statement.close();
        }
        catch (SQLException e) {
            this.handleSQLException(e, statement);
        }
    }

    protected void close(ResultSet resultSet) {
        if (resultSet == null) {
            return;
        }
        try {
            resultSet.close();
        }
        catch (SQLException e) {
            this.handleSQLException(e, null);
        }
    }

    protected void close(Connection conn) {
        if (conn == null) {
            return;
        }
        try {
            conn.close();
        }
        catch (SQLException e) {
            this.handleSQLException(e, null);
        }
    }

    private boolean isInternalDebugEnabled() {
        return ResourceContext.isInternalDebug() && _log.isDebugEnabled();
    }

    protected String ln() {
        return DfSystemUtil.getLineSeparator();
    }

    public DataSource getDataSource() {
        return this._dataSource;
    }

    public StatementFactory getStatementFactory() {
        return this._statementFactory;
    }

    public String getSql() {
        return this._sql;
    }

    public void setSql(String sql) {
        this._sql = sql;
    }

    public void setExceptionMessageSqlArgs(Object[] exceptionMessageSqlArgs) {
        this._exceptionMessageSqlArgs = exceptionMessageSqlArgs;
    }
}

