/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.bhv;

import java.util.ArrayList;
import java.util.List;
import org.seasar.dbflute.Entity;
import org.seasar.dbflute.bhv.AbstractBehaviorReadable;
import org.seasar.dbflute.bhv.BehaviorWritable;
import org.seasar.dbflute.bhv.UpdateOption;
import org.seasar.dbflute.bhv.core.CommonColumnAutoSetupper;
import org.seasar.dbflute.bhv.core.command.AbstractEntityCommand;
import org.seasar.dbflute.bhv.core.command.AbstractListEntityCommand;
import org.seasar.dbflute.bhv.core.command.BatchDeleteEntityCommand;
import org.seasar.dbflute.bhv.core.command.BatchDeleteNonstrictEntityCommand;
import org.seasar.dbflute.bhv.core.command.BatchInsertEntityCommand;
import org.seasar.dbflute.bhv.core.command.BatchUpdateEntityCommand;
import org.seasar.dbflute.bhv.core.command.BatchUpdateNonstrictEntityCommand;
import org.seasar.dbflute.bhv.core.command.DeleteEntityCommand;
import org.seasar.dbflute.bhv.core.command.DeleteNonstrictEntityCommand;
import org.seasar.dbflute.bhv.core.command.InsertEntityCommand;
import org.seasar.dbflute.bhv.core.command.QueryDeleteCBCommand;
import org.seasar.dbflute.bhv.core.command.QueryUpdateEntityCBCommand;
import org.seasar.dbflute.bhv.core.command.UpdateEntityCommand;
import org.seasar.dbflute.bhv.core.command.UpdateNonstrictEntityCommand;
import org.seasar.dbflute.cbean.ConditionBean;
import org.seasar.dbflute.dbmeta.DBMeta;
import org.seasar.dbflute.exception.EntityAlreadyDeletedException;
import org.seasar.dbflute.exception.EntityAlreadyUpdatedException;
import org.seasar.dbflute.exception.IllegalBehaviorStateException;
import org.seasar.dbflute.exception.OptimisticLockColumnValueNullException;
import org.seasar.dbflute.exception.factory.ExceptionMessageBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBehaviorWritable
extends AbstractBehaviorReadable
implements BehaviorWritable {
    protected CommonColumnAutoSetupper _commonColumnAutoSetupper;

    @Override
    public void create(Entity entity) {
        this.doCreate(entity);
    }

    protected abstract void doCreate(Entity var1);

    @Override
    public void modify(Entity entity) {
        this.doModify(entity);
    }

    protected abstract void doModify(Entity var1);

    @Override
    public void modifyNonstrict(Entity entity) {
        this.doModifyNonstrict(entity);
    }

    protected abstract void doModifyNonstrict(Entity var1);

    @Override
    public void createOrModify(Entity entity) {
        this.assertEntityNotNull(entity);
        this.doCreateOrUpdate(entity);
    }

    protected abstract void doCreateOrUpdate(Entity var1);

    @Override
    public void createOrModifyNonstrict(Entity entity) {
        this.assertEntityNotNull(entity);
        this.doCreateOrUpdateNonstrict(entity);
    }

    protected abstract void doCreateOrUpdateNonstrict(Entity var1);

    @Override
    public void remove(Entity entity) {
        this.assertEntityNotNull(entity);
        this.doRemove(entity);
    }

    protected abstract void doRemove(Entity var1);

    protected <ENTITY extends Entity> void helpUpdateInternally(ENTITY entity, InternalUpdateCallback<ENTITY> callback) {
        this.assertEntityNotNull(entity);
        this.assertEntityHasVersionNoValue(entity);
        this.assertEntityHasUpdateDateValue(entity);
        int updatedCount = callback.callbackDelegateUpdate(entity);
        if (updatedCount == 0) {
            this.throwUpdateEntityAlreadyDeletedException(entity);
        } else if (updatedCount > 1) {
            this.throwUpdateEntityDuplicatedException(entity, updatedCount);
        }
    }

    protected <ENTITY extends Entity> void helpUpdateNonstrictInternally(ENTITY entity, InternalUpdateNonstrictCallback<ENTITY> callback) {
        this.assertEntityNotNull(entity);
        int updatedCount = callback.callbackDelegateUpdateNonstrict(entity);
        if (updatedCount == 0) {
            this.throwUpdateEntityAlreadyDeletedException(entity);
        } else if (updatedCount > 1) {
            this.throwUpdateEntityDuplicatedException(entity, updatedCount);
        }
    }

    protected <ENTITY extends Entity> void throwUpdateEntityAlreadyDeletedException(ENTITY entity) {
        this.createBhvExThrower().throwUpdateEntityAlreadyDeletedException(entity);
    }

    protected <ENTITY extends Entity> void throwUpdateEntityDuplicatedException(ENTITY entity, int count) {
        this.createBhvExThrower().throwUpdateEntityDuplicatedException(entity, count);
    }

    protected <ENTITY extends Entity, CB_TYPE extends ConditionBean> void helpInsertOrUpdateInternally(ENTITY entity, InternalInsertOrUpdateCallback<ENTITY, CB_TYPE> callback) {
        this.assertEntityNotNull(entity);
        if (!entity.hasPrimaryKeyValue()) {
            callback.callbackInsert(entity);
        } else {
            RuntimeException updateException = null;
            try {
                callback.callbackUpdate(entity);
            }
            catch (EntityAlreadyUpdatedException e) {
                updateException = e;
            }
            catch (EntityAlreadyDeletedException e) {
                updateException = e;
            }
            catch (OptimisticLockColumnValueNullException e) {
                updateException = e;
            }
            if (updateException != null) {
                CB_TYPE cb = callback.callbackNewMyConditionBean();
                cb.acceptPrimaryKeyMap(this.getDBMeta().extractPrimaryKeyMap(entity));
                if (callback.callbackSelectCount(cb) == 0) {
                    callback.callbackInsert(entity);
                } else {
                    throw updateException;
                }
            }
        }
    }

    protected <ENTITY extends Entity> void helpInsertOrUpdateInternally(ENTITY entity, InternalInsertOrUpdateNonstrictCallback<ENTITY> callback) {
        this.assertEntityNotNull(entity);
        if (!entity.hasPrimaryKeyValue()) {
            callback.callbackInsert(entity);
        } else {
            try {
                callback.callbackUpdateNonstrict(entity);
            }
            catch (EntityAlreadyDeletedException ignored) {
                callback.callbackInsert(entity);
            }
        }
    }

    protected <ENTITY extends Entity> void helpDeleteInternally(ENTITY entity, InternalDeleteCallback<ENTITY> callback) {
        this.assertEntityNotNull(entity);
        this.assertEntityHasVersionNoValue(entity);
        this.assertEntityHasUpdateDateValue(entity);
        int deletedCount = callback.callbackDelegateDelete(entity);
        if (deletedCount == 0) {
            this.throwUpdateEntityAlreadyDeletedException(entity);
        } else if (deletedCount > 1) {
            this.throwUpdateEntityDuplicatedException(entity, deletedCount);
        }
    }

    protected <ENTITY extends Entity> void helpDeleteNonstrictInternally(ENTITY entity, InternalDeleteNonstrictCallback<ENTITY> callback) {
        this.assertEntityNotNull(entity);
        int deletedCount = callback.callbackDelegateDeleteNonstrict(entity);
        if (deletedCount == 0) {
            this.throwUpdateEntityAlreadyDeletedException(entity);
        } else if (deletedCount > 1) {
            this.throwUpdateEntityDuplicatedException(entity, deletedCount);
        }
    }

    protected <ENTITY extends Entity> void helpDeleteNonstrictIgnoreDeletedInternally(ENTITY entity, InternalDeleteNonstrictIgnoreDeletedCallback<ENTITY> callback) {
        this.assertEntityNotNull(entity);
        int deletedCount = callback.callbackDelegateDeleteNonstrict(entity);
        if (deletedCount == 0) {
            return;
        }
        if (deletedCount > 1) {
            this.throwUpdateEntityDuplicatedException(entity, deletedCount);
        }
    }

    @Override
    public int[] lumpCreate(List<Entity> entityList) {
        this.assertListNotNullAndNotEmpty(entityList);
        return this.callCreateList(entityList);
    }

    @Override
    public int[] lumpModify(List<Entity> entityList) {
        this.assertListNotNullAndNotEmpty(entityList);
        return this.callModifyList(entityList);
    }

    @Override
    public int[] lumpRemove(List<Entity> entityList) {
        this.assertListNotNullAndNotEmpty(entityList);
        return this.callRemoveList(entityList);
    }

    protected void injectSequenceToPrimaryKeyIfNeeds(Entity entity) {
        DBMeta dbmeta = entity.getDBMeta();
        if (!dbmeta.hasSequence() || dbmeta.hasCompoundPrimaryKey() || entity.hasPrimaryKeyValue()) {
            return;
        }
        dbmeta.getPrimaryUniqueInfo().getFirstColumn().write(entity, this.readNextVal());
    }

    protected boolean processBeforeInsert(Entity entity) {
        if (!this.determineExecuteInsert(entity)) {
            return false;
        }
        this.assertEntityNotNull(entity);
        this.frameworkFilterEntityOfInsert(entity);
        this.filterEntityOfInsert(entity);
        this.assertEntityOfInsert(entity);
        return true;
    }

    protected boolean determineExecuteInsert(Entity entity) {
        return true;
    }

    protected void frameworkFilterEntityOfInsert(Entity entity) {
        this.injectSequenceToPrimaryKeyIfNeeds(entity);
        this.setupCommonColumnOfInsertIfNeeds(entity);
    }

    protected void setupCommonColumnOfInsertIfNeeds(Entity entity) {
        CommonColumnAutoSetupper setupper = this.getCommonColumnAutoSetupper();
        this.assertCommonColumnAutoSetupperNotNull();
        setupper.handleCommonColumnOfInsertIfNeeds(entity);
    }

    private void assertCommonColumnAutoSetupperNotNull() {
        if (this._commonColumnAutoSetupper != null) {
            return;
        }
        ExceptionMessageBuilder br = this.createExceptionMessageBuilder();
        br.addNotice("Not found the auto set-upper of common column in the behavior!");
        br.addItem("Advice");
        br.addElement("Please confirm the definition of the set-upper at your component configuration of DBFlute.");
        br.addItem("Behavior");
        br.addElement("Behavior for " + this.getTableDbName());
        br.addItem("Attribute");
        br.addElement("behaviorCommandInvoker   : " + this._behaviorCommandInvoker);
        br.addElement("behaviorSelector         : " + this._behaviorSelector);
        br.addElement("commonColumnAutoSetupper : " + this._commonColumnAutoSetupper);
        String msg = br.buildExceptionMessage();
        throw new IllegalBehaviorStateException(msg);
    }

    @Override
    protected void filterEntityOfInsert(Entity entity) {
    }

    protected void assertEntityOfInsert(Entity entity) {
    }

    protected boolean processBeforeUpdate(Entity entity) {
        if (!this.determineExecuteUpdate(entity)) {
            return false;
        }
        this.assertEntityNotNullAndHasPrimaryKeyValue(entity);
        this.frameworkFilterEntityOfUpdate(entity);
        this.filterEntityOfUpdate(entity);
        this.assertEntityOfUpdate(entity);
        return true;
    }

    protected boolean processBeforeQueryUpdate(Entity entity, ConditionBean cb) {
        if (!this.determineExecuteUpdate(entity)) {
            return false;
        }
        this.assertEntityNotNull(entity);
        this.assertCBNotNull(cb);
        this.frameworkFilterEntityOfUpdate(entity);
        this.filterEntityOfUpdate(entity);
        this.assertEntityOfUpdate(entity);
        return true;
    }

    protected boolean determineExecuteUpdate(Entity entity) {
        return true;
    }

    protected void frameworkFilterEntityOfUpdate(Entity entity) {
        this.setupCommonColumnOfUpdateIfNeeds(entity);
    }

    protected void setupCommonColumnOfUpdateIfNeeds(Entity entity) {
        CommonColumnAutoSetupper setupper = this.getCommonColumnAutoSetupper();
        this.assertCommonColumnAutoSetupperNotNull();
        setupper.handleCommonColumnOfUpdateIfNeeds(entity);
    }

    protected void filterEntityOfUpdate(Entity entity) {
    }

    protected void assertEntityOfUpdate(Entity entity) {
    }

    protected void assertUpdateOptionNotNull(UpdateOption<? extends ConditionBean> option) {
        this.assertObjectNotNull("option", option);
    }

    protected boolean processBeforeDelete(Entity entity) {
        if (!this.determineExecuteDelete(entity)) {
            return false;
        }
        this.assertEntityNotNullAndHasPrimaryKeyValue(entity);
        this.frameworkFilterEntityOfDelete(entity);
        this.filterEntityOfDelete(entity);
        this.assertEntityOfDelete(entity);
        return true;
    }

    protected boolean processBeforeQueryDelete(ConditionBean cb) {
        this.assertCBNotNull(cb);
        return true;
    }

    protected boolean determineExecuteDelete(Entity entity) {
        return true;
    }

    protected void frameworkFilterEntityOfDelete(Entity entity) {
    }

    protected void filterEntityOfDelete(Entity entity) {
    }

    protected void assertEntityOfDelete(Entity entity) {
    }

    protected int[] callCreateList(List<Entity> entityList) {
        this.assertObjectNotNull("entityList", entityList);
        this.helpFilterBeforeInsertInternally(entityList);
        return this.doCreateList(entityList);
    }

    protected abstract int[] doCreateList(List<Entity> var1);

    protected int[] callModifyList(List<Entity> entityList) {
        this.assertObjectNotNull("entityList", entityList);
        this.helpFilterBeforeUpdateInternally(entityList);
        return this.doModifyList(entityList);
    }

    protected abstract int[] doModifyList(List<Entity> var1);

    protected int[] callRemoveList(List<Entity> entityList) {
        this.assertObjectNotNull("entityList", entityList);
        this.helpFilterBeforeDeleteInternally(entityList);
        return this.doRemoveList(entityList);
    }

    protected abstract int[] doRemoveList(List<Entity> var1);

    protected void assertEntityHasVersionNoValue(Entity entity) {
        if (!this.getDBMeta().hasVersionNo()) {
            return;
        }
        if (this.hasVersionNoValue(entity)) {
            return;
        }
        this.throwVersionNoValueNullException(entity);
    }

    protected void throwVersionNoValueNullException(Entity entity) {
        this.createBhvExThrower().throwVersionNoValueNullException(entity);
    }

    protected void assertEntityHasUpdateDateValue(Entity entity) {
        if (!this.getDBMeta().hasUpdateDate()) {
            return;
        }
        if (this.hasUpdateDateValue(entity)) {
            return;
        }
        this.throwUpdateDateValueNullException(entity);
    }

    protected void throwUpdateDateValueNullException(Entity entity) {
        this.createBhvExThrower().throwUpdateDateValueNullException(entity);
    }

    protected <ENTITY extends Entity> List<ENTITY> helpFilterBeforeInsertInternally(List<ENTITY> entityList) {
        ArrayList<Entity> filteredList = new ArrayList<Entity>();
        for (Entity entity : entityList) {
            if (!this.processBeforeInsert(entity)) continue;
            filteredList.add(entity);
        }
        return filteredList;
    }

    protected <ENTITY extends Entity> List<ENTITY> helpFilterBeforeUpdateInternally(List<ENTITY> entityList) {
        ArrayList<Entity> filteredList = new ArrayList<Entity>();
        for (Entity entity : entityList) {
            if (!this.processBeforeUpdate(entity)) continue;
            filteredList.add(entity);
        }
        return filteredList;
    }

    protected <ENTITY extends Entity> List<ENTITY> helpFilterBeforeDeleteInternally(List<ENTITY> entityList) {
        ArrayList<Entity> filteredList = new ArrayList<Entity>();
        for (Entity entity : entityList) {
            if (!this.processBeforeDelete(entity)) continue;
            filteredList.add(entity);
        }
        return filteredList;
    }

    protected InsertEntityCommand createInsertEntityCommand(Entity entity) {
        this.assertBehaviorCommandInvoker("createInsertEntityCommand");
        return this.xsetupEntityCommand(new InsertEntityCommand(), entity);
    }

    protected UpdateEntityCommand createUpdateEntityCommand(Entity entity) {
        this.assertBehaviorCommandInvoker("createUpdateEntityCommand");
        return this.xsetupEntityCommand(new UpdateEntityCommand(), entity);
    }

    protected UpdateNonstrictEntityCommand createUpdateNonstrictEntityCommand(Entity entity) {
        this.assertBehaviorCommandInvoker("createUpdateNonstrictEntityCommand");
        return this.xsetupEntityCommand(new UpdateNonstrictEntityCommand(), entity);
    }

    protected DeleteEntityCommand createDeleteEntityCommand(Entity entity) {
        this.assertBehaviorCommandInvoker("createDeleteEntityCommand");
        return this.xsetupEntityCommand(new DeleteEntityCommand(), entity);
    }

    protected DeleteNonstrictEntityCommand createDeleteNonstrictEntityCommand(Entity entity) {
        this.assertBehaviorCommandInvoker("createDeleteNonstrictEntityCommand");
        return this.xsetupEntityCommand(new DeleteNonstrictEntityCommand(), entity);
    }

    protected <COMMAND extends AbstractEntityCommand> COMMAND xsetupEntityCommand(COMMAND command, Entity entity) {
        command.setTableDbName(this.getTableDbName());
        this._behaviorCommandInvoker.injectComponentProperty(command);
        command.setEntityType(entity.getClass());
        command.setEntity(entity);
        return command;
    }

    protected BatchInsertEntityCommand createBatchInsertEntityCommand(List<? extends Entity> entityList) {
        this.assertBehaviorCommandInvoker("createBatchInsertEntityCommand");
        return this.xsetupListEntityCommand(new BatchInsertEntityCommand(), entityList);
    }

    protected BatchUpdateEntityCommand createBatchUpdateEntityCommand(List<? extends Entity> entityList) {
        this.assertBehaviorCommandInvoker("createBatchUpdateEntityCommand");
        return this.xsetupListEntityCommand(new BatchUpdateEntityCommand(), entityList);
    }

    protected BatchUpdateNonstrictEntityCommand createBatchUpdateNonstrictEntityCommand(List<? extends Entity> entityList) {
        this.assertBehaviorCommandInvoker("createBatchUpdateNonstrictEntityCommand");
        return this.xsetupListEntityCommand(new BatchUpdateNonstrictEntityCommand(), entityList);
    }

    protected BatchDeleteEntityCommand createBatchDeleteEntityCommand(List<? extends Entity> entityList) {
        this.assertBehaviorCommandInvoker("createBatchDeleteEntityCommand");
        return this.xsetupListEntityCommand(new BatchDeleteEntityCommand(), entityList);
    }

    protected BatchDeleteNonstrictEntityCommand createBatchDeleteNonstrictEntityCommand(List<? extends Entity> entityList) {
        this.assertBehaviorCommandInvoker("createBatchDeleteNonstrictEntityCommand");
        return this.xsetupListEntityCommand(new BatchDeleteNonstrictEntityCommand(), entityList);
    }

    protected <COMMAND extends AbstractListEntityCommand> COMMAND xsetupListEntityCommand(COMMAND command, List<? extends Entity> entityList) {
        if (entityList.isEmpty()) {
            String msg = "The argument 'entityList' should not be empty: " + entityList;
            throw new IllegalStateException(msg);
        }
        command.setTableDbName(this.getTableDbName());
        this._behaviorCommandInvoker.injectComponentProperty(command);
        command.setEntityType(entityList.get(0).getClass());
        command.setEntityList(entityList);
        return command;
    }

    protected QueryUpdateEntityCBCommand createQueryUpdateEntityCBCommand(Entity entity, ConditionBean cb) {
        this.assertBehaviorCommandInvoker("createQueryUpdateEntityCBCommand");
        QueryUpdateEntityCBCommand cmd = new QueryUpdateEntityCBCommand();
        cmd.setTableDbName(this.getTableDbName());
        this._behaviorCommandInvoker.injectComponentProperty(cmd);
        cmd.setConditionBeanType(cb.getClass());
        cmd.setConditionBean(cb);
        cmd.setEntityType(entity.getClass());
        cmd.setEntity(entity);
        return cmd;
    }

    protected QueryDeleteCBCommand createQueryDeleteCBCommand(ConditionBean cb) {
        this.assertBehaviorCommandInvoker("createQueryDeleteCBCommand");
        QueryDeleteCBCommand cmd = new QueryDeleteCBCommand();
        cmd.setTableDbName(this.getTableDbName());
        this._behaviorCommandInvoker.injectComponentProperty(cmd);
        cmd.setConditionBeanType(cb.getClass());
        cmd.setConditionBean(cb);
        return cmd;
    }

    protected UpdateEntityCommand createVaryingUpdateEntityCommand(Entity entity, UpdateOption<? extends ConditionBean> option) {
        this.assertBehaviorCommandInvoker("createVaryingUpdateEntityCommand");
        UpdateEntityCommand cmd = this.createUpdateEntityCommand(entity);
        cmd.setUpdateOption(option);
        return cmd;
    }

    protected UpdateNonstrictEntityCommand createVaryingUpdateNonstrictEntityCommand(Entity entity, UpdateOption<? extends ConditionBean> option) {
        this.assertBehaviorCommandInvoker("createVaryingUpdateNonstrictEntityCommand");
        UpdateNonstrictEntityCommand cmd = this.createUpdateNonstrictEntityCommand(entity);
        cmd.setUpdateOption(option);
        return cmd;
    }

    protected QueryUpdateEntityCBCommand createVaryingQueryUpdateEntityCBCommand(Entity entity, ConditionBean cb, UpdateOption<? extends ConditionBean> option) {
        this.assertBehaviorCommandInvoker("createVaryingQueryUpdateEntityCBCommand");
        QueryUpdateEntityCBCommand cmd = this.createQueryUpdateEntityCBCommand(entity, cb);
        cmd.setUpdateOption(option);
        return cmd;
    }

    protected CommonColumnAutoSetupper getCommonColumnAutoSetupper() {
        return this._commonColumnAutoSetupper;
    }

    public void setCommonColumnAutoSetupper(CommonColumnAutoSetupper commonColumnAutoSetupper) {
        this._commonColumnAutoSetupper = commonColumnAutoSetupper;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static interface InternalDeleteNonstrictIgnoreDeletedCallback<ENTITY extends Entity> {
        public int callbackDelegateDeleteNonstrict(ENTITY var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static interface InternalDeleteNonstrictCallback<ENTITY extends Entity> {
        public int callbackDelegateDeleteNonstrict(ENTITY var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static interface InternalDeleteCallback<ENTITY extends Entity> {
        public int callbackDelegateDelete(ENTITY var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static interface InternalInsertOrUpdateNonstrictCallback<ENTITY extends Entity> {
        public void callbackInsert(ENTITY var1);

        public void callbackUpdateNonstrict(ENTITY var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static interface InternalInsertOrUpdateCallback<ENTITY extends Entity, CB_TYPE extends ConditionBean> {
        public void callbackInsert(ENTITY var1);

        public void callbackUpdate(ENTITY var1);

        public CB_TYPE callbackNewMyConditionBean();

        public int callbackSelectCount(CB_TYPE var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static interface InternalUpdateNonstrictCallback<ENTITY extends Entity> {
        public int callbackDelegateUpdateNonstrict(ENTITY var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static interface InternalUpdateCallback<ENTITY extends Entity> {
        public int callbackDelegateUpdate(ENTITY var1);
    }
}

