/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.s2dao.sqlcommand;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import javax.sql.DataSource;
import org.seasar.dbflute.Entity;
import org.seasar.dbflute.bhv.core.SqlExecution;
import org.seasar.dbflute.cbean.ConditionBean;
import org.seasar.dbflute.dbmeta.DBMeta;
import org.seasar.dbflute.dbmeta.info.ColumnInfo;
import org.seasar.dbflute.exception.QueryUpdateFailureException;
import org.seasar.dbflute.jdbc.StatementFactory;
import org.seasar.dbflute.resource.ResourceContext;
import org.seasar.dbflute.s2dao.metadata.TnBeanMetaData;
import org.seasar.dbflute.s2dao.metadata.TnPropertyType;
import org.seasar.dbflute.s2dao.sqlcommand.TnSqlCommand;
import org.seasar.dbflute.s2dao.sqlhandler.TnCommandContextHandler;
import org.seasar.dbflute.twowaysql.SqlAnalyzer;
import org.seasar.dbflute.twowaysql.context.CommandContext;
import org.seasar.dbflute.twowaysql.context.CommandContextCreator;
import org.seasar.dbflute.twowaysql.node.Node;
import org.seasar.dbflute.util.DfStringUtil;
import org.seasar.dbflute.util.DfSystemUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TnUpdateQueryAutoDynamicCommand
implements TnSqlCommand,
SqlExecution {
    protected DataSource dataSource;
    protected StatementFactory statementFactory;
    private TnBeanMetaData beanMetaData;

    public TnUpdateQueryAutoDynamicCommand(DataSource dataSource, StatementFactory statementFactory) {
        this.dataSource = dataSource;
        this.statementFactory = statementFactory;
    }

    @Override
    public Object execute(Object[] args) {
        ConditionBean cb = this.extractConditionBeanWithCheck(args);
        Entity entity = this.extractEntityWithCheck(args);
        String[] argNames = new String[]{"pmb", "entity"};
        Class[] argTypes = new Class[]{cb.getClass(), entity.getClass()};
        ArrayList<TnPropertyType> propertyTypeList = new ArrayList<TnPropertyType>();
        String twoWaySql = this.buildQueryUpdateTwoWaySql(entity, cb, propertyTypeList);
        if (twoWaySql == null) {
            return 0;
        }
        CommandContext context = this.createCommandContext(twoWaySql, argNames, argTypes, args);
        TnCommandContextHandler handler = this.createCommandContextHandler(context);
        handler.setLoggingMessageSqlArgs(context.getBindVariables());
        handler.setPropertyTypeList(propertyTypeList);
        int rows = handler.execute(args);
        return rows;
    }

    protected ConditionBean extractConditionBeanWithCheck(Object[] args) {
        this.assertArgument(args);
        Object fisrtArg = args[0];
        if (!(fisrtArg instanceof ConditionBean)) {
            String msg = "The type of first argument should be " + ConditionBean.class + "! But:";
            msg = msg + " type=" + fisrtArg.getClass();
            throw new IllegalArgumentException(msg);
        }
        return (ConditionBean)fisrtArg;
    }

    protected Entity extractEntityWithCheck(Object[] args) {
        this.assertArgument(args);
        Object secondArg = args[1];
        if (!(secondArg instanceof Entity)) {
            String msg = "The type of second argument should be " + Entity.class + "! But:";
            msg = msg + " type=" + secondArg.getClass();
            throw new IllegalArgumentException(msg);
        }
        return (Entity)secondArg;
    }

    protected void assertArgument(Object[] args) {
        if (args == null || args.length <= 1) {
            String msg = "The arguments should have two argument! But:";
            msg = msg + " args=" + (args != null ? Integer.valueOf(args.length) : null);
            throw new IllegalArgumentException(msg);
        }
    }

    protected TnCommandContextHandler createCommandContextHandler(CommandContext context) {
        return new TnCommandContextHandler(this.dataSource, this.statementFactory, context);
    }

    protected String buildQueryUpdateTwoWaySql(Entity entity, ConditionBean cb, List<TnPropertyType> propertyTypeList) {
        LinkedHashMap<String, String> columnParameterMap = new LinkedHashMap<String, String>();
        DBMeta dbmeta = entity.getDBMeta();
        Set<String> modifiedPropertyNames = entity.getModifiedPropertyNames();
        if (modifiedPropertyNames.isEmpty()) {
            return null;
        }
        String currentPropertyName = null;
        try {
            ColumnInfo columnInfo;
            Iterator<String> i$ = modifiedPropertyNames.iterator();
            while (i$.hasNext()) {
                String propertyName;
                currentPropertyName = propertyName = i$.next();
                ColumnInfo columnInfo2 = dbmeta.findColumnInfo(propertyName);
                String columnName = columnInfo2.getColumnDbName();
                Method getter = columnInfo2.findGetter();
                Object value = getter.invoke((Object)entity, (Object[])null);
                if (value != null) {
                    columnParameterMap.put(columnName, "/*entity." + propertyName + "*/null");
                    TnPropertyType propertyType = this.beanMetaData.getPropertyType(propertyName);
                    propertyTypeList.add(propertyType);
                    continue;
                }
                columnParameterMap.put(columnName, "null");
            }
            if (dbmeta.hasVersionNo()) {
                columnInfo = dbmeta.getVersionNoColumnInfo();
                String columnName = columnInfo.getColumnDbName();
                columnParameterMap.put(columnName, columnName + " + 1");
            }
            if (dbmeta.hasUpdateDate()) {
                columnInfo = dbmeta.getUpdateDateColumnInfo();
                Method setter = columnInfo.findSetter();
                setter.invoke((Object)entity, ResourceContext.getAccessTimestamp());
                String columnName = columnInfo.getColumnDbName();
                String propertyName = columnInfo.getPropertyName();
                columnParameterMap.put(columnName, "/*entity." + propertyName + "*/null");
                TnPropertyType propertyType = this.beanMetaData.getPropertyType(propertyName);
                propertyTypeList.add(propertyType);
            }
        }
        catch (RuntimeException e) {
            this.throwQueryUpdateFailureException(cb, entity, currentPropertyName, e);
        }
        catch (IllegalAccessException e) {
            this.throwQueryUpdateFailureException(cb, entity, currentPropertyName, e);
        }
        catch (InvocationTargetException e) {
            this.throwQueryUpdateFailureException(cb, entity, currentPropertyName, e.getCause());
        }
        return cb.getSqlClause().getClauseQueryUpdate(columnParameterMap);
    }

    protected void throwQueryUpdateFailureException(ConditionBean cb, Entity entity, String propertyName, Throwable e) {
        String msg = "Look! Read the message below." + this.ln();
        msg = msg + "/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *" + this.ln();
        msg = msg + "Failed to execute query-update!" + this.ln();
        msg = msg + this.ln();
        msg = msg + "[Advice]" + this.ln();
        msg = msg + "Please confirm the parameter comment logic." + this.ln();
        msg = msg + "It may exist the parameter comment that DOESN'T have an end comment." + this.ln();
        msg = msg + "  For example:" + this.ln();
        msg = msg + "    before (x) -- /*IF pmb.xxxId != null*/XXX_ID = /*pmb.xxxId*/3" + this.ln();
        msg = msg + "    after  (o) -- /*IF pmb.xxxId != null*/XXX_ID = /*pmb.xxxId*/3/*END*/" + this.ln();
        msg = msg + this.ln();
        msg = msg + "[Doubtful Property Name]" + this.ln() + propertyName + this.ln();
        msg = msg + this.ln();
        msg = msg + "[ConditionBean]" + this.ln() + cb + this.ln();
        msg = msg + this.ln();
        msg = msg + "[Entity]" + this.ln() + entity + this.ln();
        msg = msg + this.ln();
        msg = msg + "[Exception Message]" + this.ln() + e.getMessage() + this.ln();
        msg = msg + "* * * * * * * * * */";
        throw new QueryUpdateFailureException(msg, e);
    }

    protected CommandContext createCommandContext(String twoWaySql, String[] argNames, Class<?>[] argTypes, Object[] args) {
        SqlAnalyzer analyzer = this.createSqlAnalyzer(twoWaySql);
        Node node = analyzer.analyze();
        CommandContextCreator creator = new CommandContextCreator(argNames, argTypes);
        CommandContext context = creator.createCommandContext(args);
        node.accept(context);
        return context;
    }

    protected SqlAnalyzer createSqlAnalyzer(String sql) {
        return ResourceContext.createSqlAnalyzer(sql, true);
    }

    protected String replace(String text, String fromText, String toText) {
        return DfStringUtil.replace(text, fromText, toText);
    }

    protected String ln() {
        return DfSystemUtil.getLineSeparator();
    }

    public TnBeanMetaData getBeanMetaData() {
        return this.beanMetaData;
    }

    public void setBeanMetaData(TnBeanMetaData beanMetaData) {
        this.beanMetaData = beanMetaData;
    }
}

