/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.twowaysql.node;

import java.lang.reflect.Array;
import java.util.List;
import org.seasar.dbflute.twowaysql.context.CommandContext;
import org.seasar.dbflute.twowaysql.node.AbstractNode;
import org.seasar.dbflute.twowaysql.node.NodeUtil;
import org.seasar.dbflute.twowaysql.node.ParameterFinder;
import org.seasar.dbflute.twowaysql.node.ValueAndType;
import org.seasar.dbflute.twowaysql.node.ValueAndTypeSetupper;
import org.seasar.dbflute.twowaysql.pmbean.ParameterBean;
import org.seasar.dbflute.util.DfStringUtil;

public class BindVariableNode
extends AbstractNode {
    protected String _expression;
    protected String _testValue;
    protected List<String> _nameList;
    protected String _specifiedSql;
    protected boolean _blockNullParameter;

    public BindVariableNode(String expression, String testValue, String specifiedSql, boolean blockNullParameter) {
        this._expression = expression;
        this._testValue = testValue;
        this._nameList = DfStringUtil.splitList(expression, ".");
        this._specifiedSql = specifiedSql;
        this._blockNullParameter = blockNullParameter;
    }

    public void accept(CommandContext ctx) {
        String firstName = this._nameList.get(0);
        this.assertFirstName(ctx, firstName);
        Object value = ctx.getArg(firstName);
        Class<?> clazz = ctx.getArgType(firstName);
        ValueAndType valueAndType = new ValueAndType();
        valueAndType.setTargetValue(value);
        valueAndType.setTargetType(clazz);
        this.setupValueAndType(valueAndType);
        if (this._blockNullParameter && valueAndType.getTargetValue() == null) {
            this.throwBindOrEmbeddedParameterNullValueException(valueAndType);
        }
        if (!this.isInScope()) {
            ctx.addSql("?", valueAndType.getTargetValue(), valueAndType.getTargetType());
        } else if (List.class.isAssignableFrom(valueAndType.getTargetType())) {
            this.bindArray(ctx, ((List)valueAndType.getTargetValue()).toArray());
        } else if (valueAndType.getTargetType().isArray()) {
            this.bindArray(ctx, valueAndType.getTargetValue());
        } else {
            ctx.addSql("?", valueAndType.getTargetValue(), valueAndType.getTargetType());
        }
        if (valueAndType.isValidRearOption()) {
            ctx.addSql(valueAndType.buildRearOptionOnSql());
        }
    }

    protected void assertFirstName(final CommandContext ctx, String firstName) {
        NodeUtil.assertParameterBeanName(firstName, new ParameterFinder(){

            public Object find(String name) {
                return ctx.getArg(name);
            }
        }, new NodeUtil.IllegalParameterBeanHandler(){

            public void handle(ParameterBean pmb) {
                BindVariableNode.this.throwBindOrEmbeddedCommentIllegalParameterBeanSpecificationException(pmb);
            }
        });
    }

    protected void setupValueAndType(ValueAndType valueAndType) {
        ValueAndTypeSetupper setuper = new ValueAndTypeSetupper(this._expression, this._nameList, this._specifiedSql, true);
        setuper.setupValueAndType(valueAndType);
    }

    protected void throwBindOrEmbeddedParameterNullValueException(ValueAndType valueAndType) {
        NodeUtil.throwBindOrEmbeddedCommentParameterNullValueException(this._expression, valueAndType.getTargetType(), this._specifiedSql, true);
    }

    protected boolean isInScope() {
        return this._testValue != null && this._testValue.startsWith("(") && this._testValue.endsWith(")");
    }

    protected void bindArray(CommandContext ctx, Object array) {
        if (array == null) {
            return;
        }
        int length = Array.getLength(array);
        if (length == 0) {
            this.throwBindOrEmbeddedParameterEmptyListException();
        }
        Class<?> clazz = null;
        for (int i = 0; i < length; ++i) {
            Object currentElement = Array.get(array, i);
            if (currentElement == null) continue;
            clazz = currentElement.getClass();
            break;
        }
        if (clazz == null) {
            this.throwBindOrEmbeddedParameterNullOnlyListException();
        }
        boolean existsValidElements = false;
        ctx.addSql("(");
        for (int i = 0; i < length; ++i) {
            Object currentElement = Array.get(array, i);
            if (currentElement == null) continue;
            if (!existsValidElements) {
                ctx.addSql("?", currentElement, clazz);
                existsValidElements = true;
                continue;
            }
            ctx.addSql(", ?", currentElement, clazz);
        }
        ctx.addSql(")");
    }

    protected void throwBindOrEmbeddedCommentIllegalParameterBeanSpecificationException(ParameterBean pmb) {
        NodeUtil.throwBindOrEmbeddedCommentIllegalParameterBeanSpecificationException(this._expression, this._specifiedSql, true, pmb);
    }

    protected void throwBindOrEmbeddedParameterEmptyListException() {
        NodeUtil.throwBindOrEmbeddedCommentParameterEmptyListException(this._expression, this._specifiedSql, true);
    }

    protected void throwBindOrEmbeddedParameterNullOnlyListException() {
        NodeUtil.throwBindOrEmbeddedCommentParameterNullOnlyListException(this._expression, this._specifiedSql, true);
    }
}

