/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.logic.replaceschema.schemainitializer;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.dbflute.exception.SQLFailureException;
import org.seasar.dbflute.logic.jdbc.metadata.info.DfTableMetaInfo;
import org.seasar.dbflute.logic.replaceschema.schemainitializer.DfSchemaInitializerJdbc;
import org.seasar.dbflute.util.Srl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DfSchemaInitializerOracle
extends DfSchemaInitializerJdbc {
    private static final Log _log = LogFactory.getLog(DfSchemaInitializerOracle.class);

    @Override
    protected boolean isSkipDropForeignKey(DfTableMetaInfo tableMetaInfo) {
        return tableMetaInfo.isTableTypeSynonym();
    }

    @Override
    protected void setupDropTable(StringBuilder sb, DfTableMetaInfo metaInfo) {
        if (metaInfo.isTableTypeSynonym()) {
            String tableName = this.filterTableName(metaInfo.getTableName());
            sb.append("drop synonym ").append(tableName);
        } else {
            super.setupDropTable(sb, metaInfo);
        }
    }

    @Override
    protected void dropSequence(Connection conn, List<DfTableMetaInfo> tableMetaInfoList) {
        this.doDropSequence(conn);
    }

    protected void doDropSequence(Connection conn) {
        String tableName = "ALL_SEQUENCES";
        this.dropDicObject(conn, "sequences", "sequence", "ALL_SEQUENCES", "SEQUENCE_OWNER", "SEQUENCE_NAME", null, true, false);
    }

    @Override
    protected void dropDBLink(Connection conn, List<DfTableMetaInfo> tableMetaInfoList) {
        this.doDropDBLink(conn);
    }

    protected void doDropDBLink(Connection conn) {
        String tableName = "ALL_DB_LINKS";
        this.dropDicObject(conn, "DB links", "database link", "ALL_DB_LINKS", "OWNER", "DB_LINK", null, false, false);
    }

    @Override
    protected void dropTypeObject(Connection conn, List<DfTableMetaInfo> tableMetaInfoList) {
        String orderBy;
        boolean complete;
        int retryLimit = 10;
        for (int retryCount = 0; !(complete = this.doDropTypeObject(conn, orderBy = "TYPECODE " + (retryCount % 2 == 0 ? "asc" : "desc"), true)) && 10 > retryCount; ++retryCount) {
        }
    }

    protected boolean doDropTypeObject(Connection conn, String orderBy, boolean errorContinue) {
        return this.dropDicObject(conn, "type objects", "type", "ALL_TYPES", "OWNER", "TYPE_NAME", orderBy, false, errorContinue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean dropDicObject(Connection conn, String titleName, String sqlName, String tableName, String ownerColumnName, String targetColumnName, String orderBy, boolean schemaPrefix, boolean errorContinue) {
        boolean i$;
        if (!this._unifiedSchema.hasSchema()) {
            return true;
        }
        String schema = this._unifiedSchema.getPureSchema();
        ArrayList<String> objectNameList = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        sb.append("select * from ").append(tableName);
        sb.append(" where ").append(ownerColumnName).append(" = '").append(schema).append("'");
        if (Srl.is_NotNull_and_NotTrimmedEmpty((String)orderBy)) {
            sb.append(" order by ").append(orderBy);
        }
        String metaSql = sb.toString();
        Statement st = null;
        ResultSet rs = null;
        try {
            try {
                st = conn.createStatement();
                _log.info((Object)("...Executing helper SQL:" + this.ln() + metaSql));
                rs = st.executeQuery(metaSql);
                while (rs.next()) {
                    String objectName = rs.getString(targetColumnName);
                    objectNameList.add(objectName);
                }
                Object var20_20 = null;
            }
            catch (SQLException continued) {
                String msg = "*Failed to the SQL:" + this.ln();
                msg = msg + (continued.getMessage() != null ? continued.getMessage() : null) + this.ln();
                msg = msg + metaSql;
                _log.info((Object)metaSql);
                boolean bl = true;
                Object var20_21 = null;
                this.closeResource(rs, st);
                return bl;
            }
        }
        catch (Throwable throwable) {
            Object var20_22 = null;
            this.closeResource(rs, st);
            throw throwable;
        }
        this.closeResource(rs, st);
        try {
            boolean complete = true;
            st = conn.createStatement();
            for (String objectName : objectNameList) {
                String prefix = schemaPrefix ? schema + "." : "";
                String dropSql = "drop " + sqlName + " " + prefix + objectName;
                _log.info((Object)dropSql);
                try {
                    st.execute(dropSql);
                }
                catch (SQLException e) {
                    if (errorContinue) {
                        complete = false;
                        continue;
                    }
                    throw e;
                }
            }
            i$ = complete;
            Object var23_32 = null;
        }
        catch (SQLException e) {
            try {
                String msg = "Failed to drop " + titleName + ": " + objectNameList;
                throw new SQLFailureException(msg, e);
            }
            catch (Throwable throwable) {
                Object var23_33 = null;
                this.closeStatement(st);
                throw throwable;
            }
        }
        this.closeStatement(st);
        return i$;
    }
}

