/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.logic.jdbc.schemadiff;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.torque.engine.EngineException;
import org.apache.torque.engine.database.model.Column;
import org.apache.torque.engine.database.model.Database;
import org.apache.torque.engine.database.model.ForeignKey;
import org.apache.torque.engine.database.model.Index;
import org.apache.torque.engine.database.model.Table;
import org.apache.torque.engine.database.model.Unique;
import org.seasar.dbflute.exception.factory.ExceptionMessageBuilder;
import org.seasar.dbflute.logic.jdbc.schemadiff.DfAbstractDiff;
import org.seasar.dbflute.logic.jdbc.schemadiff.DfColumnDiff;
import org.seasar.dbflute.logic.jdbc.schemadiff.DfConstraintDiff;
import org.seasar.dbflute.logic.jdbc.schemadiff.DfForeignKeyDiff;
import org.seasar.dbflute.logic.jdbc.schemadiff.DfIndexDiff;
import org.seasar.dbflute.logic.jdbc.schemadiff.DfNestDiff;
import org.seasar.dbflute.logic.jdbc.schemadiff.DfNextPreviousDiff;
import org.seasar.dbflute.logic.jdbc.schemadiff.DfPrimaryKeyDiff;
import org.seasar.dbflute.logic.jdbc.schemadiff.DfTableDiff;
import org.seasar.dbflute.logic.jdbc.schemadiff.DfUniqueKeyDiff;
import org.seasar.dbflute.logic.jdbc.schemaxml.DfSchemaXmlReader;
import org.seasar.dbflute.util.DfCollectionUtil;
import org.seasar.dbflute.util.DfSystemUtil;
import org.seasar.dbflute.util.DfTypeUtil;
import org.seasar.dbflute.util.Srl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DfSchemaDiff
extends DfAbstractDiff {
    public static final String DIFF_DATE_KEY = "diffDate";
    public static final String DIFF_DATE_PATTERN = "yyyy/MM/dd HH:mm:ss";
    public static final String COMMENT_KEY = "comment";
    public static final String TABLE_COUNT_KEY = "tableCount";
    public static final String TABLE_DIFF_KEY = "tableDiff";
    protected Database _nextDb;
    protected Database _previousDb;
    protected Integer _previousTableCount;
    protected boolean _firstTime;
    protected boolean _loadingFailure;
    protected Date _diffDate;
    protected String _comment;
    protected DfNextPreviousDiff _tableCountDiff;
    protected final List<DfTableDiff> _tableDiffAllList = DfCollectionUtil.newArrayList();
    protected final List<DfTableDiff> _addedTableDiffList = DfCollectionUtil.newArrayList();
    protected final List<DfTableDiff> _changedTableDiffList = DfCollectionUtil.newArrayList();
    protected final List<DfTableDiff> _deletedTableDiffList = DfCollectionUtil.newArrayList();
    protected List<DfAbstractDiff.NestDiffSetupper> _nestDiffList = DfCollectionUtil.newArrayList();
    protected boolean _latest;

    public DfSchemaDiff() {
        this._nestDiffList.add(new DfAbstractDiff.NestDiffSetupper(){

            @Override
            public String propertyName() {
                return DfSchemaDiff.TABLE_DIFF_KEY;
            }

            @Override
            public List<? extends DfNestDiff> provide() {
                return DfSchemaDiff.this._tableDiffAllList;
            }

            @Override
            public void setup(Map<String, Object> diff) {
                DfSchemaDiff.this.addTableDiff(DfSchemaDiff.this.createTableDiff(diff));
            }
        });
    }

    public void loadPreviousSchema() {
        DfSchemaXmlReader reader = this.createSchemaXmlReader();
        try {
            reader.read();
        }
        catch (FileNotFoundException normal) {
            this._firstTime = true;
            return;
        }
        catch (IOException e) {
            this._loadingFailure = true;
            this.handleException(e);
        }
        try {
            this._previousDb = reader.getSchemaData().getDatabase();
        }
        catch (EngineException e) {
            this._loadingFailure = true;
            this.handleException((Exception)((Object)e));
        }
        this._previousTableCount = this._previousDb.getTableList().size();
    }

    public void loadNextSchema() {
        if (this.isFirstTime()) {
            String msg = "You should not call this because of first time.";
            throw new IllegalStateException(msg);
        }
        if (this._previousDb == null) {
            String msg = "You should not call this because of previous not loaded.";
            throw new IllegalStateException(msg);
        }
        DfSchemaXmlReader reader = this.createSchemaXmlReader();
        try {
            reader.read();
        }
        catch (IOException e) {
            this.handleException(e);
        }
        try {
            this._nextDb = reader.getSchemaData().getDatabase();
        }
        catch (EngineException e) {
            this.handleException((Exception)((Object)e));
        }
        this._diffDate = new Date(DfSystemUtil.currentTimeMillis());
        int nextTableCount = this._nextDb.getTableList().size();
        this._tableCountDiff = this.createNextPreviousDiff(nextTableCount, this._previousTableCount);
    }

    protected void handleException(Exception e) {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("Failed to load schema XML.");
        br.addItem("SchemaXML");
        br.addElement((Object)this.getSchemaXmlFilePath());
        br.addItem("DatabaseType");
        br.addElement((Object)this.getDatabaseType());
        br.addItem("Exception");
        br.addElement((Object)e.getClass().getName());
        br.addElement((Object)e.getMessage());
        String msg = br.buildExceptionMessage();
        throw new IllegalStateException(msg, e);
    }

    public void analyzeDiff() {
        this.processAddedTable();
        this.processChangedTable();
        this.processDeletedTable();
    }

    protected void processAddedTable() {
        List<Table> tableList = this._nextDb.getTableList();
        for (Table table : tableList) {
            Table found = this.findPreviousTable(table);
            if (found != null && this.isSameTableName(table, found)) continue;
            this.addTableDiff(DfTableDiff.createAdded(table.getName()));
        }
    }

    protected void processChangedTable() {
        List<Table> tableList = this._nextDb.getTableList();
        for (Table next : tableList) {
            Table previous = this.findPreviousTable(next);
            if (previous == null || !this.isSameTableName(next, previous)) continue;
            DfTableDiff tableDiff = DfTableDiff.createChanged(next.getName());
            this.diffNextPrevious(next, previous, tableDiff, new DfAbstractDiff.StringNextPreviousDiffer<Table, DfTableDiff>(){

                @Override
                public String provide(Table obj) {
                    return obj.getUnifiedSchema().getCatalogSchema();
                }

                @Override
                public void diff(DfTableDiff diff, DfNextPreviousDiff nextPreviousDiff) {
                    diff.setUnifiedSchemaDiff(nextPreviousDiff);
                }
            });
            this.diffNextPrevious(next, previous, tableDiff, new DfAbstractDiff.StringNextPreviousDiffer<Table, DfTableDiff>(){

                @Override
                public String provide(Table obj) {
                    return obj.getType();
                }

                @Override
                public void diff(DfTableDiff diff, DfNextPreviousDiff nextPreviousDiff) {
                    diff.setObjectTypeDiff(nextPreviousDiff);
                }
            });
            this.processColumn(tableDiff, next, previous);
            this.processPrimaryKey(tableDiff, next, previous);
            this.processForeignKey(tableDiff, next, previous);
            this.processUniqueKey(tableDiff, next, previous);
            this.processIndex(tableDiff, next, previous);
            if (!tableDiff.hasDiff()) continue;
            this.addTableDiff(tableDiff);
        }
    }

    protected void processDeletedTable() {
        List<Table> tableList = this._previousDb.getTableList();
        for (Table table : tableList) {
            Table found = this.findNextTable(table);
            if (found != null && this.isSameTableName(table, found)) continue;
            this.addTableDiff(DfTableDiff.createDeleted(table.getName()));
        }
    }

    protected <TYPE> void diffNextPrevious(Table next, Table previous, DfTableDiff diff, DfAbstractDiff.NextPreviousDiffer<Table, DfTableDiff, TYPE> setupper) {
        TYPE previousValue;
        TYPE nextValue = setupper.provide(next);
        if (!setupper.isMatch(nextValue, previousValue = setupper.provide(previous))) {
            setupper.diff(diff, this.createNextPreviousDiff(nextValue.toString(), previousValue.toString()));
        }
    }

    protected boolean isSameTableName(Table next, Table previous) {
        return this.isSame(next.getName(), previous.getName());
    }

    protected void processColumn(DfTableDiff tableDiff, Table nextTable, Table previousTable) {
        this.processAddedColumn(tableDiff, nextTable, previousTable);
        this.processChangedColumn(tableDiff, nextTable, previousTable);
        this.processDeletedColumn(tableDiff, nextTable, previousTable);
    }

    protected void processAddedColumn(DfTableDiff tableDiff, Table nextTable, Table previousTable) {
        List<Column> columnList = nextTable.getColumnList();
        for (Column column : columnList) {
            Column found = previousTable.getColumn(column.getName());
            if (found != null && this.isSameColumnName(column, found)) continue;
            tableDiff.addColumnDiff(DfColumnDiff.createAdded(column.getName()));
        }
    }

    protected void processChangedColumn(DfTableDiff tableDiff, Table nextTable, Table previousTable) {
        List<Column> columnList = nextTable.getColumnList();
        for (Column next : columnList) {
            Column previous = previousTable.getColumn(next.getName());
            if (previous == null || !this.isSameColumnName(next, previous)) continue;
            DfColumnDiff columnDiff = DfColumnDiff.createChanged(next.getName());
            this.diffNextPrevious(next, previous, columnDiff, new DfAbstractDiff.StringNextPreviousDiffer<Column, DfColumnDiff>(){

                @Override
                public String provide(Column obj) {
                    return obj.getDbType();
                }

                @Override
                public void diff(DfColumnDiff diff, DfNextPreviousDiff nextPreviousDiff) {
                    diff.setDbTypeDiff(nextPreviousDiff);
                }
            });
            this.diffNextPrevious(next, previous, columnDiff, new DfAbstractDiff.StringNextPreviousDiffer<Column, DfColumnDiff>(){

                @Override
                public String provide(Column obj) {
                    return obj.getColumnSize();
                }

                @Override
                public void diff(DfColumnDiff diff, DfNextPreviousDiff nextPreviousDiff) {
                    diff.setColumnSizeDiff(nextPreviousDiff);
                }
            });
            this.diffNextPrevious(next, previous, columnDiff, new DfAbstractDiff.StringNextPreviousDiffer<Column, DfColumnDiff>(){

                @Override
                public String provide(Column obj) {
                    return obj.getDefaultValue();
                }

                @Override
                public boolean isMatch(String next, String previous) {
                    boolean bothValid;
                    if (super.isMatch(next, previous)) {
                        return true;
                    }
                    boolean bl = bothValid = next != null && previous != null;
                    return bothValid && DfSchemaDiff.this.getBasicProperties().isDatabaseH2() && Srl.hasKeywordAllIgnoreCase((String)"SYSTEM_SEQUENCE", (String[])new String[]{next, previous});
                }

                @Override
                public void diff(DfColumnDiff diff, DfNextPreviousDiff nextPreviousDiff) {
                    diff.setDefaultValueDiff(nextPreviousDiff);
                }
            });
            this.diffNextPrevious(next, previous, columnDiff, new DfAbstractDiff.BooleanNextPreviousDiffer<Column, DfColumnDiff>(){

                @Override
                public Boolean provide(Column obj) {
                    return obj.isNotNull();
                }

                @Override
                public void diff(DfColumnDiff diff, DfNextPreviousDiff nextPreviousDiff) {
                    diff.setNotNullDiff(nextPreviousDiff);
                }
            });
            this.diffNextPrevious(next, previous, columnDiff, new DfAbstractDiff.BooleanNextPreviousDiffer<Column, DfColumnDiff>(){

                @Override
                public Boolean provide(Column obj) {
                    return obj.isAutoIncrement();
                }

                @Override
                public void diff(DfColumnDiff diff, DfNextPreviousDiff nextPreviousDiff) {
                    diff.setAutoIncrementDiff(nextPreviousDiff);
                }
            });
            if (!columnDiff.hasDiff()) continue;
            tableDiff.addColumnDiff(columnDiff);
        }
    }

    protected void processDeletedColumn(DfTableDiff tableDiff, Table nextTable, Table previousTable) {
        List<Column> columnList = previousTable.getColumnList();
        for (Column column : columnList) {
            Column found = nextTable.getColumn(column.getName());
            if (found != null && this.isSameColumnName(column, found)) continue;
            tableDiff.addColumnDiff(DfColumnDiff.createDeleted(column.getName()));
        }
    }

    protected <ITEM, TYPE> void diffNextPrevious(Column next, Column previous, DfColumnDiff diff, DfAbstractDiff.NextPreviousDiffer<Column, DfColumnDiff, TYPE> differ) {
        TYPE previousValue;
        TYPE nextValue = differ.provide(next);
        if (!differ.isMatch(nextValue, previousValue = differ.provide(previous))) {
            String nextStr = nextValue != null ? nextValue.toString() : null;
            String previousStr = previousValue != null ? previousValue.toString() : null;
            differ.diff(diff, this.createNextPreviousDiff(nextStr, previousStr));
        }
    }

    protected boolean isSameColumnName(Column next, Column previous) {
        return this.isSame(next.getName(), previous.getName());
    }

    protected void processPrimaryKey(DfTableDiff tableDiff, Table nextTable, Table previousTable) {
        DfPrimaryKeyDiff primaryKeyDiff;
        String constraintName;
        if (!nextTable.hasPrimaryKey() && !previousTable.hasPrimaryKey()) {
            return;
        }
        String noNamePKName = "(PK)";
        String nextName = nextTable.getPrimaryKeyConstraintName();
        String previousName = previousTable.getPrimaryKeyConstraintName();
        if (nextName == null && previousName == null) {
            if (this.hasSameStructurePrimaryKey(nextTable, previousTable)) {
                return;
            }
            constraintName = "(PK)";
            primaryKeyDiff = DfPrimaryKeyDiff.createChanged("(PK)");
            this.processPrimaryKeyColumnDiff(tableDiff, nextTable, previousTable, primaryKeyDiff, "(PK)");
        }
        String string = constraintName = nextName != null ? nextName : "(PK)";
        if (this.isSame(nextName, previousName)) {
            primaryKeyDiff = DfPrimaryKeyDiff.createChanged(constraintName);
            this.processPrimaryKeyColumnDiff(tableDiff, nextTable, previousTable, primaryKeyDiff, constraintName);
        } else {
            if (this.hasSameStructurePrimaryKey(nextTable, previousTable)) {
                return;
            }
            if (nextName == null) {
                tableDiff.addPrimaryKeyDiff(DfPrimaryKeyDiff.createDeleted(previousName));
                return;
            }
            if (previousName == null) {
                tableDiff.addPrimaryKeyDiff(DfPrimaryKeyDiff.createAdded(nextName));
                return;
            }
            primaryKeyDiff = DfPrimaryKeyDiff.createChanged(constraintName);
            DfNextPreviousDiff nameDiff = this.createNextPreviousDiff(nextName, previousName);
            primaryKeyDiff.setNameDiff(nameDiff);
            this.processPrimaryKeyColumnDiff(tableDiff, nextTable, previousTable, primaryKeyDiff, constraintName);
        }
    }

    protected boolean hasSameStructurePrimaryKey(Table nextTable, Table previousTable) {
        String nextCommaString = nextTable.getPrimaryKeyNameCommaString();
        String previousCommaString = previousTable.getPrimaryKeyNameCommaString();
        return Srl.equalsPlain((String)nextCommaString, (String[])new String[]{previousCommaString});
    }

    protected void processPrimaryKeyColumnDiff(DfTableDiff tableDiff, Table nextTable, Table previousTable, DfPrimaryKeyDiff primaryKeyDiff, String constraintName) {
        String previousColumn;
        String nextColumn = nextTable.getPrimaryKeyNameCommaString();
        if (!this.isSame(nextColumn, previousColumn = previousTable.getPrimaryKeyNameCommaString())) {
            DfNextPreviousDiff columnDiff = this.createNextPreviousDiff(nextColumn, previousColumn);
            primaryKeyDiff.setColumnDiff(columnDiff);
        }
        if (primaryKeyDiff.hasDiff()) {
            tableDiff.addPrimaryKeyDiff(primaryKeyDiff);
        }
    }

    protected void processForeignKey(DfTableDiff tableDiff, Table nextTable, Table previousTable) {
        this.processConstraintKey(nextTable, previousTable, new ForeignKeyDiffer(tableDiff));
    }

    protected void processUniqueKey(DfTableDiff tableDiff, Table nextTable, Table previousTable) {
        this.processConstraintKey(nextTable, previousTable, new UniqueKeyDiffer(tableDiff));
    }

    protected void processIndex(DfTableDiff tableDiff, Table nextTable, Table previousTable) {
        this.processConstraintKey(nextTable, previousTable, new IndexDiffer(tableDiff));
    }

    protected <KEY, DIFF extends DfConstraintDiff> void processConstraintKey(Table nextTable, Table previousTable, ConstraintKeyDiffer<KEY, DIFF> differ) {
        String previousName;
        String nextName;
        List<KEY> keyList = differ.keyList(nextTable);
        Set sameStructureNextSet = DfCollectionUtil.newHashSet();
        Map nextPreviousMap = DfCollectionUtil.newLinkedHashMap();
        Map previousNextMap = DfCollectionUtil.newLinkedHashMap();
        block0: for (KEY nextKey : keyList) {
            nextName = differ.constraintName(nextKey);
            if (nextName == null) continue;
            for (Object previousKey : differ.keyList(previousTable)) {
                previousName = differ.constraintName(previousKey);
                if (!differ.isSameConstraintName(nextName, previousName)) continue;
                nextPreviousMap.put(nextName, previousKey);
                previousNextMap.put(previousName, nextKey);
                continue block0;
            }
        }
        block2: for (KEY nextKey : keyList) {
            nextName = differ.constraintName(nextKey);
            if (nextName == null || nextPreviousMap.containsKey(nextName)) continue;
            for (Object previousKey : differ.keyList(previousTable)) {
                previousName = differ.constraintName(previousKey);
                if (previousNextMap.containsKey(previousName) || !differ.isSameStructure(nextKey, previousKey)) continue;
                nextPreviousMap.put(nextName, previousKey);
                previousNextMap.put(previousName, nextKey);
                sameStructureNextSet.add(nextName);
                continue block2;
            }
        }
        Set entrySet = nextPreviousMap.entrySet();
        for (Map.Entry entry : entrySet) {
            Object previousKey;
            String nextName2 = (String)entry.getKey();
            if (sameStructureNextSet.contains(nextName2)) continue;
            previousKey = entry.getValue();
            previousName = differ.constraintName(previousKey);
            Object nextKey = previousNextMap.get(previousName);
            this.processChangedConstraintKeyDiff(nextKey, previousKey, nextName2, previousName, differ);
        }
        this.processAddedConstraintKey(nextTable, differ, nextPreviousMap);
        this.processDeletedConstraintKey(previousTable, differ, previousNextMap);
    }

    protected <KEY, DIFF extends DfConstraintDiff> void processChangedConstraintKeyDiff(KEY nextKey, KEY previousKey, String nextName, String previousName, ConstraintKeyDiffer<KEY, DIFF> differ) {
        if (differ.isSameConstraintName(nextName, previousName)) {
            String nextColumn = differ.column(nextKey);
            String previousColumn = differ.column(previousKey);
            DfNextPreviousDiff columnDiff = null;
            if (!this.isSame(nextColumn, previousColumn)) {
                columnDiff = this.createNextPreviousDiff(nextColumn, previousColumn);
            }
            DIFF diff = differ.createChangedDiff(nextName);
            ((DfConstraintDiff)diff).setColumnDiff(columnDiff);
            differ.diff(diff, nextKey, previousKey);
        } else {
            DfNextPreviousDiff nameDiff = this.createNextPreviousDiff(nextName, previousName);
            DIFF diff = differ.createChangedDiff(nextName);
            ((DfConstraintDiff)diff).setNameDiff(nameDiff);
            differ.diff(diff, nextKey, previousKey);
        }
    }

    protected <KEY, DIFF extends DfConstraintDiff> void processAddedConstraintKey(Table nextTable, ConstraintKeyDiffer<KEY, DIFF> differ, Map<String, KEY> nextPreviousMap) {
        List<KEY> keyList = differ.keyList(nextTable);
        for (KEY nextKey : keyList) {
            String nextName = differ.constraintName(nextKey);
            if (nextPreviousMap.containsKey(nextName)) continue;
            DIFF diff = differ.createAddedDiff(nextName);
            differ.diff(diff, nextKey, null);
        }
    }

    protected <KEY, DIFF extends DfConstraintDiff> void processDeletedConstraintKey(Table previousTable, ConstraintKeyDiffer<KEY, DIFF> differ, Map<String, KEY> previousNextMap) {
        List<KEY> keyList = differ.keyList(previousTable);
        for (KEY previousKey : keyList) {
            String previousName = differ.constraintName(previousKey);
            if (previousNextMap.containsKey(previousName)) continue;
            DIFF diff = differ.createDeletedDiff(previousName);
            differ.diff(diff, null, previousKey);
        }
    }

    protected Table findNextTable(Table table) {
        return this._nextDb.getTable(table.getName());
    }

    protected Table findPreviousTable(Table table) {
        return this._previousDb.getTable(table.getName());
    }

    public Map<String, Object> createSchemaDiffMap() {
        Map schemaDiffMap = DfCollectionUtil.newLinkedHashMap();
        schemaDiffMap.put(DIFF_DATE_KEY, DfTypeUtil.toString((Object)this._diffDate, (String)DIFF_DATE_PATTERN));
        schemaDiffMap.put(TABLE_COUNT_KEY, this._tableCountDiff.createNextPreviousDiffMap());
        List<DfAbstractDiff.NestDiffSetupper> nestDiffList = this._nestDiffList;
        for (DfAbstractDiff.NestDiffSetupper setupper : nestDiffList) {
            List<? extends DfNestDiff> diffAllList = setupper.provide();
            if (diffAllList.isEmpty()) continue;
            Map diffMap = DfCollectionUtil.newLinkedHashMap();
            schemaDiffMap.put(setupper.propertyName(), diffMap);
            for (DfNestDiff dfNestDiff : diffAllList) {
                if (!dfNestDiff.hasDiff()) continue;
                diffMap.put(dfNestDiff.getKeyName(), dfNestDiff.createDiffMap());
            }
        }
        return schemaDiffMap;
    }

    public void acceptSchemaDiffMap(Map<String, Object> schemaDiffMap) {
        Set<Map.Entry<String, Object>> entrySet = schemaDiffMap.entrySet();
        for (Map.Entry<String, Object> entry : entrySet) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (DIFF_DATE_KEY.equals(key)) {
                this._diffDate = DfTypeUtil.toDate((Object)value, (String)DIFF_DATE_PATTERN);
                this.assertDiffDateExists(key, this._diffDate, schemaDiffMap);
                continue;
            }
            if (COMMENT_KEY.equals(key)) {
                this._comment = (String)value;
                continue;
            }
            if (TABLE_COUNT_KEY.equals(key)) {
                this._tableCountDiff = this.restoreNextPreviousDiff(schemaDiffMap, key);
                this.assertTableCountExists(key, this._tableCountDiff, schemaDiffMap);
                continue;
            }
            List<DfAbstractDiff.NestDiffSetupper> nestDiffList = this._nestDiffList;
            for (DfAbstractDiff.NestDiffSetupper setupper : nestDiffList) {
                if (!setupper.propertyName().equals(key)) continue;
                this.restoreNestDiff(schemaDiffMap, setupper);
            }
        }
    }

    protected void assertDiffDateExists(String key, Date diffDate, Map<String, Object> schemaDiffMap) {
        if (diffDate == null) {
            String msg = "The diff-date of diff-map is required:";
            msg = msg + " key=" + key + " schemaDiffMap=" + schemaDiffMap;
            throw new IllegalStateException(msg);
        }
    }

    protected void assertTableCountExists(String key, DfNextPreviousDiff nextPreviousDiff, Map<String, Object> schemaDiffMap) {
        if (nextPreviousDiff == null) {
            String msg = "The table count of diff-map is required:";
            msg = msg + " key=" + key + " schemaDiffMap=" + schemaDiffMap;
            throw new IllegalStateException(msg);
        }
    }

    protected void assertNextTableCountExists(String key, String nextTableCount, Map<String, Object> schemaDiffMap) {
        if (nextTableCount == null) {
            String msg = "The next table count of diff-map is required:";
            msg = msg + " key=" + key + " schemaDiffMap=" + schemaDiffMap;
            throw new IllegalStateException(msg);
        }
    }

    protected void assertPreviousTableCountExists(String key, String previousTableCount, Map<String, Object> schemaDiffMap) {
        if (previousTableCount == null) {
            String msg = "The previous table count of diff-map is required:";
            msg = msg + " key=" + key + " schemaDiffMap=" + schemaDiffMap;
            throw new IllegalStateException(msg);
        }
    }

    public boolean hasDiff() {
        List<DfAbstractDiff.NestDiffSetupper> nestDiffList = this._nestDiffList;
        for (DfAbstractDiff.NestDiffSetupper setupper : nestDiffList) {
            List<? extends DfNestDiff> diffAllList = setupper.provide();
            for (DfNestDiff dfNestDiff : diffAllList) {
                if (!dfNestDiff.hasDiff()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isFirstTime() {
        return this._firstTime;
    }

    public boolean isLoadingFailure() {
        return this._loadingFailure;
    }

    protected DfSchemaXmlReader createSchemaXmlReader() {
        return new DfSchemaXmlReader(this.getSchemaXmlFilePath(), this.getDatabaseType());
    }

    protected String getSchemaXmlFilePath() {
        return this.getBasicProperties().getProejctSchemaXMLFilePath();
    }

    protected String getDatabaseType() {
        return this.getBasicProperties().getDatabaseType();
    }

    public String getDiffDate() {
        return DfTypeUtil.toString((Object)this._diffDate, (String)DIFF_DATE_PATTERN);
    }

    public boolean hasComment() {
        return Srl.is_NotNull_and_NotTrimmedEmpty((String)this._comment);
    }

    public String getComment() {
        return this._comment;
    }

    public DfNextPreviousDiff getTableCount() {
        return this._tableCountDiff;
    }

    public List<DfTableDiff> getTableDiffAllList() {
        return this._tableDiffAllList;
    }

    public List<DfTableDiff> getAddedTableDiffList() {
        return this._addedTableDiffList;
    }

    public List<DfTableDiff> getChangedTableDiffList() {
        return this._changedTableDiffList;
    }

    public List<DfTableDiff> getDeletedTableDiffList() {
        return this._deletedTableDiffList;
    }

    public void addTableDiff(DfTableDiff tableDiff) {
        this._tableDiffAllList.add(tableDiff);
        if (tableDiff.isAdded()) {
            this._addedTableDiffList.add(tableDiff);
        } else if (tableDiff.isChanged()) {
            this._changedTableDiffList.add(tableDiff);
        } else if (tableDiff.isDeleted()) {
            this._deletedTableDiffList.add(tableDiff);
        } else {
            String msg = "Unknown diff-type of table: ";
            msg = msg + " diffType=" + (Object)((Object)tableDiff.getDiffType());
            msg = msg + " tableDiff=" + tableDiff;
            throw new IllegalStateException(msg);
        }
    }

    public void setLatest(boolean latest) {
        this._latest = latest;
    }

    public boolean isLatest() {
        return this._latest;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected abstract class BasicConstraintKeyDiffer<KEY, DIFF extends DfConstraintDiff>
    implements ConstraintKeyDiffer<KEY, DIFF> {
        protected DfTableDiff _tableDiff;

        public BasicConstraintKeyDiffer(DfTableDiff tableDiff) {
            this._tableDiff = tableDiff;
        }

        protected String buildCommaString(Collection<String> values) {
            StringBuilder sb = new StringBuilder();
            int index = 0;
            for (String value : values) {
                if (index > 0) {
                    sb.append(", ");
                }
                sb.append(value);
                ++index;
            }
            return sb.toString();
        }

        @Override
        public boolean isSameConstraintName(String next, String previous) {
            return DfSchemaDiff.this.isSame(next, previous);
        }

        @Override
        public boolean isSameStructure(KEY next, KEY previous) {
            return DfSchemaDiff.this.isSame(this.column(next), this.column(previous));
        }

        protected String extractConstraintName(KEY nextKey, KEY previousKey) {
            return nextKey != null ? this.constraintName(nextKey) : this.constraintName(previousKey);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static interface ConstraintKeyDiffer<KEY, DIFF extends DfConstraintDiff> {
        public List<KEY> keyList(Table var1);

        public String constraintName(KEY var1);

        public String column(KEY var1);

        public boolean isSameConstraintName(String var1, String var2);

        public boolean isSameStructure(KEY var1, KEY var2);

        public void diff(DIFF var1, KEY var2, KEY var3);

        public DIFF createAddedDiff(String var1);

        public DIFF createChangedDiff(String var1);

        public DIFF createDeletedDiff(String var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class IndexDiffer
    extends BasicConstraintKeyDiffer<Index, DfIndexDiff> {
        public IndexDiffer(DfTableDiff tableDiff) {
            super(tableDiff);
        }

        @Override
        public String constraintName(Index key) {
            return key.getName();
        }

        @Override
        public List<Index> keyList(Table table) {
            return table.getIndexList();
        }

        @Override
        public String column(Index key) {
            return this.buildCommaString(key.getIndexColumnMap().values());
        }

        @Override
        public void diff(DfIndexDiff diff, Index nextKey, Index previousKey) {
            if (diff.hasDiff()) {
                this._tableDiff.addIndexDiff(diff);
            }
        }

        @Override
        public DfIndexDiff createAddedDiff(String constraintName) {
            return DfIndexDiff.createAdded(constraintName);
        }

        @Override
        public DfIndexDiff createChangedDiff(String constraintName) {
            return DfIndexDiff.createChanged(constraintName);
        }

        @Override
        public DfIndexDiff createDeletedDiff(String constraintName) {
            return DfIndexDiff.createDeleted(constraintName);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class UniqueKeyDiffer
    extends BasicConstraintKeyDiffer<Unique, DfUniqueKeyDiff> {
        public UniqueKeyDiffer(DfTableDiff tableDiff) {
            super(tableDiff);
        }

        @Override
        public String constraintName(Unique key) {
            return key.getName();
        }

        @Override
        public List<Unique> keyList(Table table) {
            return table.getUniqueList();
        }

        @Override
        public String column(Unique key) {
            return this.buildCommaString(key.getIndexColumnMap().values());
        }

        @Override
        public void diff(DfUniqueKeyDiff diff, Unique nextKey, Unique previousKey) {
            if (diff.hasDiff()) {
                this._tableDiff.addUniqueKeyDiff(diff);
            }
        }

        @Override
        public DfUniqueKeyDiff createAddedDiff(String constraintName) {
            return DfUniqueKeyDiff.createAdded(constraintName);
        }

        @Override
        public DfUniqueKeyDiff createChangedDiff(String constraintName) {
            return DfUniqueKeyDiff.createChanged(constraintName);
        }

        @Override
        public DfUniqueKeyDiff createDeletedDiff(String constraintName) {
            return DfUniqueKeyDiff.createDeleted(constraintName);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ForeignKeyDiffer
    extends BasicConstraintKeyDiffer<ForeignKey, DfForeignKeyDiff> {
        public ForeignKeyDiffer(DfTableDiff tableDiff) {
            super(tableDiff);
        }

        @Override
        public String constraintName(ForeignKey key) {
            return key.getName();
        }

        @Override
        public List<ForeignKey> keyList(Table table) {
            return DfCollectionUtil.newArrayList((Object[])table.getForeignKeys());
        }

        @Override
        public String column(ForeignKey key) {
            return key.getLocalColumnNameCommaString();
        }

        @Override
        public boolean isSameStructure(ForeignKey next, ForeignKey previous) {
            return DfSchemaDiff.this.isSame(this.column(next), this.column(previous)) && DfSchemaDiff.this.isSame(next.getForeignTable().getName(), previous.getForeignTable().getName());
        }

        @Override
        public void diff(DfForeignKeyDiff diff, ForeignKey nextKey, ForeignKey previousKey) {
            String previousFKTable;
            String nextFKTable;
            if (nextKey != null && previousKey != null && !DfSchemaDiff.this.isSame(nextFKTable = nextKey.getForeignTableName(), previousFKTable = previousKey.getForeignTableName())) {
                DfNextPreviousDiff fkTableDiff = DfSchemaDiff.this.createNextPreviousDiff(nextFKTable, previousFKTable);
                diff.setForeignTableDiff(fkTableDiff);
            }
            if (diff.hasDiff()) {
                this._tableDiff.addForeignKeyDiff(diff);
            }
        }

        @Override
        public DfForeignKeyDiff createAddedDiff(String constraintName) {
            return DfForeignKeyDiff.createAdded(constraintName);
        }

        @Override
        public DfForeignKeyDiff createChangedDiff(String constraintName) {
            return DfForeignKeyDiff.createChanged(constraintName);
        }

        @Override
        public DfForeignKeyDiff createDeletedDiff(String constraintName) {
            return DfForeignKeyDiff.createDeleted(constraintName);
        }
    }
}

