/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.logic.jdbc.handler;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.torque.engine.database.model.UnifiedSchema;
import org.seasar.dbflute.exception.DfIllegalPropertySettingException;
import org.seasar.dbflute.logic.jdbc.handler.DfAbstractMetaDataHandler;
import org.seasar.dbflute.logic.jdbc.metadata.info.DfForeignKeyMetaInfo;
import org.seasar.dbflute.logic.jdbc.metadata.info.DfTableMetaInfo;
import org.seasar.dbflute.util.Srl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DfForeignKeyHandler
extends DfAbstractMetaDataHandler {
    private static final Log _log = LogFactory.getLog(DfForeignKeyHandler.class);
    protected Map<String, DfTableMetaInfo> _generatedTableMap;

    public Map<String, DfForeignKeyMetaInfo> getForeignKeyMap(DatabaseMetaData metaData, DfTableMetaInfo tableInfo) throws SQLException {
        UnifiedSchema unifiedSchema = tableInfo.getUnifiedSchema();
        String tableName = tableInfo.getTableName();
        return this.getForeignKeyMap(metaData, unifiedSchema, tableName);
    }

    public Map<String, DfForeignKeyMetaInfo> getForeignKeyMap(DatabaseMetaData metaData, UnifiedSchema unifiedSchema, String tableName) throws SQLException {
        Map<String, DfForeignKeyMetaInfo> resultMap = this.doGetForeignKeyMetaInfo(metaData, unifiedSchema, tableName);
        if (resultMap.isEmpty()) {
            resultMap = this.doGetForeignKeyMetaInfo(metaData, unifiedSchema, tableName.toLowerCase());
        }
        if (resultMap.isEmpty()) {
            resultMap = this.doGetForeignKeyMetaInfo(metaData, unifiedSchema, tableName.toUpperCase());
        }
        return resultMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Map<String, DfForeignKeyMetaInfo> doGetForeignKeyMetaInfo(DatabaseMetaData dbMeta, UnifiedSchema unifiedSchema, String tableName) throws SQLException {
        LinkedHashMap<String, String> exceptedFKMap;
        LinkedHashMap<String, DfForeignKeyMetaInfo> fkMap;
        block12: {
            fkMap = this.newLinkedHashMap();
            if (this.isForeignKeyExtractingUnsupported()) {
                return fkMap;
            }
            exceptedFKMap = this.newLinkedHashMap();
            ResultSet rs = null;
            try {
                String catalogName = unifiedSchema.getPureCatalog();
                String schemaName = unifiedSchema.getPureSchema();
                rs = dbMeta.getImportedKeys(catalogName, schemaName, tableName);
                while (rs.next()) {
                    String fkName;
                    String localTableName = rs.getString(7);
                    if (this.checkMetaTableDiffIfNeeds(tableName, localTableName)) continue;
                    String foreignCatalogName = rs.getString(1);
                    String foreignSchemaName = rs.getString(2);
                    String foreignTableName = rs.getString(3);
                    String foreignColumnName = rs.getString(4);
                    String localColumnName = rs.getString(8);
                    String fkPlainName = rs.getString(12);
                    if (Srl.is_NotNull_and_NotTrimmedEmpty((String)fkPlainName)) {
                        fkName = fkPlainName;
                    } else {
                        fkName = "FK_" + tableName + "_" + localColumnName + "_" + foreignTableName;
                        _log.info((Object)("...Making FK name (because of no name): " + fkName));
                    }
                    if (!this.isForeignTableGenerated(foreignTableName)) {
                        exceptedFKMap.put(fkName, foreignTableName);
                        continue;
                    }
                    this.assertFKColumnNotExcepted(unifiedSchema, tableName, localColumnName);
                    UnifiedSchema foreignSchema = this.createAsDynamicSchema(foreignCatalogName, foreignSchemaName);
                    this.assertPKColumnNotExcepted(foreignSchema, foreignTableName, foreignColumnName);
                    DfForeignKeyMetaInfo metaInfo = (DfForeignKeyMetaInfo)fkMap.get(fkName);
                    if (metaInfo == null) {
                        metaInfo = new DfForeignKeyMetaInfo();
                        fkMap.put(fkName, metaInfo);
                    } else {
                        String secondName;
                        String firstName = metaInfo.getForeignTableName();
                        if (firstName.equalsIgnoreCase(secondName = foreignTableName)) {
                            metaInfo.putColumnNameMap(localColumnName, foreignColumnName);
                            continue;
                        }
                        String msgBase = "...Handling same-name FK ";
                        if (this.judgeSameNameForeignKey(tableName, firstName, secondName)) {
                            _log.info((Object)("...Handling same-name FK (use first one): " + fkName + " to " + firstName));
                            continue;
                        }
                        _log.info((Object)("...Handling same-name FK (use second one): " + fkName + " to " + secondName));
                    }
                    metaInfo.setForeignKeyName(fkName);
                    metaInfo.setLocalTableName(localTableName);
                    metaInfo.setForeignTableName(foreignTableName);
                    metaInfo.putColumnNameMap(localColumnName, foreignColumnName);
                }
                Object var22_21 = null;
                if (rs == null) break block12;
            }
            catch (Throwable throwable) {
                Object var22_22 = null;
                if (rs != null) {
                    rs.close();
                }
                throw throwable;
            }
            rs.close();
        }
        this.handleExceptedForeignKey(exceptedFKMap, tableName);
        return this.filterSameStructureForeignKey(fkMap);
    }

    protected void assertFKColumnNotExcepted(UnifiedSchema unifiedSchema, String tableName, String columnName) {
        if (this.isColumnExcept(unifiedSchema, tableName, columnName)) {
            String msg = "FK columns are unsupported on 'columnExcept' property:";
            msg = msg + " unifiedSchema=" + unifiedSchema;
            msg = msg + " tableName=" + tableName;
            msg = msg + " columnName=" + columnName;
            throw new DfIllegalPropertySettingException(msg);
        }
    }

    protected void assertPKColumnNotExcepted(UnifiedSchema unifiedSchema, String tableName, String columnName) {
        if (this.isColumnExcept(unifiedSchema, tableName, columnName)) {
            String msg = "PK columns are unsupported on 'columnExcept' property:";
            msg = msg + " unifiedSchema=" + unifiedSchema;
            msg = msg + " tableName=" + tableName;
            msg = msg + " columnName=" + columnName;
            throw new DfIllegalPropertySettingException(msg);
        }
    }

    protected boolean judgeSameNameForeignKey(String localName, String firstName, String secondName) {
        DfTableMetaInfo localInfo = this.getTableInfo(localName);
        DfTableMetaInfo firstInfo = this.getTableInfo(firstName);
        DfTableMetaInfo secondInfo = this.getTableInfo(secondName);
        if (localInfo != null && firstInfo != null && secondInfo != null) {
            String localType = localInfo.getTableType();
            if (localType.equals(firstInfo.getTableType())) {
                return true;
            }
            if (localType.equals(secondInfo.getTableType())) {
                return false;
            }
        }
        return true;
    }

    protected void handleExceptedForeignKey(Map<String, String> exceptedFKMap, String localTableName) {
        if (exceptedFKMap.isEmpty()) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("...Excepting foreign keys (refers to non-generated table):");
        sb.append(this.ln()).append("[Excepted Foreign Key]");
        Set<Map.Entry<String, String>> entrySet = exceptedFKMap.entrySet();
        for (Map.Entry<String, String> entry : entrySet) {
            String fkName = entry.getKey();
            String foreignTableName = entry.getValue();
            sb.append(this.ln()).append(" ").append(fkName);
            sb.append(" (").append(localTableName).append(" to ").append(foreignTableName).append(")");
        }
        _log.info((Object)sb.toString());
    }

    protected Map<String, DfForeignKeyMetaInfo> filterSameStructureForeignKey(Map<String, DfForeignKeyMetaInfo> fkMap) {
        LinkedHashMap<String, DfForeignKeyMetaInfo> filteredFKMap = this.newLinkedHashMap();
        LinkedHashMap checkMap = this.newLinkedHashMap();
        Object dummyObj = new Object();
        Set<Map.Entry<String, DfForeignKeyMetaInfo>> entrySet = fkMap.entrySet();
        for (Map.Entry<String, DfForeignKeyMetaInfo> entry : entrySet) {
            String foreinKeyName = entry.getKey();
            DfForeignKeyMetaInfo metaInfo = entry.getValue();
            LinkedHashMap checkKey = this.newLinkedHashMap();
            checkKey.put(metaInfo.getForeignTableName(), dummyObj);
            checkKey.put("columnNameMap:" + metaInfo.getColumnNameMap(), dummyObj);
            if (checkMap.containsKey(checkKey)) {
                String msg = "*The same-structural foreign key was found:";
                msg = msg + " skipped = " + foreinKeyName + " - " + checkKey;
                _log.warn((Object)msg);
                continue;
            }
            checkMap.put(checkKey, dummyObj);
            filteredFKMap.put(foreinKeyName, metaInfo);
        }
        return filteredFKMap;
    }

    public void exceptForeignTableNotGenerated(Map<String, DfTableMetaInfo> generatedTableMap) {
        this._generatedTableMap = generatedTableMap;
    }

    protected boolean isForeignTableGenerated(String foreignTableName) {
        if (this._generatedTableMap == null || this._generatedTableMap.isEmpty()) {
            return true;
        }
        DfTableMetaInfo info = this._generatedTableMap.get(foreignTableName);
        if (info == null) {
            return false;
        }
        return !info.isOutOfGenerateTarget();
    }

    protected DfTableMetaInfo getTableInfo(String tableName) {
        if (this._generatedTableMap == null) {
            return null;
        }
        return this._generatedTableMap.get(tableName);
    }
}

