/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.twowaysql.context.impl;

import java.util.ArrayList;
import java.util.List;
import org.seasar.dbflute.helper.StringKeyMap;
import org.seasar.dbflute.twowaysql.context.CommandContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandContextImpl
implements CommandContext {
    private StringKeyMap<Object> args = StringKeyMap.createAsCaseInsensitive();
    private StringKeyMap<Class<?>> argTypes = StringKeyMap.createAsCaseInsensitive();
    private StringBuilder sqlSb = new StringBuilder(100);
    private List<Object> bindVariables = new ArrayList<Object>();
    private List<Class<?>> bindVariableTypes = new ArrayList();
    private boolean enabled = true;
    private boolean beginChild;
    private boolean alreadySkippedPrefix;
    private CommandContext parent;

    private CommandContextImpl() {
    }

    private CommandContextImpl(CommandContext parent) {
        this.parent = parent;
        this.enabled = false;
    }

    public static CommandContextImpl createCommandContextImplAsRoot() {
        return new CommandContextImpl();
    }

    public static CommandContextImpl createCommandContextImplAsBeginChild(CommandContext parent) {
        return new CommandContextImpl(parent).asBeginChild();
    }

    private CommandContextImpl asBeginChild() {
        this.beginChild = true;
        return this;
    }

    @Override
    public Object getArg(String name) {
        if (this.args.containsKey(name)) {
            return this.args.get(name);
        }
        if (this.parent != null) {
            return this.parent.getArg(name);
        }
        if (this.args.size() == 1) {
            String firstKey = this.args.keySet().iterator().next();
            return this.args.get(firstKey);
        }
        return null;
    }

    @Override
    public Class<?> getArgType(String name) {
        if (this.argTypes.containsKey(name)) {
            return this.argTypes.get(name);
        }
        if (this.parent != null) {
            return this.parent.getArgType(name);
        }
        if (this.argTypes.size() == 1) {
            String firstKey = this.argTypes.keySet().iterator().next();
            return this.argTypes.get(firstKey);
        }
        return null;
    }

    @Override
    public void addArg(String name, Object arg, Class<?> argType) {
        this.args.put(name, arg);
        this.argTypes.put(name, argType);
    }

    @Override
    public String getSql() {
        return this.sqlSb.toString();
    }

    @Override
    public Object[] getBindVariables() {
        return this.bindVariables.toArray(new Object[this.bindVariables.size()]);
    }

    @Override
    public Class<?>[] getBindVariableTypes() {
        return this.bindVariableTypes.toArray(new Class[this.bindVariableTypes.size()]);
    }

    @Override
    public CommandContext addSql(String sql) {
        this.sqlSb.append(sql);
        return this;
    }

    @Override
    public CommandContext addSql(String sql, Object bindVariable, Class<?> bindVariableType) {
        this.sqlSb.append(sql);
        this.bindVariables.add(bindVariable);
        this.bindVariableTypes.add(bindVariableType);
        return this;
    }

    @Override
    public CommandContext addSql(String sql, Object[] bindVariables, Class<?>[] bindVariableTypes) {
        this.sqlSb.append(sql);
        for (int i = 0; i < bindVariables.length; ++i) {
            this.bindVariables.add(bindVariables[i]);
            this.bindVariableTypes.add(bindVariableTypes[i]);
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        sb.append((CharSequence)this.sqlSb).append(", ");
        sb.append(this.enabled).append(", ");
        sb.append(this.alreadySkippedPrefix).append(", ");
        sb.append("parent=").append(this.parent);
        sb.append("}@").append(Integer.toHexString(this.hashCode()));
        return sb.toString();
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public boolean isBeginChildContext() {
        return this.beginChild;
    }

    @Override
    public boolean isAlreadySkippedPrefix() {
        return this.alreadySkippedPrefix;
    }

    @Override
    public void setAlreadySkippedPrefix(boolean alreadySkippedPrefix) {
        this.alreadySkippedPrefix = alreadySkippedPrefix;
    }
}

