/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.logic.jdbc.metadata.various.struct;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.torque.engine.database.model.UnifiedSchema;
import org.seasar.dbflute.helper.StringKeyMap;
import org.seasar.dbflute.helper.jdbc.facade.DfJdbcFacade;
import org.seasar.dbflute.logic.jdbc.metadata.info.DfColumnMetaInfo;
import org.seasar.dbflute.logic.jdbc.metadata.info.DfTypeStructInfo;
import org.seasar.dbflute.util.DfCollectionUtil;
import org.seasar.dbflute.util.Srl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DfStructExtractorOracle {
    private static final Log _log = LogFactory.getLog(DfStructExtractorOracle.class);
    protected final DataSource _dataSource;
    protected boolean _suppressLogging;

    public DfStructExtractorOracle(DataSource dataSource, boolean suppressLogging) {
        this._dataSource = dataSource;
        this._suppressLogging = suppressLogging;
    }

    public StringKeyMap<DfTypeStructInfo> extractStructInfoMap(UnifiedSchema unifiedSchema) {
        List<Map<String, String>> resultList = this.selectStructAttribute(unifiedSchema);
        StringKeyMap structInfoMap = StringKeyMap.createAsFlexibleOrdered();
        for (Map<String, String> map : resultList) {
            String typeName = DfTypeStructInfo.generateTypeName(unifiedSchema, map.get("TYPE_NAME"));
            DfTypeStructInfo info = (DfTypeStructInfo)structInfoMap.get((Object)typeName);
            if (info == null) {
                info = new DfTypeStructInfo(unifiedSchema, typeName);
                structInfoMap.put(typeName, (Object)info);
            }
            DfColumnMetaInfo attributeInfo = new DfColumnMetaInfo();
            String attrName = map.get("ATTR_NAME");
            if (Srl.is_Null_or_TrimmedEmpty((String)attrName)) continue;
            attributeInfo.setColumnName(attrName);
            String attrTypeOwner = map.get("ATTR_TYPE_OWNER");
            String attrTypeName = map.get("ATTR_TYPE_NAME");
            String dbTypeName = Srl.connectPrefix((String)attrTypeName, (String)attrTypeOwner, (String)".");
            attributeInfo.setDbTypeName(dbTypeName);
            String length = map.get("LENGTH");
            if (Srl.is_NotNull_and_NotTrimmedEmpty((String)length)) {
                attributeInfo.setColumnSize(Integer.valueOf(length));
            } else {
                String precision = map.get("PRECISION");
                if (Srl.is_NotNull_and_NotTrimmedEmpty((String)precision)) {
                    attributeInfo.setColumnSize(Integer.valueOf(precision));
                }
            }
            String scale = map.get("SCALE");
            if (Srl.is_NotNull_and_NotTrimmedEmpty((String)scale)) {
                attributeInfo.setDecimalDigits(Integer.valueOf(scale));
            }
            info.putAttributeInfo(attributeInfo);
        }
        return structInfoMap;
    }

    protected List<Map<String, String>> selectStructAttribute(UnifiedSchema unifiedSchema) {
        List<Map<String, String>> resultList;
        DfJdbcFacade facade = new DfJdbcFacade(this._dataSource);
        ArrayList<String> columnList = new ArrayList<String>();
        columnList.add("TYPE_NAME");
        columnList.add("ATTR_NAME");
        columnList.add("ATTR_TYPE_OWNER");
        columnList.add("ATTR_TYPE_NAME");
        columnList.add("LENGTH");
        columnList.add("PRECISION");
        columnList.add("SCALE");
        columnList.add("ATTR_NO");
        String sql = this.buildStructAttributeSql(unifiedSchema);
        try {
            this.log(sql);
            resultList = facade.selectStringList(sql, columnList);
        }
        catch (Exception continued) {
            this.log("Failed to select supplement info: " + continued.getMessage());
            return DfCollectionUtil.emptyList();
        }
        return resultList;
    }

    protected String buildStructAttributeSql(UnifiedSchema unifiedSchema) {
        StringBuilder sb = new StringBuilder();
        sb.append("select *");
        sb.append(" from ALL_TYPE_ATTRS");
        sb.append(" where OWNER = '" + unifiedSchema.getPureSchema() + "'");
        sb.append(" and TYPE_NAME in (");
        sb.append("select TYPE_NAME from ALL_TYPES");
        sb.append(" where OWNER = '" + unifiedSchema.getPureSchema() + "' and TYPECODE = 'OBJECT'");
        sb.append(")");
        sb.append(" order by TYPE_NAME, ATTR_NO");
        return sb.toString();
    }

    protected void log(String msg) {
        if (this._suppressLogging) {
            return;
        }
        _log.info((Object)msg);
    }
}

