/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.friends.torque;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.torque.engine.database.model.Database;
import org.apache.torque.engine.database.model.Table;
import org.apache.torque.engine.database.model.Unique;
import org.seasar.dbflute.DfBuildProperties;
import org.seasar.dbflute.properties.DfAdditionalUniqueKeyProperties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DfAdditionalUniqueKeyInitializer {
    private static final Log _log = LogFactory.getLog(DfAdditionalUniqueKeyInitializer.class);
    protected Database _database;

    public DfAdditionalUniqueKeyInitializer(Database database) {
        this._database = database;
    }

    public void initializeAdditionalUniqueKey() {
        _log.info((Object)"/=======================================");
        _log.info((Object)"...Initializing additional unique keys.");
        Map<String, Map<String, String>> additionalUniqueKeyMap = this.getAdditionalUniqueKeyMap();
        Set<String> primaryNameKeySet = additionalUniqueKeyMap.keySet();
        for (String uniqueKeyName : primaryNameKeySet) {
            String tableName = this.getTableName(uniqueKeyName);
            this.assertTable(tableName);
            List<String> columnNameList = this.getLocalColumnNameList(uniqueKeyName);
            this.assertColumnList(tableName, columnNameList);
            Table table = this.getTable(tableName);
            Unique unique = new Unique();
            unique.setAdditional(true);
            unique.setName(uniqueKeyName);
            unique.setTable(table);
            for (String columnName : columnNameList) {
                unique.addColumn(columnName);
            }
            table.addUnique(unique);
            this.showResult(uniqueKeyName, table, columnNameList);
        }
        _log.info((Object)"==========/");
    }

    protected void showResult(String uniqueKeyName, Table table, List<String> columnNameList) {
        _log.info((Object)("    " + uniqueKeyName));
        if (columnNameList.size() == 1) {
            _log.info((Object)("       Add unique key " + table.getName() + "." + columnNameList.get(0)));
        } else {
            _log.info((Object)("       Add unique key " + table.getName() + "." + columnNameList));
        }
    }

    protected DfAdditionalUniqueKeyProperties getProperties() {
        return DfBuildProperties.getInstance().getAdditionalUniqueKeyProperties();
    }

    protected void assertTable(String tableName) {
        if (this.getTable(tableName) == null) {
            String msg = "Not found table by the tableName: " + tableName;
            msg = msg + " additionalUniqueKeyMap=" + this.getAdditionalUniqueKeyMap();
            throw new IllegalStateException(msg);
        }
    }

    protected void assertColumnList(String tableName, List<String> columnNameList) {
        if (!this.getTable(tableName).containsColumn(columnNameList)) {
            String msg = "Not found column by the columnNames: " + columnNameList;
            msg = msg + " of the table '" + tableName + "'";
            msg = msg + " additionalUniqueKeyMap=" + this.getAdditionalUniqueKeyMap();
            throw new IllegalStateException(msg);
        }
    }

    protected String getTableName(String primaryKeyName) {
        return this.getProperties().findTableName(primaryKeyName);
    }

    protected List<String> getLocalColumnNameList(String primaryKeyName) {
        return this.getProperties().findColumnNameList(primaryKeyName);
    }

    protected Map<String, Map<String, String>> getAdditionalUniqueKeyMap() {
        return this.getProperties().getAdditionalUniqueKeyMap();
    }

    protected Table getTable(String tableName) {
        return this.getDatabase().getTable(tableName);
    }

    protected Table[] getTables() {
        return this.getDatabase().getTables();
    }

    protected Database getDatabase() {
        return this._database;
    }
}

