/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.task.bs;

import java.io.File;
import java.sql.SQLException;
import java.util.List;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tools.ant.Task;
import org.seasar.dbflute.DfBuildProperties;
import org.seasar.dbflute.config.DfEnvironmentType;
import org.seasar.dbflute.friends.torque.DfAntTaskUtil;
import org.seasar.dbflute.helper.jdbc.connection.DfSimpleDataSourceCreator;
import org.seasar.dbflute.helper.jdbc.context.DfDataSourceContext;
import org.seasar.dbflute.logic.outsidesql.DfSqlFileCollector;
import org.seasar.dbflute.logic.scmconn.DfCurrentSchemaConnector;
import org.seasar.dbflute.properties.DfBasicProperties;
import org.seasar.dbflute.properties.DfDatabaseProperties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DfAbstractTask
extends Task {
    private static final Log _log = LogFactory.getLog(DfAbstractTask.class);
    protected String _driver;
    protected String _url;
    protected String _schema;
    protected String _userId;
    protected String _password;
    protected Properties _connectionProperties;
    protected DfSimpleDataSourceCreator _dataSourceCreator = new DfSimpleDataSourceCreator();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public final void execute() {
        block48: {
            long before;
            block44: {
                before = this.getTaskBeforeTimeMillis();
                this.initializeDatabaseInfo();
                if (this.isUseDataSource()) {
                    this.setupDataSource();
                }
                this.doExecute();
                Object var6_2 = null;
                if (!this.isUseDataSource()) break block44;
                this.commitDataSource();
                Object var9_6 = null;
                try {
                    this.destroyDataSource();
                }
                catch (SQLException ignored2) {
                    _log.warn((Object)"Failed to destroy data source! (Ignored)", (Throwable)ignored2);
                }
                break block44;
                {
                    catch (SQLException ignored) {
                        var9_6 = null;
                        try {
                            this.destroyDataSource();
                        }
                        catch (SQLException ignored2) {
                            _log.warn((Object)"Failed to destroy data source! (Ignored)", (Throwable)ignored2);
                        }
                        break block44;
                    }
                }
                catch (Throwable throwable) {
                    Object var9_7 = null;
                    try {
                        this.destroyDataSource();
                    }
                    catch (SQLException ignored2) {
                        _log.warn((Object)"Failed to destroy data source! (Ignored)", (Throwable)ignored2);
                    }
                    throw throwable;
                }
            }
            long after = this.getTaskAfterTimeMillis();
            if (this.isValidTaskEndInformation()) {
                String environmentType = DfEnvironmentType.getInstance().getEnvironmentType();
                StringBuilder sb = new StringBuilder();
                String ln = this.ln();
                sb.append(ln);
                sb.append(ln).append("_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/");
                sb.append(ln).append("[Task End]: " + this.getPerformanceView(after - before));
                sb.append(ln);
                sb.append(ln).append("  MY_PROJECT_NAME: {" + this.getBasicProperties().getProjectName() + "}");
                sb.append(ln).append("    database  = " + this.getBasicProperties().getDatabaseType());
                sb.append(ln).append("    language  = " + this.getBasicProperties().getTargetLanguage());
                sb.append(ln).append("    container = " + this.getBasicProperties().getTargetContainerName());
                sb.append(ln);
                sb.append(ln).append("  DBFLUTE_ENVIRONMENT_TYPE: {" + environmentType + "}");
                sb.append(ln).append("    driver = " + this._driver);
                sb.append(ln).append("    url    = " + this._url);
                sb.append(ln).append("    schema = " + this._schema);
                sb.append(ln).append("    user   = " + this._userId);
                sb.append(ln).append("    props  = " + this._connectionProperties);
                String finalInformation = this.getFinalInformation();
                if (finalInformation != null) {
                    sb.append(ln);
                    sb.append(finalInformation);
                }
                sb.append(ln).append("_/_/_/_/_/_/_/_/_/_/ {" + this.getDisplayTaskName() + "}");
                _log.info((Object)sb.toString());
            }
            break block48;
            {
                catch (Exception e) {
                    block46: {
                        try {
                            this.logException(e);
                        }
                        catch (Throwable ignored) {
                            _log.warn((Object)"Ignored exception occured!", ignored);
                            _log.error((Object)"Failed to execute DBFlute Task!", (Throwable)e);
                        }
                        this.throwTaskFailure();
                        Object var6_3 = null;
                        if (this.isUseDataSource()) {
                            this.commitDataSource();
                            Object var9_8 = null;
                            try {
                                this.destroyDataSource();
                            }
                            catch (SQLException ignored2) {
                                _log.warn((Object)"Failed to destroy data source! (Ignored)", (Throwable)ignored2);
                            }
                            break block46;
                            {
                                catch (SQLException ignored) {
                                    var9_8 = null;
                                    try {
                                        this.destroyDataSource();
                                    }
                                    catch (SQLException ignored2) {
                                        _log.warn((Object)"Failed to destroy data source! (Ignored)", (Throwable)ignored2);
                                    }
                                    break block46;
                                }
                            }
                            catch (Throwable throwable) {
                                Object var9_9 = null;
                                try {
                                    this.destroyDataSource();
                                }
                                catch (SQLException ignored2) {
                                    _log.warn((Object)"Failed to destroy data source! (Ignored)", (Throwable)ignored2);
                                }
                                throw throwable;
                            }
                        }
                    }
                    after = this.getTaskAfterTimeMillis();
                    if (this.isValidTaskEndInformation()) {
                        String environmentType = DfEnvironmentType.getInstance().getEnvironmentType();
                        StringBuilder sb = new StringBuilder();
                        String ln = this.ln();
                        sb.append(ln);
                        sb.append(ln).append("_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/");
                        sb.append(ln).append("[Task End]: " + this.getPerformanceView(after - before));
                        sb.append(ln);
                        sb.append(ln).append("  MY_PROJECT_NAME: {" + this.getBasicProperties().getProjectName() + "}");
                        sb.append(ln).append("    database  = " + this.getBasicProperties().getDatabaseType());
                        sb.append(ln).append("    language  = " + this.getBasicProperties().getTargetLanguage());
                        sb.append(ln).append("    container = " + this.getBasicProperties().getTargetContainerName());
                        sb.append(ln);
                        sb.append(ln).append("  DBFLUTE_ENVIRONMENT_TYPE: {" + environmentType + "}");
                        sb.append(ln).append("    driver = " + this._driver);
                        sb.append(ln).append("    url    = " + this._url);
                        sb.append(ln).append("    schema = " + this._schema);
                        sb.append(ln).append("    user   = " + this._userId);
                        sb.append(ln).append("    props  = " + this._connectionProperties);
                        String finalInformation = this.getFinalInformation();
                        if (finalInformation != null) {
                            sb.append(ln);
                            sb.append(finalInformation);
                        }
                        sb.append(ln).append("_/_/_/_/_/_/_/_/_/_/ {" + this.getDisplayTaskName() + "}");
                        _log.info((Object)sb.toString());
                    }
                    break block48;
                }
                catch (Error e) {
                    block49: {
                        try {
                            this.logError(e);
                        }
                        catch (Throwable ignored) {
                            _log.warn((Object)"Ignored exception occured!", ignored);
                            _log.error((Object)"Failed to execute DBFlute Task!", (Throwable)e);
                        }
                        this.throwTaskFailure();
                        Object var6_4 = null;
                        if (this.isUseDataSource()) {
                            this.commitDataSource();
                            Object var9_10 = null;
                            try {
                                this.destroyDataSource();
                            }
                            catch (SQLException ignored2) {
                                _log.warn((Object)"Failed to destroy data source! (Ignored)", (Throwable)ignored2);
                            }
                            break block49;
                            {
                                catch (SQLException ignored) {
                                    var9_10 = null;
                                    try {
                                        this.destroyDataSource();
                                    }
                                    catch (SQLException ignored2) {
                                        _log.warn((Object)"Failed to destroy data source! (Ignored)", (Throwable)ignored2);
                                    }
                                    break block49;
                                }
                            }
                            catch (Throwable throwable) {
                                Object var9_11 = null;
                                try {
                                    this.destroyDataSource();
                                }
                                catch (SQLException ignored2) {
                                    _log.warn((Object)"Failed to destroy data source! (Ignored)", (Throwable)ignored2);
                                }
                                throw throwable;
                            }
                        }
                    }
                    after = this.getTaskAfterTimeMillis();
                    if (this.isValidTaskEndInformation()) {
                        String environmentType = DfEnvironmentType.getInstance().getEnvironmentType();
                        StringBuilder sb = new StringBuilder();
                        String ln = this.ln();
                        sb.append(ln);
                        sb.append(ln).append("_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/");
                        sb.append(ln).append("[Task End]: " + this.getPerformanceView(after - before));
                        sb.append(ln);
                        sb.append(ln).append("  MY_PROJECT_NAME: {" + this.getBasicProperties().getProjectName() + "}");
                        sb.append(ln).append("    database  = " + this.getBasicProperties().getDatabaseType());
                        sb.append(ln).append("    language  = " + this.getBasicProperties().getTargetLanguage());
                        sb.append(ln).append("    container = " + this.getBasicProperties().getTargetContainerName());
                        sb.append(ln);
                        sb.append(ln).append("  DBFLUTE_ENVIRONMENT_TYPE: {" + environmentType + "}");
                        sb.append(ln).append("    driver = " + this._driver);
                        sb.append(ln).append("    url    = " + this._url);
                        sb.append(ln).append("    schema = " + this._schema);
                        sb.append(ln).append("    user   = " + this._userId);
                        sb.append(ln).append("    props  = " + this._connectionProperties);
                        String finalInformation = this.getFinalInformation();
                        if (finalInformation != null) {
                            sb.append(ln);
                            sb.append(finalInformation);
                        }
                        sb.append(ln).append("_/_/_/_/_/_/_/_/_/_/ {" + this.getDisplayTaskName() + "}");
                        _log.info((Object)sb.toString());
                    }
                }
            }
            catch (Throwable throwable) {
                block51: {
                    Object var6_5 = null;
                    if (this.isUseDataSource()) {
                        this.commitDataSource();
                        Object var9_12 = null;
                        try {
                            this.destroyDataSource();
                        }
                        catch (SQLException ignored2) {
                            _log.warn((Object)"Failed to destroy data source! (Ignored)", (Throwable)ignored2);
                        }
                        break block51;
                        {
                            catch (SQLException ignored) {
                                var9_12 = null;
                                try {
                                    this.destroyDataSource();
                                }
                                catch (SQLException ignored2) {
                                    _log.warn((Object)"Failed to destroy data source! (Ignored)", (Throwable)ignored2);
                                }
                            }
                        }
                        catch (Throwable throwable2) {
                            Object var9_13 = null;
                            try {
                                this.destroyDataSource();
                            }
                            catch (SQLException ignored2) {
                                _log.warn((Object)"Failed to destroy data source! (Ignored)", (Throwable)ignored2);
                            }
                            throw throwable2;
                        }
                    }
                }
                after = this.getTaskAfterTimeMillis();
                if (this.isValidTaskEndInformation()) {
                    String environmentType = DfEnvironmentType.getInstance().getEnvironmentType();
                    StringBuilder sb = new StringBuilder();
                    String ln = this.ln();
                    sb.append(ln);
                    sb.append(ln).append("_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/");
                    sb.append(ln).append("[Task End]: " + this.getPerformanceView(after - before));
                    sb.append(ln);
                    sb.append(ln).append("  MY_PROJECT_NAME: {" + this.getBasicProperties().getProjectName() + "}");
                    sb.append(ln).append("    database  = " + this.getBasicProperties().getDatabaseType());
                    sb.append(ln).append("    language  = " + this.getBasicProperties().getTargetLanguage());
                    sb.append(ln).append("    container = " + this.getBasicProperties().getTargetContainerName());
                    sb.append(ln);
                    sb.append(ln).append("  DBFLUTE_ENVIRONMENT_TYPE: {" + environmentType + "}");
                    sb.append(ln).append("    driver = " + this._driver);
                    sb.append(ln).append("    url    = " + this._url);
                    sb.append(ln).append("    schema = " + this._schema);
                    sb.append(ln).append("    user   = " + this._userId);
                    sb.append(ln).append("    props  = " + this._connectionProperties);
                    String finalInformation = this.getFinalInformation();
                    if (finalInformation != null) {
                        sb.append(ln);
                        sb.append(finalInformation);
                    }
                    sb.append(ln).append("_/_/_/_/_/_/_/_/_/_/ {" + this.getDisplayTaskName() + "}");
                    _log.info((Object)sb.toString());
                }
                throw throwable;
            }
        }
    }

    protected long getTaskBeforeTimeMillis() {
        return System.currentTimeMillis();
    }

    protected long getTaskAfterTimeMillis() {
        return System.currentTimeMillis();
    }

    protected boolean isValidTaskEndInformation() {
        return true;
    }

    protected void logException(Exception e) {
        DfAntTaskUtil.logException(e, this.getDisplayTaskName());
    }

    protected void logError(Error e) {
        DfAntTaskUtil.logError(e, this.getDisplayTaskName());
    }

    protected String getDisplayTaskName() {
        String taskName = this.getTaskName();
        return DfAntTaskUtil.getDisplayTaskName(taskName);
    }

    protected String getFinalInformation() {
        return null;
    }

    protected void throwTaskFailure() {
        DfAntTaskUtil.throwTaskFailure(this.getDisplayTaskName());
    }

    protected void initializeDatabaseInfo() {
        this._driver = this.getDatabaseProperties().getDatabaseDriver();
        this._url = this.getDatabaseProperties().getDatabaseUrl();
        this._userId = this.getDatabaseProperties().getDatabaseUser();
        this._schema = this.getDatabaseProperties().getDatabaseSchema();
        this._password = this.getDatabaseProperties().getDatabasePassword();
        this._connectionProperties = this.getDatabaseProperties().getDatabaseConnectionProperties();
    }

    protected abstract void doExecute();

    protected String getPerformanceView(long mil) {
        if (mil < 0L) {
            return String.valueOf(mil);
        }
        long sec = mil / 1000L;
        long min = sec / 60L;
        sec %= 60L;
        mil %= 1000L;
        StringBuffer sb = new StringBuffer();
        if (min >= 10L) {
            sb.append(min).append("m");
        } else if (min < 10L && min >= 0L) {
            sb.append("0").append(min).append("m");
        }
        if (sec >= 10L) {
            sb.append(sec).append("s");
        } else if (sec < 10L && sec >= 0L) {
            sb.append("0").append(sec).append("s");
        }
        if (mil >= 100L) {
            sb.append(mil).append("ms");
        } else if (mil < 100L && mil >= 10L) {
            sb.append("0").append(mil).append("ms");
        } else if (mil < 10L && mil >= 0L) {
            sb.append("00").append(mil).append("ms");
        }
        return sb.toString();
    }

    protected abstract boolean isUseDataSource();

    protected void setupDataSource() throws SQLException {
        this._dataSourceCreator.setUserId(this._userId);
        this._dataSourceCreator.setPassword(this._password);
        this._dataSourceCreator.setDriver(this._driver);
        this._dataSourceCreator.setUrl(this._url);
        this._dataSourceCreator.setConnectionProperties(this._connectionProperties);
        this._dataSourceCreator.setAutoCommit(true);
        this._dataSourceCreator.create();
        this.connectSchema();
    }

    protected void commitDataSource() throws SQLException {
        this._dataSourceCreator.commit();
    }

    protected void destroyDataSource() throws SQLException {
        this._dataSourceCreator.destroy();
        if (this.getBasicProperties().isDatabaseDerby()) {
            DfAntTaskUtil.shutdownIfDerbyEmbedded(this._driver);
        }
    }

    protected DataSource getDataSource() {
        return DfDataSourceContext.getDataSource();
    }

    protected void connectSchema() throws SQLException {
        DfCurrentSchemaConnector connector = new DfCurrentSchemaConnector(this._schema, this.getBasicProperties());
        connector.connectSchema(this.getDataSource());
    }

    public void setContextProperties(String file) {
        try {
            Properties prop = DfAntTaskUtil.getBuildProperties(file, this.getProject());
            DfBuildProperties.getInstance().setProperties(prop);
        }
        catch (RuntimeException e) {
            String msg = "Failed to set context properties:";
            msg = msg + " file=" + file;
            _log.warn((Object)msg, (Throwable)e);
            throw e;
        }
    }

    protected DfBuildProperties getProperties() {
        return DfBuildProperties.getInstance();
    }

    protected DfBasicProperties getBasicProperties() {
        return this.getProperties().getBasicProperties();
    }

    protected DfDatabaseProperties getDatabaseProperties() {
        return this.getProperties().getDatabaseProperties();
    }

    protected List<File> collectSqlFileList() {
        String sqlDirectory = this.getProperties().getOutsideSqlProperties().getSqlDirectory();
        DfSqlFileCollector sqlFileCollector = new DfSqlFileCollector(sqlDirectory, this.getBasicProperties());
        return sqlFileCollector.collectSqlFileList();
    }

    protected String ln() {
        return "\n";
    }

    public void setEnvironmentType(String environmentType) {
        DfEnvironmentType.getInstance().setEnvironmentType(environmentType);
    }
}

