/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.logic.schemainitializer;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.dbflute.helper.StringSet;
import org.seasar.dbflute.logic.jdbc.metadata.info.DfProcedureMetaInfo;
import org.seasar.dbflute.logic.jdbc.metadata.info.DfTableMetaInfo;
import org.seasar.dbflute.logic.schemainitializer.DfSchemaInitializerJdbc;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DfSchemaInitializerOracle
extends DfSchemaInitializerJdbc {
    private static final Log _log = LogFactory.getLog(DfSchemaInitializerOracle.class);
    protected StringSet _droppedPackageSet = StringSet.createAsCaseInsensitive();

    @Override
    protected boolean isSkipDropForeignKey(DfTableMetaInfo tableMetaInfo) {
        return tableMetaInfo.isTableTypeSynonym();
    }

    @Override
    protected void setupDropTable(StringBuilder sb, DfTableMetaInfo metaInfo) {
        if (metaInfo.isTableTypeSynonym()) {
            String tableName = this.filterTableName(metaInfo.getTableName());
            sb.append("drop synonym ").append(tableName);
        } else {
            super.setupDropTable(sb, metaInfo);
        }
    }

    @Override
    protected void dropSequence(Connection conn, List<DfTableMetaInfo> tableMetaInfoList) {
        this.dropSequence(conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void dropSequence(Connection conn) {
        block38: {
            SQLException ignored32;
            ResultSet rs;
            Statement st;
            ArrayList<String> sequenceNameList;
            block36: {
                String schema;
                block37: {
                    SQLException ignored2222;
                    String metaDataSql;
                    block33: {
                        if (this._schema == null || this._schema.trim().length() == 0) {
                            return;
                        }
                        schema = this._schema;
                        sequenceNameList = new ArrayList<String>();
                        metaDataSql = "select * from ALL_SEQUENCES where SEQUENCE_OWNER = '" + schema + "'";
                        st = null;
                        rs = null;
                        st = conn.createStatement();
                        _log.info((Object)("...Executing helper SQL:" + this.ln() + metaDataSql));
                        rs = st.executeQuery(metaDataSql);
                        while (rs.next()) {
                            String sequenceName = rs.getString("SEQUENCE_NAME");
                            sequenceNameList.add(sequenceName);
                        }
                        Object var10_10 = null;
                        if (st == null) break block33;
                        try {
                            st.close();
                        }
                        catch (SQLException ignored2222) {
                            _log.info((Object)"statement.close() threw the exception!", (Throwable)ignored2222);
                        }
                    }
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (SQLException ignored2222) {
                            _log.info((Object)"rs.close() threw the exception!", (Throwable)ignored2222);
                        }
                    }
                    break block37;
                    {
                        catch (SQLException continued) {
                            SQLException ignored2222;
                            String msg = "*Failed to the SQL:" + this.ln();
                            msg = msg + (continued.getMessage() != null ? continued.getMessage() : null) + this.ln();
                            msg = msg + metaDataSql;
                            _log.info((Object)metaDataSql);
                            Object var10_11 = null;
                            if (st != null) {
                                try {
                                    st.close();
                                }
                                catch (SQLException ignored2222) {
                                    _log.info((Object)"statement.close() threw the exception!", (Throwable)ignored2222);
                                }
                            }
                            if (rs != null) {
                                try {
                                    rs.close();
                                }
                                catch (SQLException ignored2222) {
                                    _log.info((Object)"rs.close() threw the exception!", (Throwable)ignored2222);
                                }
                            }
                            return;
                        }
                    }
                    catch (Throwable throwable) {
                        SQLException ignored2222;
                        Object var10_12 = null;
                        if (st != null) {
                            try {
                                st.close();
                            }
                            catch (SQLException ignored2222) {
                                _log.info((Object)"statement.close() threw the exception!", (Throwable)ignored2222);
                            }
                        }
                        if (rs != null) {
                            try {
                                rs.close();
                            }
                            catch (SQLException ignored2222) {
                                _log.info((Object)"rs.close() threw the exception!", (Throwable)ignored2222);
                            }
                        }
                        throw throwable;
                    }
                }
                st = conn.createStatement();
                for (String sequenceName : sequenceNameList) {
                    String dropSequenceSql = "drop sequence " + schema + "." + sequenceName;
                    _log.info((Object)dropSequenceSql);
                    st.execute(dropSequenceSql);
                }
                Object var13_21 = null;
                if (st == null) break block36;
                try {
                    st.close();
                }
                catch (SQLException ignored32) {
                    _log.info((Object)"statement.close() threw the exception!", (Throwable)ignored32);
                }
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException ignored32) {
                    _log.info((Object)"rs.close() threw the exception!", (Throwable)ignored32);
                }
            }
            break block38;
            {
                catch (SQLException e) {
                    String msg = "Failed to drop sequences: " + sequenceNameList;
                    throw new IllegalStateException(msg, e);
                }
            }
            catch (Throwable throwable) {
                SQLException ignored32;
                Object var13_22 = null;
                if (st != null) {
                    try {
                        st.close();
                    }
                    catch (SQLException ignored32) {
                        _log.info((Object)"statement.close() threw the exception!", (Throwable)ignored32);
                    }
                }
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (SQLException ignored32) {
                        _log.info((Object)"rs.close() threw the exception!", (Throwable)ignored32);
                    }
                }
                throw throwable;
            }
        }
    }

    @Override
    protected void handlePackageProcedure(DfProcedureMetaInfo metaInfo, Statement st, SQLException e) throws SQLException {
        String catalog = metaInfo.getProcedureCatalog();
        if (catalog == null || catalog.trim().length() == 0) {
            throw e;
        }
        if (this._droppedPackageSet.contains((Object)catalog)) {
            _log.info((Object)("  (o) already dropped: " + catalog));
            return;
        }
        String sql = "drop package " + catalog;
        try {
            st.execute(sql);
            _log.info((Object)("  (o) retry: " + sql));
            this._droppedPackageSet.add(catalog);
        }
        catch (SQLException ignored) {
            _log.info((Object)("  (x) retry: " + sql));
            throw e;
        }
    }

    @Override
    protected void dropDBLink(Connection conn, List<DfTableMetaInfo> tableMetaInfoList) {
        this.dropDBLink(conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void dropDBLink(Connection conn) {
        block38: {
            SQLException ignored32;
            ResultSet rs;
            Statement st;
            ArrayList<String> dbLinkNameList;
            block36: {
                block37: {
                    SQLException ignored2222;
                    String metaDataSql;
                    block33: {
                        if (this._schema == null || this._schema.trim().length() == 0) {
                            return;
                        }
                        dbLinkNameList = new ArrayList<String>();
                        metaDataSql = "select * from ALL_DB_LINKS where OWNER = '" + this._schema + "'";
                        st = null;
                        rs = null;
                        st = conn.createStatement();
                        _log.info((Object)("...Executing helper SQL:" + this.ln() + metaDataSql));
                        rs = st.executeQuery(metaDataSql);
                        while (rs.next()) {
                            String dbLinkName = rs.getString("DB_LINK");
                            dbLinkNameList.add(dbLinkName);
                        }
                        Object var9_9 = null;
                        if (st == null) break block33;
                        try {
                            st.close();
                        }
                        catch (SQLException ignored2222) {
                            _log.info((Object)"statement.close() threw the exception!", (Throwable)ignored2222);
                        }
                    }
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (SQLException ignored2222) {
                            _log.info((Object)"rs.close() threw the exception!", (Throwable)ignored2222);
                        }
                    }
                    break block37;
                    {
                        catch (SQLException continued) {
                            SQLException ignored2222;
                            String msg = "*Failed to the SQL:" + this.ln();
                            msg = msg + (continued.getMessage() != null ? continued.getMessage() : null) + this.ln();
                            msg = msg + metaDataSql;
                            _log.info((Object)metaDataSql);
                            Object var9_10 = null;
                            if (st != null) {
                                try {
                                    st.close();
                                }
                                catch (SQLException ignored2222) {
                                    _log.info((Object)"statement.close() threw the exception!", (Throwable)ignored2222);
                                }
                            }
                            if (rs != null) {
                                try {
                                    rs.close();
                                }
                                catch (SQLException ignored2222) {
                                    _log.info((Object)"rs.close() threw the exception!", (Throwable)ignored2222);
                                }
                            }
                            return;
                        }
                    }
                    catch (Throwable throwable) {
                        SQLException ignored2222;
                        Object var9_11 = null;
                        if (st != null) {
                            try {
                                st.close();
                            }
                            catch (SQLException ignored2222) {
                                _log.info((Object)"statement.close() threw the exception!", (Throwable)ignored2222);
                            }
                        }
                        if (rs != null) {
                            try {
                                rs.close();
                            }
                            catch (SQLException ignored2222) {
                                _log.info((Object)"rs.close() threw the exception!", (Throwable)ignored2222);
                            }
                        }
                        throw throwable;
                    }
                }
                st = conn.createStatement();
                for (String dbLinkName : dbLinkNameList) {
                    String dropDbLinkSql = "drop database link " + dbLinkName;
                    _log.info((Object)dropDbLinkSql);
                    st.execute(dropDbLinkSql);
                }
                Object var12_20 = null;
                if (st == null) break block36;
                try {
                    st.close();
                }
                catch (SQLException ignored32) {
                    _log.info((Object)"statement.close() threw the exception!", (Throwable)ignored32);
                }
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException ignored32) {
                    _log.info((Object)"rs.close() threw the exception!", (Throwable)ignored32);
                }
            }
            break block38;
            {
                catch (SQLException e) {
                    String msg = "Failed to drop DB links: " + dbLinkNameList;
                    throw new IllegalStateException(msg, e);
                }
            }
            catch (Throwable throwable) {
                SQLException ignored32;
                Object var12_21 = null;
                if (st != null) {
                    try {
                        st.close();
                    }
                    catch (SQLException ignored32) {
                        _log.info((Object)"statement.close() threw the exception!", (Throwable)ignored32);
                    }
                }
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (SQLException ignored32) {
                        _log.info((Object)"rs.close() threw the exception!", (Throwable)ignored32);
                    }
                }
                throw throwable;
            }
        }
    }
}

