/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.logic.initializer;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.torque.engine.database.model.Column;
import org.apache.torque.engine.database.model.Table;
import org.seasar.dbflute.properties.DfIncludeQueryProperties;
import org.seasar.dbflute.properties.assistant.DfTableFinder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IncludeQueryInitializer {
    private static final Log _log = LogFactory.getLog(IncludeQueryInitializer.class);
    protected DfIncludeQueryProperties includeQueryProperties;
    protected DfTableFinder tableFinder;

    public void initializeIncludeQuery() {
        _log.debug((Object)"/=============================");
        _log.debug((Object)"...Initializing include query.");
        Map<String, Map<String, Map<String, List<String>>>> map = this.includeQueryProperties.getIncludeQueryMap();
        Set<String> keySet = map.keySet();
        for (String key : keySet) {
            _log.debug((Object)key);
            Map<String, Map<String, List<String>>> queryElementMap = map.get(key);
            Set<String> queryElementKeySet = queryElementMap.keySet();
            for (String queryElementKey : queryElementKeySet) {
                _log.debug((Object)("    " + queryElementKey));
                Map<String, List<String>> tableElementMap = queryElementMap.get(queryElementKey);
                Set<String> tableElementKeySet = tableElementMap.keySet();
                for (String tableName : tableElementKeySet) {
                    _log.debug((Object)("        " + tableName));
                    Table targetTable = this.tableFinder.findTable(tableName);
                    if (targetTable == null) {
                        this.throwIncludeQueryTableNotFoundException(queryElementKey, tableName, map);
                    }
                    List<String> columnNameList = null;
                    try {
                        columnNameList = tableElementMap.get(tableName);
                    }
                    catch (ClassCastException e) {
                        this.throwIncludeQueryNotListColumnSpecificationException(queryElementKey, tableName, map, e);
                    }
                    for (String columnName : columnNameList) {
                        _log.debug((Object)("            " + columnName));
                        Column targetColumn = targetTable.getColumn(columnName);
                        if (targetColumn != null) continue;
                        this.throwIncludeQueryColumnNotFoundException(queryElementKey, tableName, columnName, map);
                    }
                }
            }
        }
        _log.debug((Object)"========/");
    }

    protected void throwIncludeQueryTableNotFoundException(String queryElementKey, String tableName, Map<String, Map<String, Map<String, List<String>>>> map) {
        String msg = "Look! Read the message below." + this.getLineSeparator();
        msg = msg + "/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *" + this.getLineSeparator();
        msg = msg + "The table was Not Found in includeQueryMap!" + this.getLineSeparator();
        msg = msg + this.getLineSeparator();
        msg = msg + "[Query Type]" + this.getLineSeparator() + queryElementKey + this.getLineSeparator();
        msg = msg + this.getLineSeparator();
        msg = msg + "[Table Name]" + this.getLineSeparator() + tableName + this.getLineSeparator();
        msg = msg + this.getLineSeparator();
        msg = msg + "[Include Query Map]" + this.getLineSeparator() + map + this.getLineSeparator();
        msg = msg + "* * * * * * * * * */";
        throw new IncludeQueryTableNotFoundException(msg);
    }

    protected void throwIncludeQueryNotListColumnSpecificationException(String queryElementKey, String tableName, Map<String, Map<String, Map<String, List<String>>>> map, RuntimeException e) {
        String msg = "Look! Read the message below." + this.getLineSeparator();
        msg = msg + "/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *" + this.getLineSeparator();
        msg = msg + "The column specification of the table was Not List Type in includeQueryMap!" + this.getLineSeparator();
        msg = msg + this.getLineSeparator();
        msg = msg + "[Advice]" + this.getLineSeparator();
        msg = msg + "You shuold specify them this way:" + this.getLineSeparator();
        msg = msg + "    --------------------------------------------" + this.getLineSeparator();
        msg = msg + "    " + tableName + " = list:{XXX_ID ; XXX_NAME}" + this.getLineSeparator();
        msg = msg + "    --------------------------------------------" + this.getLineSeparator();
        msg = msg + this.getLineSeparator();
        msg = msg + "[Query Type]" + this.getLineSeparator() + queryElementKey + this.getLineSeparator();
        msg = msg + this.getLineSeparator();
        msg = msg + "[Table Name]" + this.getLineSeparator() + tableName + this.getLineSeparator();
        msg = msg + this.getLineSeparator();
        msg = msg + "[Include Query Map]" + this.getLineSeparator() + map + this.getLineSeparator();
        msg = msg + "* * * * * * * * * */";
        throw new IncludeQueryNotListColumnSpecificationException(msg, e);
    }

    protected void throwIncludeQueryColumnNotFoundException(String queryElementKey, String tableName, String columnName, Map<String, Map<String, Map<String, List<String>>>> map) {
        String msg = "Look! Read the message below." + this.getLineSeparator();
        msg = msg + "/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *" + this.getLineSeparator();
        msg = msg + "The column was Not Found in includeQueryMap!" + this.getLineSeparator();
        msg = msg + this.getLineSeparator();
        msg = msg + "[Query Type]" + this.getLineSeparator() + queryElementKey + this.getLineSeparator();
        msg = msg + this.getLineSeparator();
        msg = msg + "[Table Name]" + this.getLineSeparator() + tableName + this.getLineSeparator();
        msg = msg + this.getLineSeparator();
        msg = msg + "[Column Name]" + this.getLineSeparator() + columnName + this.getLineSeparator();
        msg = msg + this.getLineSeparator();
        msg = msg + "[Include Query Map]" + this.getLineSeparator() + map + this.getLineSeparator();
        msg = msg + "* * * * * * * * * */";
        throw new IncludeQueryColumnNotFoundException(msg);
    }

    public String getLineSeparator() {
        return "\n";
    }

    public DfIncludeQueryProperties getIncludeQueryProperties() {
        return this.includeQueryProperties;
    }

    public void setIncludeQueryProperties(DfIncludeQueryProperties includeQueryProperties) {
        this.includeQueryProperties = includeQueryProperties;
    }

    public DfTableFinder getTableFinder() {
        return this.tableFinder;
    }

    public void setTableFinder(DfTableFinder tableFinder) {
        this.tableFinder = tableFinder;
    }

    protected static class IncludeQueryColumnNotFoundException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public IncludeQueryColumnNotFoundException(String msg) {
            super(msg);
        }
    }

    protected static class IncludeQueryNotListColumnSpecificationException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public IncludeQueryNotListColumnSpecificationException(String msg, RuntimeException e) {
            super(msg, e);
        }
    }

    protected static class IncludeQueryTableNotFoundException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public IncludeQueryTableNotFoundException(String msg) {
            super(msg);
        }
    }
}

