/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.helper.io.data.impl.internal;

import java.sql.Timestamp;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.seasar.dbflute.helper.io.data.impl.internal.DfInternalSqlBuildingResult;
import org.seasar.dbflute.logic.jdbc.metadata.info.DfColumnMetaInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DfInternalSqlBuilder {
    protected String _tableName;
    protected Map<String, DfColumnMetaInfo> _columnMap;
    protected List<String> _columnNameList;
    protected List<String> _valueList;
    protected Map<String, Set<String>> _notFoundColumnMap;
    protected Map<String, String> _targetConvertColumnNameKeyToLowerMap;
    protected Map<String, String> _additionalDefaultColumnNameToLowerMap;
    protected Map<String, Map<String, String>> _convertValueMap;
    protected Map<String, String> _defaultValueMap;

    public DfInternalSqlBuildingResult buildSql() {
        DfInternalSqlBuildingResult sqlBuildingResult = new DfInternalSqlBuildingResult();
        Map<String, Object> columnValueMap = this.setupColumnValueMap();
        StringBuilder sb = new StringBuilder();
        Set<String> columnNameSet = columnValueMap.keySet();
        for (String columnName : columnNameSet) {
            sb.append(", ").append(columnName);
        }
        sb.delete(0, ", ".length()).insert(0, "insert into " + this._tableName + " (").append(")");
        sb.append(this.setupValuesStringAndParameter(columnNameSet, columnValueMap, sqlBuildingResult));
        sqlBuildingResult.setSql(sb.toString());
        return sqlBuildingResult;
    }

    protected Map<String, Object> setupColumnValueMap() {
        LinkedHashMap<String, Object> columnValueMap = new LinkedHashMap<String, Object>();
        int columnCount = -1;
        for (String columnName : this._columnNameList) {
            String value;
            ++columnCount;
            if (!this._columnMap.isEmpty() && !this._columnMap.containsKey(columnName)) {
                if (this.hasDefaultValue(columnName)) continue;
                Set<String> notFoundColumnSet = this._notFoundColumnMap.get(this._tableName);
                if (notFoundColumnSet == null) {
                    notFoundColumnSet = new LinkedHashSet<String>();
                    this._notFoundColumnMap.put(this._tableName, notFoundColumnSet);
                }
                notFoundColumnSet.add(columnName);
                continue;
            }
            try {
                value = columnCount < this._valueList.size() ? this._valueList.get(columnCount) : null;
            }
            catch (RuntimeException e) {
                throw new RuntimeException("valueList.get(columnCount) threw the exception: valueList=" + this._valueList + " columnCount=" + columnCount, e);
            }
            if (!this._columnMap.isEmpty() && this._columnMap.containsKey(columnName)) {
                String realDbName = this._columnMap.get(columnName).getColumnName();
                columnValueMap.put(realDbName, value);
                continue;
            }
            columnValueMap.put(columnName, value);
        }
        return columnValueMap;
    }

    protected String setupValuesStringAndParameter(Set<String> columnNameSet, Map<String, Object> columnValueMap, DfInternalSqlBuildingResult sqlBuildingResult) {
        StringBuilder sbValues = new StringBuilder();
        for (String columnName : columnNameSet) {
            if (this.hasDefaultValue(columnName)) {
                String defaultValue = this.findDefaultValue(columnName);
                sbValues.append(", ").append("?");
                if (defaultValue.equalsIgnoreCase("sysdate")) {
                    Timestamp currentTimestamp = new Timestamp(System.currentTimeMillis());
                    sqlBuildingResult.addColumnValue(columnName, currentTimestamp);
                    continue;
                }
                sqlBuildingResult.addColumnValue(columnName, defaultValue);
                continue;
            }
            Object value = columnValueMap.get(columnName);
            if (this.hasConvertValue(columnName)) {
                Map<String, String> convertValueMapping = this.findConvertValueMapping(columnName);
                Object object = value = value != null && value instanceof String ? ((String)value).trim() : value;
                if (convertValueMapping.containsKey(value)) {
                    value = convertValueMapping.get(value);
                }
            }
            sbValues.append(", ?");
            sqlBuildingResult.addColumnValue(columnName, value);
        }
        sbValues.delete(0, ", ".length()).insert(0, " values(").append(")");
        return sbValues.toString();
    }

    private boolean hasConvertValue(String columnName) {
        return this.findConvertValueMapping(columnName) != null;
    }

    private Map<String, String> findConvertValueMapping(String columnName) {
        if (!this._convertValueMap.containsKey(columnName)) {
            String realColumnName;
            if (this._targetConvertColumnNameKeyToLowerMap.containsKey(columnName.toLowerCase()) && this._convertValueMap.containsKey(realColumnName = this._targetConvertColumnNameKeyToLowerMap.get(columnName.toLowerCase()))) {
                return this._convertValueMap.get(realColumnName);
            }
            return null;
        }
        return this._convertValueMap.get(columnName);
    }

    private boolean hasDefaultValue(String columnName) {
        return this.findDefaultValue(columnName) != null;
    }

    private String findDefaultValue(String columnName) {
        if (!this._defaultValueMap.containsKey(columnName)) {
            String realColumnName;
            if (this._additionalDefaultColumnNameToLowerMap.containsKey(columnName.toLowerCase()) && this._defaultValueMap.containsKey(realColumnName = this._additionalDefaultColumnNameToLowerMap.get(columnName.toLowerCase()))) {
                return this._defaultValueMap.get(realColumnName);
            }
            return null;
        }
        return this._defaultValueMap.get(columnName);
    }

    public Map<String, DfColumnMetaInfo> getColumnMap() {
        return this._columnMap;
    }

    public void setColumnMap(Map<String, DfColumnMetaInfo> columnMap) {
        this._columnMap = columnMap;
    }

    public List<String> getColumnNameList() {
        return this._columnNameList;
    }

    public void setColumnNameList(List<String> columnNameList) {
        this._columnNameList = columnNameList;
    }

    public Map<String, Set<String>> getNotFoundColumnMap() {
        return this._notFoundColumnMap;
    }

    public void setNotFoundColumnMap(Map<String, Set<String>> notFoundColumnMap) {
        this._notFoundColumnMap = notFoundColumnMap;
    }

    public String getTableName() {
        return this._tableName;
    }

    public void setTableName(String tableName) {
        this._tableName = tableName;
    }

    public List<String> getValueList() {
        return this._valueList;
    }

    public void setValueList(List<String> valueList) {
        this._valueList = valueList;
    }

    public Map<String, String> getTargetConvertColumnNameKeyToLowerMap() {
        return this._targetConvertColumnNameKeyToLowerMap;
    }

    public void setTargetConvertColumnNameKeyToLowerMap(Map<String, String> targetConvertColumnNameKeyToLowerMap) {
        this._targetConvertColumnNameKeyToLowerMap = targetConvertColumnNameKeyToLowerMap;
    }

    public Map<String, String> getAdditionalDefaultColumnNameToLowerMap() {
        return this._additionalDefaultColumnNameToLowerMap;
    }

    public void setAdditionalDefaultColumnNameToLowerMap(Map<String, String> additionalDefaultColumnNameToLowerMap) {
        this._additionalDefaultColumnNameToLowerMap = additionalDefaultColumnNameToLowerMap;
    }

    public Map<String, Map<String, String>> getConvertValueMap() {
        return this._convertValueMap;
    }

    public void setConvertValueMap(Map<String, Map<String, String>> convertValueMap) {
        this._convertValueMap = convertValueMap;
    }

    public Map<String, String> getDefaultValueMap() {
        return this._defaultValueMap;
    }

    public void setDefaultValueMap(Map<String, String> defaultValueMap) {
        this._defaultValueMap = defaultValueMap;
    }
}

