/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.s2dao.valuetype;

import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.seasar.dbflute.jdbc.Classification;
import org.seasar.dbflute.jdbc.ValueType;
import org.seasar.dbflute.s2dao.valuetype.basic.BigDecimalType;
import org.seasar.dbflute.s2dao.valuetype.basic.BigIntegerType;
import org.seasar.dbflute.s2dao.valuetype.basic.BinaryStreamType;
import org.seasar.dbflute.s2dao.valuetype.basic.BinaryType;
import org.seasar.dbflute.s2dao.valuetype.basic.BooleanType;
import org.seasar.dbflute.s2dao.valuetype.basic.ByteType;
import org.seasar.dbflute.s2dao.valuetype.basic.CharacterType;
import org.seasar.dbflute.s2dao.valuetype.basic.ClassificationType;
import org.seasar.dbflute.s2dao.valuetype.basic.DoubleType;
import org.seasar.dbflute.s2dao.valuetype.basic.FloatType;
import org.seasar.dbflute.s2dao.valuetype.basic.IntegerType;
import org.seasar.dbflute.s2dao.valuetype.basic.LongType;
import org.seasar.dbflute.s2dao.valuetype.basic.ObjectType;
import org.seasar.dbflute.s2dao.valuetype.basic.ShortType;
import org.seasar.dbflute.s2dao.valuetype.basic.SqlDateType;
import org.seasar.dbflute.s2dao.valuetype.basic.StringType;
import org.seasar.dbflute.s2dao.valuetype.basic.TimeType;
import org.seasar.dbflute.s2dao.valuetype.basic.TimestampType;
import org.seasar.dbflute.s2dao.valuetype.basic.UUIDType;
import org.seasar.dbflute.s2dao.valuetype.basic.UtilDateAsSqlDateType;
import org.seasar.dbflute.s2dao.valuetype.basic.UtilDateAsTimestampType;
import org.seasar.dbflute.s2dao.valuetype.plugin.BytesType;
import org.seasar.dbflute.s2dao.valuetype.plugin.OracleResultSetType;
import org.seasar.dbflute.s2dao.valuetype.plugin.PostgreResultSetType;
import org.seasar.dbflute.s2dao.valuetype.plugin.SerializableType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TnValueTypes {
    public static final ValueType STRING = new StringType();
    public static final ValueType CHARACTER = new CharacterType();
    public static final ValueType BYTE = new ByteType();
    public static final ValueType SHORT = new ShortType();
    public static final ValueType INTEGER = new IntegerType();
    public static final ValueType LONG = new LongType();
    public static final ValueType FLOAT = new FloatType();
    public static final ValueType DOUBLE = new DoubleType();
    public static final ValueType BIGDECIMAL = new BigDecimalType();
    public static final ValueType BIGINTEGER = new BigIntegerType();
    public static final ValueType TIME = new TimeType();
    public static final ValueType SQLDATE = new SqlDateType();
    public static final ValueType UTILDATE_AS_SQLDATE = new UtilDateAsSqlDateType();
    public static final ValueType UTILDATE_AS_TIMESTAMP = new UtilDateAsTimestampType();
    public static final ValueType TIMESTAMP = new TimestampType();
    public static final ValueType BINARY = new BinaryType();
    public static final ValueType BINARY_STREAM = new BinaryStreamType();
    public static final ValueType BOOLEAN = new BooleanType();
    public static final ValueType UUID = new UUIDType();
    public static final ValueType CLASSIFICATION = new ClassificationType();
    public static final ValueType OBJECT = new ObjectType();
    public static final ValueType ORACLE_RESULT_SET = new OracleResultSetType();
    public static final ValueType POSTGRE_RESULT_SET = new PostgreResultSetType();
    public static final ValueType SERIALIZABLE_BYTE_ARRAY = new SerializableType(BytesType.BYTES_TRAIT);
    private static final Class<?> BYTE_ARRAY_CLASS = new byte[0].getClass();
    private static Map<Class<?>, ValueType> basicObjectValueTypeMap = new ConcurrentHashMap();
    private static Map<Class<?>, ValueType> basicInterfaceValueTypeMap = new ConcurrentHashMap();
    private static Map<String, ValueType> pluginValueTypeMap = new ConcurrentHashMap<String, ValueType>();

    protected TnValueTypes() {
    }

    public static void registerBasicValueType(Class<?> keyType, ValueType valueType) {
        TnValueTypes.assertObjectNotNull("keyType", keyType);
        TnValueTypes.assertObjectNotNull("valueType", valueType);
        if (keyType.isInterface()) {
            basicInterfaceValueTypeMap.put(keyType, valueType);
        } else {
            basicObjectValueTypeMap.put(keyType, valueType);
        }
    }

    public static void removeBasicValueType(Class<?> keyType) {
        TnValueTypes.assertObjectNotNull("keyType", keyType);
        if (basicObjectValueTypeMap.containsKey(keyType)) {
            basicObjectValueTypeMap.remove(keyType);
        }
        if (basicInterfaceValueTypeMap.containsKey(keyType)) {
            basicInterfaceValueTypeMap.remove(keyType);
        }
    }

    public static void registerPluginValueType(String keyName, ValueType valueType) {
        TnValueTypes.assertObjectNotNull("keyName", keyName);
        TnValueTypes.assertObjectNotNull("valueType", valueType);
        pluginValueTypeMap.put(keyName, valueType);
    }

    public static void removePluginValueType(String keyName) {
        TnValueTypes.assertObjectNotNull("keyName", keyName);
        pluginValueTypeMap.remove(keyName);
    }

    public static ValueType getValueType(Object obj) {
        if (obj == null) {
            return OBJECT;
        }
        return TnValueTypes.getValueType(obj.getClass());
    }

    public static ValueType getValueType(Class<?> clazz) {
        if (clazz == null) {
            return OBJECT;
        }
        boolean interfaceFirst = Enum.class.isAssignableFrom(clazz);
        ValueType valueType = null;
        if (interfaceFirst) {
            valueType = TnValueTypes.getBasicInterfaceValueType(clazz);
            if (valueType == null) {
                valueType = TnValueTypes.getBasicObjectValueType(clazz);
            }
        } else {
            valueType = TnValueTypes.getBasicObjectValueType(clazz);
            if (valueType == null) {
                valueType = TnValueTypes.getBasicInterfaceValueType(clazz);
            }
        }
        return valueType != null ? valueType : OBJECT;
    }

    protected static ValueType getBasicObjectValueType(Class<?> clazz) {
        for (Class<?> c = clazz; c != null && c != Object.class; c = c.getSuperclass()) {
            ValueType valueType = basicObjectValueTypeMap.get(c);
            if (valueType == null) continue;
            return valueType;
        }
        return null;
    }

    protected static ValueType getBasicInterfaceValueType(Class<?> clazz) {
        Set<Map.Entry<Class<?>, ValueType>> entrySet = basicInterfaceValueTypeMap.entrySet();
        for (Map.Entry<Class<?>, ValueType> entry : entrySet) {
            Class<?> inf = entry.getKey();
            if (!inf.isAssignableFrom(clazz)) continue;
            return entry.getValue();
        }
        return null;
    }

    public static ValueType getPluginValueType(String valueTypeName) {
        TnValueTypes.assertObjectNotNull("valueTypeName", valueTypeName);
        return pluginValueTypeMap.get(valueTypeName);
    }

    public static ValueType getValueType(int sqltype) {
        return TnValueTypes.getValueType(TnValueTypes.getType(sqltype));
    }

    protected static Class<?> getType(int sqltype) {
        switch (sqltype) {
            case -6: {
                return Byte.class;
            }
            case 5: {
                return Short.class;
            }
            case 4: {
                return Integer.class;
            }
            case -5: {
                return Long.class;
            }
            case 6: 
            case 7: {
                return Float.class;
            }
            case 8: {
                return Double.class;
            }
            case 2: 
            case 3: {
                return BigDecimal.class;
            }
            case 91: {
                return Timestamp.class;
            }
            case 92: {
                return Time.class;
            }
            case 93: {
                return Timestamp.class;
            }
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                return BYTE_ARRAY_CLASS;
            }
            case -1: 
            case 1: 
            case 12: {
                return String.class;
            }
            case 16: {
                return Boolean.class;
            }
        }
        return Object.class;
    }

    protected static void assertObjectNotNull(String variableName, Object value) {
        if (variableName == null) {
            String msg = "The value should not be null: variableName=null value=" + value;
            throw new IllegalArgumentException(msg);
        }
        if (value == null) {
            String msg = "The value should not be null: variableName=" + variableName;
            throw new IllegalArgumentException(msg);
        }
    }

    static {
        TnValueTypes.registerBasicValueType(String.class, STRING);
        TnValueTypes.registerBasicValueType(Character.TYPE, CHARACTER);
        TnValueTypes.registerBasicValueType(Character.class, CHARACTER);
        TnValueTypes.registerBasicValueType(Byte.TYPE, BYTE);
        TnValueTypes.registerBasicValueType(Byte.class, BYTE);
        TnValueTypes.registerBasicValueType(Short.TYPE, SHORT);
        TnValueTypes.registerBasicValueType(Short.class, SHORT);
        TnValueTypes.registerBasicValueType(Integer.TYPE, INTEGER);
        TnValueTypes.registerBasicValueType(Integer.class, INTEGER);
        TnValueTypes.registerBasicValueType(Long.TYPE, LONG);
        TnValueTypes.registerBasicValueType(Long.class, LONG);
        TnValueTypes.registerBasicValueType(Float.TYPE, FLOAT);
        TnValueTypes.registerBasicValueType(Float.class, FLOAT);
        TnValueTypes.registerBasicValueType(Double.TYPE, DOUBLE);
        TnValueTypes.registerBasicValueType(Double.class, DOUBLE);
        TnValueTypes.registerBasicValueType(BigInteger.class, BIGINTEGER);
        TnValueTypes.registerBasicValueType(BigDecimal.class, BIGDECIMAL);
        TnValueTypes.registerBasicValueType(Date.class, SQLDATE);
        TnValueTypes.registerBasicValueType(Time.class, TIME);
        TnValueTypes.registerBasicValueType(java.util.Date.class, UTILDATE_AS_SQLDATE);
        TnValueTypes.registerBasicValueType(Timestamp.class, TIMESTAMP);
        TnValueTypes.registerBasicValueType(Calendar.class, TIMESTAMP);
        TnValueTypes.registerBasicValueType(BYTE_ARRAY_CLASS, BINARY);
        TnValueTypes.registerBasicValueType(InputStream.class, BINARY_STREAM);
        TnValueTypes.registerBasicValueType(Boolean.TYPE, BOOLEAN);
        TnValueTypes.registerBasicValueType(Boolean.class, BOOLEAN);
        TnValueTypes.registerBasicValueType(UUID.class, UUID);
        TnValueTypes.registerBasicValueType(Classification.class, CLASSIFICATION);
    }
}

