/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.properties;

import java.io.File;
import java.util.Comparator;
import java.util.Map;
import java.util.Properties;
import org.apache.torque.engine.database.model.Table;
import org.seasar.dbflute.properties.DfAbstractHelperProperties;
import org.seasar.dbflute.util.DfStringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DfDocumentProperties
extends DfAbstractHelperProperties {
    protected static final String NORMAL_LINE_SEPARATOR = "\n";
    protected static final String SPECIAL_LINE_SEPARATOR = "&#xa;";
    public static final String KEY_documentDefinitionMap = "documentDefinitionMap";
    protected Map<String, Object> _documentDefinitionMap;

    public DfDocumentProperties(Properties prop) {
        super(prop);
    }

    protected Map<String, Object> getDocumentDefinitionMap() {
        if (this._documentDefinitionMap == null) {
            this._documentDefinitionMap = this.mapProp("torque.documentDefinitionMap", DEFAULT_EMPTY_MAP);
        }
        return this._documentDefinitionMap;
    }

    public String getDocumentOutputDirectory() {
        String defaultValue = "./output/doc";
        return this.getProperty("documentOutputDirectory", "./output/doc", this.getDocumentDefinitionMap());
    }

    public boolean isAliasDelimiterInDbCommentValid() {
        String delimiter = this.getAliasDelimiterInDbComment();
        return delimiter != null && delimiter.trim().length() > 0 && !delimiter.trim().equalsIgnoreCase("null");
    }

    protected String getAliasDelimiterInDbComment() {
        String delimiter = (String)this.getDocumentDefinitionMap().get("aliasDelimiterInDbComment");
        if (delimiter == null || delimiter.trim().length() == 0) {
            delimiter = null;
        }
        return delimiter;
    }

    public String extractAliasFromDbComment(String comment) {
        if (!this.hasAlias(comment)) {
            return null;
        }
        String delimiter = this.getAliasDelimiterInDbComment();
        return comment.substring(0, comment.indexOf(delimiter)).trim();
    }

    public String extractCommentFromDbComment(String comment) {
        if (!this.hasAlias(comment)) {
            return comment;
        }
        String delimiter = this.getAliasDelimiterInDbComment();
        return comment.substring(comment.indexOf(delimiter) + delimiter.length()).trim();
    }

    protected boolean hasAlias(String comment) {
        if (comment == null || comment.trim().length() == 0) {
            return false;
        }
        if (!this.isAliasDelimiterInDbCommentValid()) {
            return false;
        }
        String delimiter = this.getAliasDelimiterInDbComment();
        return comment.contains(delimiter);
    }

    public boolean isEntityJavaDocDbCommentValid() {
        return this.isProperty("isEntityJavaDocDbCommentValid", false, this.getDocumentDefinitionMap());
    }

    public String resolveTextForSchemaHtml(String text) {
        if (text == null || text.trim().length() == 0) {
            return null;
        }
        text = DfStringUtil.replace((String)text, (String)"<", (String)"&lt;");
        text = DfStringUtil.replace((String)text, (String)">", (String)"&gt;");
        text = this.removeCR(text);
        String htmlLineSeparator = "<br />";
        if (text.contains(NORMAL_LINE_SEPARATOR)) {
            text = text.replaceAll(NORMAL_LINE_SEPARATOR, "<br />");
        }
        if (text.contains(SPECIAL_LINE_SEPARATOR)) {
            text = text.replaceAll(SPECIAL_LINE_SEPARATOR, "<br />");
        }
        return text;
    }

    public String resolveAttributeForSchemaHtml(String text) {
        if (text == null || text.trim().length() == 0) {
            return null;
        }
        text = DfStringUtil.replace((String)text, (String)"<", (String)"&lt;");
        text = DfStringUtil.replace((String)text, (String)">", (String)"&gt;");
        text = DfStringUtil.replace((String)text, (String)"\"", (String)"&quot;");
        text = this.removeCR(text);
        return text;
    }

    public String resolvePreTextForSchemaHtml(String text) {
        if (text == null || text.trim().length() == 0) {
            return null;
        }
        text = DfStringUtil.replace((String)text, (String)"<", (String)"&lt;");
        text = DfStringUtil.replace((String)text, (String)">", (String)"&gt;");
        text = this.removeCR(text);
        return text;
    }

    public String resolveTextForJavaDoc(String text, String indent) {
        if (this.getBasicProperties().isTargetLanguageCSharp()) {
            return this.resolveLineSeparatorForCSharpDoc(text, "    " + indent);
        }
        if (text == null || text.trim().length() == 0) {
            return null;
        }
        text = DfStringUtil.replace((String)text, (String)"<", (String)"&lt;");
        text = DfStringUtil.replace((String)text, (String)">", (String)"&gt;");
        text = this.removeCR(text);
        String javaDocLineSeparator = "<br />\n" + indent + " * ";
        if (text.contains(NORMAL_LINE_SEPARATOR)) {
            text = text.replaceAll(NORMAL_LINE_SEPARATOR, javaDocLineSeparator);
        }
        if (text.contains(SPECIAL_LINE_SEPARATOR)) {
            text = text.replaceAll(SPECIAL_LINE_SEPARATOR, javaDocLineSeparator);
        }
        return text;
    }

    protected String resolveLineSeparatorForCSharpDoc(String comment, String indent) {
        if (comment == null || comment.trim().length() == 0) {
            return null;
        }
        comment = this.removeCR(comment);
        String javaDocLineSeparator = NORMAL_LINE_SEPARATOR + indent + "/// ";
        if (comment.contains(NORMAL_LINE_SEPARATOR)) {
            comment = comment.replaceAll(NORMAL_LINE_SEPARATOR, javaDocLineSeparator);
        }
        if (comment.contains(SPECIAL_LINE_SEPARATOR)) {
            comment = comment.replaceAll(SPECIAL_LINE_SEPARATOR, javaDocLineSeparator);
        }
        return comment;
    }

    public boolean isEntityDBMetaDbCommentValid() {
        return this.isProperty("isEntityDBMetaDbCommentValid", false, this.getDocumentDefinitionMap());
    }

    public String resolveTextForDBMeta(String text) {
        if (text == null || text.trim().length() == 0) {
            return null;
        }
        text = this.removeCR(text);
        text = DfStringUtil.replace((String)text, (String)"\"", (String)"\\\"");
        String literalLineSeparator = "\\\\n";
        if (text.contains(NORMAL_LINE_SEPARATOR)) {
            text = text.replaceAll(NORMAL_LINE_SEPARATOR, "\\\\n");
        }
        if (text.contains(SPECIAL_LINE_SEPARATOR)) {
            text = text.replaceAll(SPECIAL_LINE_SEPARATOR, "\\\\n");
        }
        return text;
    }

    public String getSchemaHtmlFileName(String projectName) {
        String defaultName = "schema-" + projectName + ".html";
        return this.getProperty("schemaHtmlFileName", defaultName, this.getDocumentDefinitionMap());
    }

    public boolean isSuppressSchemaHtmlOutsideSql() {
        return this.isProperty("isSuppressSchemaHtmlOutsideSql", false, this.getDocumentDefinitionMap());
    }

    public String getHistoryHtmlFileName(String projectName) {
        String defaultName = "history-" + projectName + ".html";
        return this.getProperty("historyHtmlFileName", defaultName, this.getDocumentDefinitionMap());
    }

    public boolean isDataXlsTemplateRecordLimitValid() {
        Integer limit = this.getDataXlsTemplateRecordLimit();
        return limit != null;
    }

    public Integer getDataXlsTemplateRecordLimit() {
        String limit = (String)this.getDocumentDefinitionMap().get("dataXlsTemplateRecordLimit");
        if (limit == null || limit.trim().length() == 0 || limit.trim().equalsIgnoreCase("null")) {
            return null;
        }
        try {
            return Integer.valueOf(limit);
        }
        catch (NumberFormatException e) {
            String msg = "The property 'dataXlsTemplateRecordLimit' of documentDefinitionMap";
            msg = msg + " should be number but: value=" + limit;
            throw new IllegalStateException(msg, e);
        }
    }

    public boolean isDataXlsTemplateContainsCommonColumn() {
        return this.isProperty("isDataXlsTemplateContainsCommonColumn", false, this.getDocumentDefinitionMap());
    }

    public File getDataXlsTemplateFile() {
        String outputDirectory = this.getDocumentOutputDirectory();
        File xlsFile = new File(outputDirectory + "/data-xls-template.xls");
        return xlsFile;
    }

    public File getDataCsvTemplateDir() {
        String outputDirectory = this.getDocumentOutputDirectory();
        File xlsFile = new File(outputDirectory + "/csvdata");
        return xlsFile;
    }

    public Comparator<Table> getTableDisplayOrderBy() {
        return new Comparator<Table>(){

            @Override
            public int compare(Table table1, Table table2) {
                String type2;
                boolean mainSchema2;
                boolean mainSchema1 = table1.isMainSchema();
                if (mainSchema1 != (mainSchema2 = table2.isMainSchema())) {
                    if (mainSchema1) {
                        return -1;
                    }
                    if (mainSchema2) {
                        return 1;
                    }
                }
                String schema1 = table1.getDocumentSchema();
                String schema2 = table2.getDocumentSchema();
                if (schema1 != null && schema2 != null && !schema1.equals(schema2)) {
                    return schema1.compareTo(schema2);
                }
                if (schema1 == null && schema2 != null) {
                    return 1;
                }
                if (schema1 != null && schema2 == null) {
                    return -1;
                }
                String type1 = table1.getType();
                if (!type1.equals(type2 = table2.getType())) {
                    if (table1.isTypeTable()) {
                        return -1;
                    }
                    if (table2.isTypeTable()) {
                        return 1;
                    }
                    return type1.compareTo(type2);
                }
                String name1 = table1.getName();
                String name2 = table2.getName();
                return name1.compareTo(name2);
            }
        };
    }
}

