/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.logic.sql2entity.outsidesql;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.seasar.dbflute.util.DfCollectionUtil;
import org.seasar.dbflute.util.DfStringUtil;
import org.seasar.dbflute.util.Srl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DfOutsideSqlMarkAnalyzer {
    protected static final String TITLE_MARK = "[df:title]";
    protected static final String DESCRIPTION_MARK = "[df:description]";

    public String getCustomizeEntityName(String sql) {
        return this.getTargetString(sql, "#");
    }

    public boolean isCursor(String sql) {
        String targetString = this.getTargetString(sql, "+");
        return targetString != null && (targetString.contains("cursor") || targetString.contains("cursol"));
    }

    public List<String> getCustomizeEntityPropertyTypeList(String sql) {
        return this.getTargetList(sql, "##");
    }

    public String getParameterBeanName(String sql) {
        return this.getTargetString(sql, "!");
    }

    public List<String> getParameterBeanPropertyTypeList(String sql) {
        return this.getTargetList(sql, "!!");
    }

    public List<String> getPrimaryKeyColumnNameList(String sql) {
        if (sql == null || sql.trim().length() == 0) {
            String msg = "The sql is invalid: " + sql;
            throw new IllegalArgumentException(msg);
        }
        ArrayList<String> retLs = new ArrayList<String>();
        String primaryKeyColumnNameSeparatedString = this.getStringBetweenBeginEndMark(sql, "--*", "*");
        if (primaryKeyColumnNameSeparatedString == null || primaryKeyColumnNameSeparatedString.trim().length() == 0) {
            primaryKeyColumnNameSeparatedString = this.getStringBetweenBeginEndMark(sql, "-- *", "*");
        }
        if (primaryKeyColumnNameSeparatedString != null && primaryKeyColumnNameSeparatedString.trim().length() != 0) {
            StringTokenizer st = new StringTokenizer(primaryKeyColumnNameSeparatedString, ",;/\t");
            while (st.hasMoreTokens()) {
                String nextToken = st.nextToken();
                retLs.add(nextToken.trim());
            }
        }
        return retLs;
    }

    public String getTitle(String sql) {
        String titleMark = TITLE_MARK;
        String descriptionMark = DESCRIPTION_MARK;
        int markIndex = sql.indexOf(TITLE_MARK);
        if (markIndex < 0) {
            return null;
        }
        String peace = sql.substring(markIndex + TITLE_MARK.length());
        int descriptionIndex = peace.indexOf(DESCRIPTION_MARK);
        int commentEndIndex = peace.indexOf("*/");
        if (descriptionIndex < 0 && commentEndIndex < 0) {
            String msg = "Title needs '*/' or '[df:description]' as closing mark: " + sql;
            throw new IllegalStateException(msg);
        }
        int titleEndIndex = descriptionIndex < 0 ? commentEndIndex : (commentEndIndex < 0 ? descriptionIndex : (commentEndIndex < descriptionIndex ? commentEndIndex : descriptionIndex));
        peace = peace.substring(0, titleEndIndex);
        peace = DfStringUtil.replace((String)peace, (String)"\r\n", (String)"\n");
        peace = DfStringUtil.replace((String)peace, (String)"\n", (String)"");
        return peace.trim();
    }

    public String getDescription(String sql) {
        String descriptionMark = DESCRIPTION_MARK;
        int markIndex = sql.indexOf(DESCRIPTION_MARK);
        if (markIndex < 0) {
            return null;
        }
        String peace = sql.substring(markIndex + DESCRIPTION_MARK.length());
        int commentEndIndex = peace.indexOf("*/");
        if (commentEndIndex < 0) {
            String msg = "Description needs '*/' as closing mark: " + sql;
            throw new IllegalStateException(msg);
        }
        peace = peace.substring(0, commentEndIndex);
        int firstLnIndex = (peace = DfStringUtil.replace((String)peace, (String)"\r\n", (String)"\n")).indexOf("\n");
        if (firstLnIndex < 0) {
            return peace.trim();
        }
        String firstLine = peace.substring(0, firstLnIndex);
        if (firstLine.trim().length() == 0) {
            peace = peace.substring(firstLnIndex + "\n".length());
        }
        return DfStringUtil.rtrim((String)peace);
    }

    protected String getTargetString(String sql, String mark) {
        List<String> targetList = this.getTargetList(sql, mark);
        return !targetList.isEmpty() ? targetList.get(0) : null;
    }

    protected List<String> getTargetList(String sql, String mark) {
        if (sql == null || sql.trim().length() == 0) {
            String msg = "The sql is invalid: " + sql;
            throw new IllegalArgumentException(msg);
        }
        List<String> betweenBeginEndMarkList = this.getListBetweenBeginEndMark(sql, "--" + mark, mark);
        if (!betweenBeginEndMarkList.isEmpty()) {
            return betweenBeginEndMarkList;
        }
        return this.getListBetweenBeginEndMark(sql, "-- " + mark, mark);
    }

    protected String getStringBetweenBeginEndMark(String targetStr, String beginMark, String endMark) {
        Srl.ScopeInfo scope = Srl.extractScopeFirst((String)targetStr, (String)beginMark, (String)endMark);
        return scope != null ? scope.getContent() : null;
    }

    protected List<String> getListBetweenBeginEndMark(String targetStr, String beginMark, String endMark) {
        List scopeList = Srl.extractScopeList((String)targetStr, (String)beginMark, (String)endMark);
        List resultList = DfCollectionUtil.newArrayList();
        for (Srl.ScopeInfo scope : scopeList) {
            resultList.add(scope.getContent());
        }
        return resultList;
    }
}

