/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.logic.jdbc.metadata.sequence.factory;

import java.util.List;
import javax.sql.DataSource;
import org.apache.torque.engine.database.model.UnifiedSchema;
import org.seasar.dbflute.logic.jdbc.metadata.sequence.DfSequenceExtractor;
import org.seasar.dbflute.logic.jdbc.metadata.sequence.DfSequenceExtractorDB2;
import org.seasar.dbflute.logic.jdbc.metadata.sequence.DfSequenceExtractorH2;
import org.seasar.dbflute.logic.jdbc.metadata.sequence.DfSequenceExtractorOracle;
import org.seasar.dbflute.logic.jdbc.metadata.sequence.DfSequenceExtractorPostgreSQL;
import org.seasar.dbflute.properties.DfBasicProperties;
import org.seasar.dbflute.properties.DfDatabaseProperties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DfSequenceExtractorFactory {
    protected DataSource _dataSource;
    protected DfBasicProperties _basicProperties;
    protected DfDatabaseProperties _databaseProperties;

    public DfSequenceExtractorFactory(DataSource dataSource, DfBasicProperties basicProperties, DfDatabaseProperties databaseProperties) {
        this._dataSource = dataSource;
        this._basicProperties = basicProperties;
        this._databaseProperties = databaseProperties;
    }

    public DfSequenceExtractor createSequenceExtractor() {
        List<UnifiedSchema> targetSchemaList = this.createTargetSchemaList();
        if (this._basicProperties.isDatabasePostgreSQL()) {
            return new DfSequenceExtractorPostgreSQL(this._dataSource, targetSchemaList);
        }
        if (this._basicProperties.isDatabaseOracle()) {
            return new DfSequenceExtractorOracle(this._dataSource, targetSchemaList);
        }
        if (this._basicProperties.isDatabaseDB2()) {
            return new DfSequenceExtractorDB2(this._dataSource, targetSchemaList);
        }
        if (this._basicProperties.isDatabaseH2()) {
            return new DfSequenceExtractorH2(this._dataSource, targetSchemaList);
        }
        return null;
    }

    protected List<UnifiedSchema> createTargetSchemaList() {
        return this._databaseProperties.getTargetSchemaList();
    }
}

