/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.logic.jdbc.metadata.info;

import org.apache.torque.engine.database.model.UnifiedSchema;
import org.seasar.dbflute.helper.StringKeyMap;
import org.seasar.dbflute.logic.jdbc.metadata.info.DfColumnMetaInfo;
import org.seasar.dbflute.logic.jdbc.metadata.info.DfTypeArrayInfo;
import org.seasar.dbflute.util.Srl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DfTypeStructInfo {
    protected final UnifiedSchema _owner;
    protected final String _typeName;
    protected final StringKeyMap<DfColumnMetaInfo> _attributeInfoMap = StringKeyMap.createAsFlexibleOrdered();
    protected String _entityType;

    public DfTypeStructInfo(UnifiedSchema owner, String typeName) {
        this._owner = owner;
        this._typeName = typeName;
    }

    public static String generateTypeName(UnifiedSchema owner, String pureTypeName) {
        return owner.getPureSchema() + "." + pureTypeName;
    }

    public boolean hasEntityType() {
        return this._entityType != null;
    }

    public boolean hasNestedStructEntityRef() {
        for (DfColumnMetaInfo columnInfo : this._attributeInfoMap.values()) {
            if (columnInfo.hasTypeArrayInfo()) {
                DfTypeArrayInfo arrayInfo;
                DfTypeArrayInfo nestedArrayInfo = arrayInfo = columnInfo.getTypeArrayInfo();
                while (nestedArrayInfo.hasNestedArray()) {
                    nestedArrayInfo = nestedArrayInfo.getNestedArrayInfo();
                }
                if (!nestedArrayInfo.hasElementStructInfo()) continue;
                return true;
            }
            if (!columnInfo.hasTypeStructInfo()) continue;
            return true;
        }
        return false;
    }

    public boolean isAdditinalSchema() {
        return this._owner.isAdditionalSchema();
    }

    public String toString() {
        return this.doToString(false);
    }

    public String toStringForHtml() {
        return this.doToString(true);
    }

    public String doToString(boolean escape) {
        return this._typeName + ":{" + (escape ? this.toStringAttributeOnlyForHtml() : this.toStringAttributeOnly()) + "}";
    }

    public String toStringAttributeOnly() {
        return this.doToStringAttributeOnly(false);
    }

    public String toStringAttributeOnlyForHtml() {
        return this.doToStringAttributeOnly(true);
    }

    protected String doToStringAttributeOnly(boolean escape) {
        StringBuilder sb = new StringBuilder();
        for (DfColumnMetaInfo info : this._attributeInfoMap.values()) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(info.getColumnName());
            if (info.hasTypeArrayInfo()) {
                DfTypeArrayInfo typeArrayInfo = info.getTypeArrayInfo();
                sb.append("(");
                sb.append(escape ? typeArrayInfo.toStringForHtml() : typeArrayInfo.toString());
                sb.append(")");
                continue;
            }
            if (!info.hasTypeStructInfo()) continue;
            DfTypeStructInfo typeStructInfo = info.getTypeStructInfo();
            sb.append("(").append(typeStructInfo.toStringSimple()).append(")");
        }
        return sb.toString();
    }

    public String toStringSimple() {
        return this._typeName + "(" + this._attributeInfoMap.size() + ")";
    }

    public UnifiedSchema getOwner() {
        return this._owner;
    }

    public String getTypeName() {
        return this._typeName;
    }

    public String getTypePureName() {
        return Srl.substringLastRear((String)this._typeName, (String[])new String[]{"."});
    }

    public String getTypeSqlName() {
        return this._owner.isAdditionalSchema() ? this.getTypeName() : this.getTypePureName();
    }

    public StringKeyMap<DfColumnMetaInfo> getAttributeInfoMap() {
        return this._attributeInfoMap;
    }

    public void putAttributeInfo(DfColumnMetaInfo attributeInfo) {
        this._attributeInfoMap.put(attributeInfo.getColumnName(), (Object)attributeInfo);
    }

    public String getEntityType() {
        return this._entityType;
    }

    public void setEntityType(String entityType) {
        this._entityType = entityType;
    }
}

