/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.logic.jdbc.metadata.info;

import org.apache.torque.engine.database.model.UnifiedSchema;
import org.seasar.dbflute.logic.jdbc.metadata.info.DfTypeStructInfo;
import org.seasar.dbflute.util.Srl;

public class DfTypeArrayInfo {
    protected final UnifiedSchema _unifiedSchema;
    protected final String _typeName;
    protected String _elementType;
    protected DfTypeArrayInfo _nestedArrayInfo;
    protected DfTypeStructInfo _elementStructInfo;
    protected String _elementJavaNative;

    public DfTypeArrayInfo(UnifiedSchema unifiedSchema, String typeName) {
        this._unifiedSchema = unifiedSchema;
        this._typeName = typeName;
    }

    public boolean hasNestedArray() {
        return this._nestedArrayInfo != null;
    }

    public boolean hasElementStructInfo() {
        return this._elementStructInfo != null;
    }

    public boolean hasElementJavaNative() {
        return this._elementJavaNative != null;
    }

    public String toString() {
        return this._typeName + this.toStringElementOnly();
    }

    public String toStringForHtml() {
        return this._typeName + this.toStringElementOnlyForHtml();
    }

    public String toStringElementOnly() {
        return this.doToStringElementOnly(false);
    }

    public String toStringElementOnlyForHtml() {
        return this.doToStringElementOnly(true);
    }

    protected String doToStringElementOnly(boolean escape) {
        StringBuilder sb = new StringBuilder();
        sb.append(escape ? "&lt;" : "<");
        if (this._nestedArrayInfo != null) {
            sb.append(escape ? this._nestedArrayInfo.toStringForHtml() : this._nestedArrayInfo.toString());
        } else if (this._elementStructInfo != null) {
            sb.append(this._elementStructInfo.toStringSimple());
        } else {
            sb.append(this._elementType);
        }
        sb.append(escape ? "&gt;" : ">");
        return sb.toString();
    }

    public UnifiedSchema getUnifiedSchema() {
        return this._unifiedSchema;
    }

    public String getTypeName() {
        return this._typeName;
    }

    public String getTypePureName() {
        return Srl.substringLastRear((String)this._typeName, (String[])new String[]{"."});
    }

    public String getTypeSqlName() {
        return this._unifiedSchema.isAdditionalSchema() ? this.getTypeName() : this.getTypePureName();
    }

    public String getElementType() {
        return this._elementType;
    }

    public void setElementType(String elementType) {
        this._elementType = elementType;
    }

    public DfTypeArrayInfo getNestedArrayInfo() {
        return this._nestedArrayInfo;
    }

    public void setNestedArrayInfo(DfTypeArrayInfo nestedArrayInfo) {
        this._nestedArrayInfo = nestedArrayInfo;
    }

    public DfTypeStructInfo getElementStructInfo() {
        return this._elementStructInfo;
    }

    public void setElementStructInfo(DfTypeStructInfo structInfo) {
        this._elementStructInfo = structInfo;
    }

    public String getElementJavaNative() {
        return this._elementJavaNative;
    }

    public void setElementJavaNative(String elementJavaNative) {
        this._elementJavaNative = elementJavaNative;
    }
}

