/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.logic.jdbc.handler;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.torque.engine.database.model.UnifiedSchema;
import org.seasar.dbflute.exception.DfJDBCException;
import org.seasar.dbflute.exception.DfProcedureListGettingFailureException;
import org.seasar.dbflute.exception.factory.ExceptionMessageBuilder;
import org.seasar.dbflute.helper.StringKeyMap;
import org.seasar.dbflute.logic.jdbc.handler.DfAbstractMetaDataHandler;
import org.seasar.dbflute.logic.jdbc.metadata.info.DfProcedureColumnMetaInfo;
import org.seasar.dbflute.logic.jdbc.metadata.info.DfProcedureMetaInfo;
import org.seasar.dbflute.logic.jdbc.metadata.info.DfProcedureSynonymMetaInfo;
import org.seasar.dbflute.logic.jdbc.metadata.info.DfSynonymMetaInfo;
import org.seasar.dbflute.logic.jdbc.metadata.info.DfTypeArrayInfo;
import org.seasar.dbflute.logic.jdbc.metadata.info.DfTypeStructInfo;
import org.seasar.dbflute.logic.jdbc.metadata.procedure.DfProcedureSupplementExtractorOracle;
import org.seasar.dbflute.logic.jdbc.metadata.synonym.DfProcedureSynonymExtractor;
import org.seasar.dbflute.logic.jdbc.metadata.synonym.factory.DfProcedureSynonymExtractorFactory;
import org.seasar.dbflute.properties.DfDatabaseProperties;
import org.seasar.dbflute.properties.DfOutsideSqlProperties;
import org.seasar.dbflute.properties.assistant.DfAdditionalSchemaInfo;
import org.seasar.dbflute.util.Srl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DfProcedureHandler
extends DfAbstractMetaDataHandler {
    private static final Log _log = LogFactory.getLog(DfProcedureHandler.class);
    protected boolean _suppressAdditionalSchema;
    protected boolean _suppressFilterByProperty;
    protected boolean _suppressLogging;
    protected DataSource _procedureSynonymDataSource;

    public List<DfProcedureMetaInfo> getAvailableProcedureList(DataSource dataSource) throws SQLException {
        return new ArrayList<DfProcedureMetaInfo>(this.getAvailableProcedureMap(dataSource).values());
    }

    public Map<String, DfProcedureMetaInfo> getAvailableProcedureMap(DataSource dataSource) throws SQLException {
        DfDatabaseProperties databaseProperties = this.getProperties().getDatabaseProperties();
        UnifiedSchema mainSchema = databaseProperties.getDatabaseSchema();
        DfOutsideSqlProperties outsideSqlProperties = this.getProperties().getOutsideSqlProperties();
        if (!outsideSqlProperties.isGenerateProcedureParameterBean()) {
            return this.newLinkedHashMap();
        }
        DatabaseMetaData metaData = dataSource.getConnection().getMetaData();
        List<DfProcedureMetaInfo> procedureList = this.getPlainProcedureList(dataSource, metaData, mainSchema);
        this.setupAdditionalSchemaProcedure(dataSource, metaData, procedureList);
        this.setupProcedureSynonym(procedureList);
        List<DfProcedureMetaInfo> filteredList = this.filterByProperty(procedureList);
        LinkedHashMap<String, DfProcedureMetaInfo> procedureHandlingMap = this.newLinkedHashMap();
        for (DfProcedureMetaInfo metaInfo : filteredList) {
            if (this.handleDuplicateProcedure(metaInfo, procedureHandlingMap, mainSchema)) continue;
            procedureHandlingMap.put(metaInfo.buildProcedureKeyName(), metaInfo);
        }
        LinkedHashMap<String, DfProcedureMetaInfo> procedureOrderedMap = this.newLinkedHashMap();
        LinkedHashMap additionalSchemaProcedureMap = this.newLinkedHashMap();
        Set entrySet = procedureHandlingMap.entrySet();
        for (Map.Entry entry : entrySet) {
            String key = (String)entry.getKey();
            DfProcedureMetaInfo metaInfo = (DfProcedureMetaInfo)entry.getValue();
            if (metaInfo.getProcedureSchema().isAdditionalSchema()) {
                additionalSchemaProcedureMap.put(key, metaInfo);
                continue;
            }
            procedureOrderedMap.put(key, metaInfo);
        }
        procedureOrderedMap.putAll(additionalSchemaProcedureMap);
        return procedureOrderedMap;
    }

    protected void setupAdditionalSchemaProcedure(DataSource dataSource, DatabaseMetaData metaData, List<DfProcedureMetaInfo> procedureList) throws SQLException {
        if (this._suppressAdditionalSchema) {
            return;
        }
        DfDatabaseProperties databaseProp = this.getProperties().getDatabaseProperties();
        List<UnifiedSchema> additionalSchemaList = databaseProp.getAdditionalSchemaList();
        for (UnifiedSchema additionalSchema : additionalSchemaList) {
            DfAdditionalSchemaInfo schemaInfo = databaseProp.getAdditionalSchemaInfo(additionalSchema);
            if (schemaInfo.isSuppressProcedure()) continue;
            List<DfProcedureMetaInfo> additionalProcedureList = this.getPlainProcedureList(dataSource, metaData, additionalSchema);
            procedureList.addAll(additionalProcedureList);
        }
    }

    protected void setupProcedureSynonym(List<DfProcedureMetaInfo> procedureList) {
        if (this._procedureSynonymDataSource == null) {
            return;
        }
        DfOutsideSqlProperties prop = this.getProperties().getOutsideSqlProperties();
        DfOutsideSqlProperties.ProcedureSynonymHandlingType handlingType = prop.getProcedureSynonymHandlingType();
        if (handlingType.equals((Object)DfOutsideSqlProperties.ProcedureSynonymHandlingType.NONE)) {
            return;
        }
        DfProcedureSynonymExtractor extractor = this.createProcedureSynonymExtractor();
        if (extractor == null) {
            return;
        }
        Map<String, DfProcedureSynonymMetaInfo> procedureSynonymMap = extractor.extractProcedureSynonymMap();
        if (!handlingType.equals((Object)DfOutsideSqlProperties.ProcedureSynonymHandlingType.INCLUDE)) {
            if (handlingType.equals((Object)DfOutsideSqlProperties.ProcedureSynonymHandlingType.SWITCH)) {
                this.log("...Clearing normal procedures: count=" + procedureList.size());
                procedureList.clear();
            } else {
                String msg = "Unexpected handling type of procedure sysnonym: " + (Object)((Object)handlingType);
                throw new IllegalStateException(msg);
            }
        }
        this.log("...Adding procedure synonyms as procedure: count=" + procedureSynonymMap.size());
        Set<Map.Entry<String, DfProcedureSynonymMetaInfo>> entrySet = procedureSynonymMap.entrySet();
        ArrayList<DfProcedureMetaInfo> procedureSynonymList = new ArrayList<DfProcedureMetaInfo>();
        for (Map.Entry<String, DfProcedureSynonymMetaInfo> entry : entrySet) {
            DfProcedureSynonymMetaInfo metaInfo = entry.getValue();
            if (!this.isSynonymAllowedSchema(metaInfo)) continue;
            String beforeName = metaInfo.getProcedureMetaInfo().buildProcedureLoggingName();
            DfProcedureMetaInfo mergedProcedure = metaInfo.createMergedProcedure();
            String afterName = mergedProcedure.buildProcedureLoggingName();
            this.log("  " + beforeName + " to " + afterName);
            procedureSynonymList.add(mergedProcedure);
        }
        procedureList.addAll(procedureSynonymList);
    }

    protected boolean isSynonymAllowedSchema(DfProcedureSynonymMetaInfo procedureSynonymMetaInfo) {
        DfSynonymMetaInfo synonymMetaInfo = procedureSynonymMetaInfo.getSynonymMetaInfo();
        UnifiedSchema synonymOwner = synonymMetaInfo.getSynonymOwner();
        DfDatabaseProperties databaseProperties = this.getProperties().getDatabaseProperties();
        DfAdditionalSchemaInfo additionalSchemaInfo = databaseProperties.getAdditionalSchemaInfo(synonymOwner);
        if (additionalSchemaInfo != null) {
            return additionalSchemaInfo.hasObjectTypeSynonym();
        }
        return databaseProperties.hasObjectTypeSynonym();
    }

    protected DfProcedureSynonymExtractor createProcedureSynonymExtractor() {
        DfProcedureSynonymExtractorFactory factory = new DfProcedureSynonymExtractorFactory(this._procedureSynonymDataSource, this.getBasicProperties(), this.getProperties().getDatabaseProperties());
        return factory.createSynonymExtractor();
    }

    protected List<DfProcedureMetaInfo> filterByProperty(List<DfProcedureMetaInfo> procedureList) {
        if (this._suppressFilterByProperty) {
            return procedureList;
        }
        DfOutsideSqlProperties outsideSqlProperties = this.getProperties().getOutsideSqlProperties();
        ArrayList<DfProcedureMetaInfo> resultList = new ArrayList<DfProcedureMetaInfo>();
        this.log("...Filtering procedures by the property: before=" + procedureList.size());
        int passedCount = 0;
        for (DfProcedureMetaInfo metaInfo : procedureList) {
            String procedureLoggingName = metaInfo.buildProcedureLoggingName();
            String procedureCatalog = metaInfo.getProcedureCatalog();
            if (!outsideSqlProperties.isTargetProcedureCatalog(procedureCatalog)) {
                this.log("  passed: non-target catalog - " + procedureLoggingName);
                ++passedCount;
                continue;
            }
            UnifiedSchema procedureSchema = metaInfo.getProcedureSchema();
            if (!outsideSqlProperties.isTargetProcedureSchema(procedureSchema.getPureSchema())) {
                this.log("  passed: non-target schema - " + procedureLoggingName);
                ++passedCount;
                continue;
            }
            String procedureFullQualifiedName = metaInfo.getProcedureFullQualifiedName();
            String procedureSchemaQualifiedName = Srl.substringFirstFront((String)procedureFullQualifiedName, (String[])new String[]{"."});
            String procedureName = metaInfo.getProcedureName();
            if (!(outsideSqlProperties.isTargetProcedureName(procedureFullQualifiedName) || outsideSqlProperties.isTargetProcedureName(procedureSchemaQualifiedName) || outsideSqlProperties.isTargetProcedureName(procedureName))) {
                this.log("  passed: non-target name - " + procedureLoggingName);
                ++passedCount;
                continue;
            }
            resultList.add(metaInfo);
        }
        if (passedCount == 0) {
            this.log("  -> All procedures are target: count=" + procedureList.size());
        }
        return resultList;
    }

    protected boolean handleDuplicateProcedure(DfProcedureMetaInfo second, Map<String, DfProcedureMetaInfo> procedureHandlingMap, UnifiedSchema mainSchema) {
        UnifiedSchema secondSchema;
        String procedureKeyName = second.buildProcedureKeyName();
        DfProcedureMetaInfo first = procedureHandlingMap.get(procedureKeyName);
        if (first == null) {
            return false;
        }
        UnifiedSchema firstSchema = first.getProcedureSchema();
        if (!firstSchema.equals(secondSchema = second.getProcedureSchema())) {
            if (firstSchema.isMainSchema()) {
                this.showDuplicateProcedure(first, second, true, "main schema");
                return true;
            }
            if (secondSchema.isMainSchema()) {
                procedureHandlingMap.remove(procedureKeyName);
                this.showDuplicateProcedure(first, second, false, "main schema");
                return false;
            }
        }
        this.showDuplicateProcedure(first, second, true, "first one");
        return true;
    }

    protected void showDuplicateProcedure(DfProcedureMetaInfo first, DfProcedureMetaInfo second, boolean electFirst, String reason) {
        String firstName = first.buildProcedureLoggingName();
        String secondName = second.buildProcedureLoggingName();
        String firstType = first.isProcedureSynonym() ? "(synonym)" : "";
        String secondType = second.isProcedureSynonym() ? "(synonym)" : "";
        String msg = "*Found the same-name procedure, so elects " + reason + ":";
        msg = electFirst ? msg + " elect=" + firstName + firstType + " skipped=" + secondName + secondType : msg + " elect=" + secondName + secondType + " skipped=" + firstName + firstType;
        this.log(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<DfProcedureMetaInfo> getPlainProcedureList(DataSource dataSource, DatabaseMetaData metaData, UnifiedSchema unifiedSchema) throws SQLException {
        block11: {
            metaInfoList = new ArrayList<DfProcedureMetaInfo>();
            procedureName = null;
            columnResultSet = null;
            try {
                try {
                    procedureRs = this.doGetProcedures(metaData, unifiedSchema);
                    this.setupProcedureMetaInfo(metaInfoList, procedureRs, unifiedSchema);
                    for (DfProcedureMetaInfo metaInfo : metaInfoList) {
                        procedureName = metaInfo.getProcedureName();
                        columnRs = this.doGetProcedureColumns(metaData, metaInfo);
                        this.setupProcedureColumnMetaInfo(metaInfo, columnRs);
                    }
                    var12_15 = null;
                    if (columnResultSet == null) break block11;
                }
                catch (SQLException e) {
                    this.throwProcedureListGettingFailureException(unifiedSchema, procedureName, e);
                    var8_11 = null;
                    var12_16 = null;
                    if (columnResultSet == null) return var8_11;
                    try {
                        columnResultSet.close();
                        return var8_11;
                    }
                    catch (SQLException ignored) {
                        // empty catch block
                    }
                    return var8_11;
                }
                catch (RuntimeException e) {
                    this.throwProcedureListGettingFailureException(unifiedSchema, procedureName, e);
                    var8_12 = null;
                    var12_17 = null;
                    if (columnResultSet == null) return var8_12;
                    ** try [egrp 2[TRYBLOCK] [6 : 151->161)] { 
lbl35:
                    // 1 sources

                    columnResultSet.close();
                    return var8_12;
lbl37:
                    // 1 sources

                    catch (SQLException ignored) {
                        // empty catch block
                    }
                    return var8_12;
                }
            }
            catch (Throwable var11_23) {
                var12_18 = null;
                if (columnResultSet == null) throw var11_23;
                ** try [egrp 2[TRYBLOCK] [6 : 151->161)] { 
lbl45:
                // 1 sources

                columnResultSet.close();
                throw var11_23;
lbl47:
                // 1 sources

                catch (SQLException ignored) {
                    // empty catch block
                }
                throw var11_23;
            }
            try {}
            catch (SQLException ignored) {}
            columnResultSet.close();
        }
        this.resolveAssitInfo(dataSource, unifiedSchema, metaInfoList);
        return metaInfoList;
    }

    protected void resolveAssitInfo(DataSource dataSource, UnifiedSchema unifiedSchema, List<DfProcedureMetaInfo> metaInfoList) {
        if (this.isDatabaseOracle()) {
            this.doResolveAssistInfoOracle(dataSource, unifiedSchema, metaInfoList);
        }
    }

    protected void doResolveAssistInfoOracle(DataSource dataSource, UnifiedSchema unifiedSchema, List<DfProcedureMetaInfo> metaInfoList) {
        DfProcedureSupplementExtractorOracle extractor = new DfProcedureSupplementExtractorOracle(dataSource);
        if (this._suppressLogging || unifiedSchema.isAdditionalSchema()) {
            extractor.suppressLogging();
        }
        StringKeyMap<Integer> parameterOverloadInfoMap = extractor.extractParameterOverloadInfoMap();
        StringKeyMap<DfTypeArrayInfo> parameterArrayInfoMap = extractor.extractParameterArrayInfoMap();
        StringKeyMap<DfTypeStructInfo> structInfoMap = extractor.extractStructInfoMap();
        LinkedHashSet<String> resolvedArrayDispSet = new LinkedHashSet<String>();
        LinkedHashSet<String> resolvedStructDispSet = new LinkedHashSet<String>();
        for (DfProcedureMetaInfo metaInfo : metaInfoList) {
            String catalog = metaInfo.getProcedureCatalog();
            String procedureName = metaInfo.getProcedureName();
            List<DfProcedureColumnMetaInfo> columnList = metaInfo.getProcedureColumnList();
            for (DfProcedureColumnMetaInfo columnInfo : columnList) {
                String dbTypeName;
                DfTypeStructInfo structInfo;
                DfTypeArrayInfo arrayInfo;
                String columnName = columnInfo.getColumnName();
                String key = extractor.generateParameterInfoMapKey(catalog, procedureName, columnName);
                Integer overloadNo = (Integer)parameterOverloadInfoMap.get(key);
                if (overloadNo != null) {
                    columnInfo.setOverloadNo(overloadNo);
                }
                if ((arrayInfo = (DfTypeArrayInfo)parameterArrayInfoMap.get((Object)key)) != null) {
                    resolvedArrayDispSet.add(arrayInfo.toString());
                    columnInfo.setTypeArrayInfo(arrayInfo);
                }
                if ((structInfo = (DfTypeStructInfo)structInfoMap.get((Object)(dbTypeName = columnInfo.getDbTypeName()))) == null) continue;
                resolvedStructDispSet.add(structInfo.toString());
                columnInfo.setTypeStructInfo(structInfo);
            }
        }
        if (!resolvedArrayDispSet.isEmpty()) {
            this.log("Array related to parameter: " + resolvedArrayDispSet.size());
            for (String arrayInfo : resolvedArrayDispSet) {
                this.log("  " + arrayInfo);
            }
        }
        if (!resolvedStructDispSet.isEmpty()) {
            this.log("Struct related to parameter: " + resolvedStructDispSet.size());
            for (String structInfo : resolvedStructDispSet) {
                this.log("  " + structInfo);
            }
        }
    }

    protected ResultSet doGetProcedures(DatabaseMetaData metaData, UnifiedSchema unifiedSchema) throws SQLException {
        String catalogName = unifiedSchema.getPureCatalog();
        String schemaName = unifiedSchema.getPureSchema();
        return metaData.getProcedures(catalogName, schemaName, null);
    }

    protected void setupProcedureMetaInfo(List<DfProcedureMetaInfo> procedureMetaInfoList, ResultSet procedureRs, UnifiedSchema unifiedSchema) throws SQLException {
        while (procedureRs.next()) {
            String procedureCatalog;
            String procedurePackage;
            String procedureSchema = procedureRs.getString("PROCEDURE_SCHEM");
            String plainCatalog = procedureRs.getString("PROCEDURE_CAT");
            if (this.isDatabaseOracle()) {
                procedurePackage = Srl.is_NotNull_and_NotTrimmedEmpty((String)plainCatalog) ? plainCatalog : null;
                procedureCatalog = null;
            } else {
                procedurePackage = null;
                procedureCatalog = Srl.is_NotNull_and_NotTrimmedEmpty((String)plainCatalog) ? plainCatalog : unifiedSchema.getPureCatalog();
            }
            String plainName = procedureRs.getString("PROCEDURE_NAME");
            String procedureName = Srl.is_NotNull_and_NotTrimmedEmpty((String)procedurePackage) ? procedurePackage + "." + plainName : plainName;
            Integer procedureType = Integer.valueOf(procedureRs.getString("PROCEDURE_TYPE"));
            String procedureComment = procedureRs.getString("REMARKS");
            DfProcedureMetaInfo metaInfo = new DfProcedureMetaInfo();
            metaInfo.setProcedureCatalog(procedureCatalog);
            metaInfo.setProcedureSchema(this.createAsDynamicSchema(procedureCatalog, procedureSchema));
            metaInfo.setProcedureName(procedureName);
            if (procedureType == 0) {
                metaInfo.setProcedureType(DfProcedureMetaInfo.DfProcedureType.procedureResultUnknown);
            } else if (procedureType == 1) {
                metaInfo.setProcedureType(DfProcedureMetaInfo.DfProcedureType.procedureNoResult);
            } else if (procedureType == 2) {
                metaInfo.setProcedureType(DfProcedureMetaInfo.DfProcedureType.procedureReturnsResult);
            } else {
                String msg = "Unknown procedureType: type=" + procedureType + " procedure=" + procedureName;
                throw new IllegalStateException(msg);
            }
            metaInfo.setProcedureComment(procedureComment);
            metaInfo.setProcedurePackage(procedurePackage);
            metaInfo.setProcedureFullQualifiedName(this.buildProcedureFullQualifiedName(metaInfo));
            metaInfo.setProcedureSchemaQualifiedName(this.buildProcedureSchemaQualifiedName(metaInfo));
            procedureMetaInfoList.add(metaInfo);
        }
    }

    protected ResultSet doGetProcedureColumns(DatabaseMetaData metaData, DfProcedureMetaInfo metaInfo) throws SQLException {
        String procedureArgName;
        String catalogArgName;
        String catalogName = metaInfo.getProcedureCatalog();
        String schemaName = metaInfo.getProcedureSchema().getPureSchema();
        String procedurePureName = metaInfo.buildProcedurePureName();
        if (this.isDatabaseMySQL() && Srl.is_NotNull_and_NotTrimmedEmpty((String)catalogName)) {
            catalogArgName = catalogName;
            procedureArgName = Srl.connectPrefix((String)procedurePureName, (String)catalogName, (String)".");
        } else if (this.isDatabaseOracle() && metaInfo.isPackageProcdure()) {
            catalogArgName = metaInfo.getProcedurePackage();
            procedureArgName = procedurePureName;
        } else {
            catalogArgName = catalogName;
            procedureArgName = procedurePureName;
        }
        return metaData.getProcedureColumns(catalogArgName, schemaName, procedureArgName, null);
    }

    protected void setupProcedureColumnMetaInfo(DfProcedureMetaInfo procedureMetaInfo, ResultSet columnRs) throws SQLException {
        HashSet<String> uniqueSet = new HashSet<String>();
        while (columnRs.next()) {
            String length;
            String columnName = columnRs.getString("COLUMN_NAME");
            if (uniqueSet.contains(columnName)) continue;
            uniqueSet.add(columnName);
            String columnType = columnRs.getString("COLUMN_TYPE");
            boolean unknowType = false;
            Integer procedureColumnType = Srl.is_NotNull_and_NotTrimmedEmpty((String)columnType) ? Integer.valueOf(this.toInt("columnType", columnType)) : Integer.valueOf(0);
            int tmpJdbcType = 1111;
            String dataType = null;
            try {
                dataType = columnRs.getString("DATA_TYPE");
            }
            catch (RuntimeException ignored) {
                String procdureName = procedureMetaInfo.getProcedureFullQualifiedName();
                this.log("*Failed to get data type: " + procdureName + "." + columnName);
                tmpJdbcType = 1111;
            }
            if (Srl.is_NotNull_and_NotTrimmedEmpty((String)dataType)) {
                tmpJdbcType = this.toInt("dataType", dataType);
            }
            int jdbcType = tmpJdbcType;
            String dbTypeName = columnRs.getString("TYPE_NAME");
            String precision = columnRs.getString("PRECISION");
            Integer columnSize = Srl.is_NotNull_and_NotTrimmedEmpty((String)precision) ? Integer.valueOf(this.toInt("precision", precision)) : (Srl.is_NotNull_and_NotTrimmedEmpty((String)(length = columnRs.getString("LENGTH"))) ? Integer.valueOf(this.toInt("length", length)) : null);
            String scale = columnRs.getString("SCALE");
            Integer decimalDigits = Srl.is_NotNull_and_NotTrimmedEmpty((String)scale) ? Integer.valueOf(this.toInt("scale", scale)) : null;
            String columnComment = columnRs.getString("REMARKS");
            DfProcedureColumnMetaInfo procedureColumnMetaInfo = new DfProcedureColumnMetaInfo();
            procedureColumnMetaInfo.setColumnName(columnName);
            if (procedureColumnType == 0) {
                procedureColumnMetaInfo.setProcedureColumnType(DfProcedureColumnMetaInfo.DfProcedureColumnType.procedureColumnUnknown);
            } else if (procedureColumnType == 1) {
                procedureColumnMetaInfo.setProcedureColumnType(DfProcedureColumnMetaInfo.DfProcedureColumnType.procedureColumnIn);
            } else if (procedureColumnType == 2) {
                procedureColumnMetaInfo.setProcedureColumnType(DfProcedureColumnMetaInfo.DfProcedureColumnType.procedureColumnInOut);
            } else if (procedureColumnType == 4) {
                procedureColumnMetaInfo.setProcedureColumnType(DfProcedureColumnMetaInfo.DfProcedureColumnType.procedureColumnOut);
            } else if (procedureColumnType == 5) {
                procedureColumnMetaInfo.setProcedureColumnType(DfProcedureColumnMetaInfo.DfProcedureColumnType.procedureColumnReturn);
            } else if (procedureColumnType == 3) {
                procedureColumnMetaInfo.setProcedureColumnType(DfProcedureColumnMetaInfo.DfProcedureColumnType.procedureColumnResult);
            } else {
                throw new IllegalStateException("Unknown procedureColumnType: " + procedureColumnType);
            }
            procedureColumnMetaInfo.setJdbcDefType(jdbcType);
            procedureColumnMetaInfo.setDbTypeName(dbTypeName);
            procedureColumnMetaInfo.setColumnSize(columnSize);
            procedureColumnMetaInfo.setDecimalDigits(decimalDigits);
            procedureColumnMetaInfo.setColumnComment(columnComment);
            procedureMetaInfo.addProcedureColumn(procedureColumnMetaInfo);
        }
        this.adjustProcedureColumnList(procedureMetaInfo);
    }

    protected int toInt(String title, String value) {
        try {
            return Integer.valueOf(value);
        }
        catch (NumberFormatException e) {
            String msg = "Failed to convert the value to integer:";
            msg = msg + " title=" + title + " value=" + value;
            throw new IllegalStateException(msg, e);
        }
    }

    protected String buildProcedureFullQualifiedName(DfProcedureMetaInfo metaInfo) {
        return metaInfo.getProcedureSchema().buildFullQualifiedName(metaInfo.getProcedureName());
    }

    protected String buildProcedureSchemaQualifiedName(DfProcedureMetaInfo metaInfo) {
        return metaInfo.getProcedureSchema().buildSchemaQualifiedName(metaInfo.getProcedureName());
    }

    protected void adjustProcedureColumnList(DfProcedureMetaInfo procedureMetaInfo) {
        this.adjustPostgreSQLResultSetParameter(procedureMetaInfo);
    }

    protected void adjustPostgreSQLResultSetParameter(DfProcedureMetaInfo procedureMetaInfo) {
        if (!this.isDatabasePostgreSQL()) {
            return;
        }
        List<DfProcedureColumnMetaInfo> columnMetaInfoList = procedureMetaInfo.getProcedureColumnList();
        boolean existsResultSetParameter = false;
        boolean existsResultSetReturn = false;
        int resultSetReturnIndex = 0;
        String resultSetReturnName = null;
        int index = 0;
        for (DfProcedureColumnMetaInfo columnMetaInfo : columnMetaInfoList) {
            DfProcedureColumnMetaInfo.DfProcedureColumnType procedureColumnType = columnMetaInfo.getProcedureColumnType();
            String dbTypeName = columnMetaInfo.getDbTypeName();
            if (procedureColumnType.equals((Object)DfProcedureColumnMetaInfo.DfProcedureColumnType.procedureColumnOut) && "refcursor".equalsIgnoreCase(dbTypeName)) {
                existsResultSetParameter = true;
            }
            if (procedureColumnType.equals((Object)DfProcedureColumnMetaInfo.DfProcedureColumnType.procedureColumnReturn) && "refcursor".equalsIgnoreCase(dbTypeName)) {
                existsResultSetReturn = true;
                resultSetReturnIndex = index;
                resultSetReturnName = columnMetaInfo.getColumnName();
            }
            ++index;
        }
        if (existsResultSetParameter && existsResultSetReturn) {
            String name = procedureMetaInfo.buildProcedureLoggingName() + "." + resultSetReturnName;
            this.log("...Removing the result set return which is unnecessary: " + name);
            columnMetaInfoList.remove(resultSetReturnIndex);
        }
    }

    protected void throwProcedureListGettingFailureException(UnifiedSchema unifiedSchema, String procedureName, Exception e) throws SQLException {
        boolean forSqlEx = e instanceof SQLException;
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("Failed to get a list of procedures.");
        br.addItem("Unified Schema");
        br.addElement((Object)unifiedSchema);
        br.addItem("Current Procedure");
        br.addElement((Object)procedureName);
        if (!forSqlEx) {
            br.addItem("Unexpected Exception");
            br.addElement((Object)e.getClass().getName());
            br.addElement((Object)e.getMessage());
        }
        String msg = br.buildExceptionMessage();
        if (forSqlEx) {
            throw new DfJDBCException(msg, (SQLException)e);
        }
        throw new DfProcedureListGettingFailureException(msg, e);
    }

    protected void log(String msg) {
        if (this._suppressLogging) {
            return;
        }
        _log.info((Object)msg);
    }

    public void suppressAdditionalSchema() {
        this._suppressAdditionalSchema = true;
    }

    public void suppressFilterByProperty() {
        this._suppressFilterByProperty = true;
    }

    public void suppressLogging() {
        this._suppressLogging = true;
    }

    public void includeProcedureSynonym(DataSource dataSource) {
        this._procedureSynonymDataSource = dataSource;
    }
}

