/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.logic.replaceschema.loaddata.impl;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.torque.engine.database.model.UnifiedSchema;
import org.seasar.dbflute.exception.DfTableDataRegistrationFailureException;
import org.seasar.dbflute.helper.StringKeyMap;
import org.seasar.dbflute.logic.replaceschema.loaddata.DfDelimiterDataHandler;
import org.seasar.dbflute.logic.replaceschema.loaddata.DfDelimiterDataResultInfo;
import org.seasar.dbflute.logic.replaceschema.loaddata.DfDelimiterDataSeveralHandlingInfo;
import org.seasar.dbflute.logic.replaceschema.loaddata.impl.DfDelimiterDataWriterImpl;
import org.seasar.dbflute.properties.filereader.DfMapStringFileReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DfDelimiterDataHandlerImpl
implements DfDelimiterDataHandler {
    private static final Log _log = LogFactory.getLog(DfDelimiterDataHandlerImpl.class);
    protected boolean _loggingInsertSql;
    protected DataSource _dataSource;
    protected UnifiedSchema _unifiedSchema;
    protected boolean _suppressBatchUpdate;

    @Override
    public DfDelimiterDataResultInfo writeSeveralData(DfDelimiterDataSeveralHandlingInfo info) {
        DfDelimiterDataResultInfo resultInfo = new DfDelimiterDataResultInfo();
        LinkedHashMap<String, Set<String>> notFoundColumnMap = new LinkedHashMap<String, Set<String>>();
        resultInfo.setNotFoundColumnMap(notFoundColumnMap);
        File baseDir = new File(info.getBasePath());
        String[] dataDirectoryElements = baseDir.list(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return !name.startsWith(".");
            }
        });
        if (dataDirectoryElements == null) {
            return resultInfo;
        }
        FilenameFilter filter = this.createFilenameFilter(info.getTypeName());
        try {
            for (String elementName : dataDirectoryElements) {
                if (this.isUnsupportedEncodingDirectory(elementName)) {
                    _log.warn((Object)("The encoding(directory name) is unsupported: encoding=" + elementName));
                    continue;
                }
                File encodingNameDirectory = new File(info.getBasePath() + "/" + elementName);
                String[] fileNameList = encodingNameDirectory.list(filter);
                Comparator<String> fileNameAscComparator = new Comparator<String>(){

                    @Override
                    public int compare(String o1, String o2) {
                        return o1.compareTo(o2);
                    }
                };
                TreeSet<String> sortedFileNameSet = new TreeSet<String>(fileNameAscComparator);
                for (String fileName : fileNameList) {
                    sortedFileNameSet.add(fileName);
                }
                Map<String, Map<String, String>> convertValueMap = this.getConvertValueMap(info, elementName);
                Map<String, String> defaultValueMap = this.getDefaultValueMap(info, elementName);
                for (String fileName : sortedFileNameSet) {
                    String fileNamePath = info.getBasePath() + "/" + elementName + "/" + fileName;
                    DfDelimiterDataWriterImpl writer = new DfDelimiterDataWriterImpl(this._dataSource);
                    writer.setUnifiedSchema(this._unifiedSchema);
                    writer.setLoggingInsertSql(this.isLoggingInsertSql());
                    writer.setFilename(fileNamePath);
                    writer.setEncoding(elementName);
                    writer.setDelimiter(info.getDelimter());
                    writer.setConvertValueMap(convertValueMap);
                    writer.setDefaultValueMap(defaultValueMap);
                    writer.setSuppressBatchUpdate(this.isSuppressBatchUpdate());
                    writer.writeData(notFoundColumnMap);
                }
            }
        }
        catch (IOException e) {
            String msg = "Failed to register delimiter data.";
            throw new DfTableDataRegistrationFailureException(msg, e);
        }
        return resultInfo;
    }

    protected boolean isUnsupportedEncodingDirectory(String encoding) {
        try {
            new String(new byte[0], 0, 0, encoding);
            return false;
        }
        catch (UnsupportedEncodingException e) {
            return true;
        }
    }

    private Map<String, Map<String, String>> getConvertValueMap(DfDelimiterDataSeveralHandlingInfo info, String encoding) {
        DfMapStringFileReader reader = new DfMapStringFileReader();
        String path = info.getBasePath() + "/" + encoding + "/convertValueMap.dataprop";
        StringKeyMap resultMap = StringKeyMap.createAsFlexibleOrdered();
        Map<String, Map<String, String>> readMap = reader.readMapAsStringMapValue(path);
        if (readMap != null && !readMap.isEmpty()) {
            resultMap.putAll(readMap);
            return resultMap;
        }
        path = info.getBasePath() + "/" + encoding + "/convert-value.txt";
        readMap = reader.readMapAsStringMapValue(path);
        resultMap.putAll(readMap);
        return resultMap;
    }

    private Map<String, String> getDefaultValueMap(DfDelimiterDataSeveralHandlingInfo info, String encoding) {
        DfMapStringFileReader reader = new DfMapStringFileReader();
        String path = info.getBasePath() + "/" + encoding + "/defaultValueMap.dataprop";
        StringKeyMap resultMap = StringKeyMap.createAsFlexibleOrdered();
        Map<String, String> readMap = reader.readMapAsStringValue(path);
        if (readMap != null && !readMap.isEmpty()) {
            resultMap.putAll(readMap);
            return resultMap;
        }
        path = info.getBasePath() + "/" + encoding + "/default-value.txt";
        readMap = reader.readMapAsStringValue(path);
        resultMap.putAll(readMap);
        return resultMap;
    }

    protected FilenameFilter createFilenameFilter(final String typeName) {
        FilenameFilter filter = new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith("." + typeName);
            }
        };
        return filter;
    }

    public boolean isLoggingInsertSql() {
        return this._loggingInsertSql;
    }

    public void setLoggingInsertSql(boolean loggingInsertSql) {
        this._loggingInsertSql = loggingInsertSql;
    }

    public DataSource getDataSource() {
        return this._dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this._dataSource = dataSource;
    }

    public UnifiedSchema getUnifiedSchema() {
        return this._unifiedSchema;
    }

    public void setUnifiedSchema(UnifiedSchema unifiedSchema) {
        this._unifiedSchema = unifiedSchema;
    }

    public boolean isSuppressBatchUpdate() {
        return this._suppressBatchUpdate;
    }

    public void setSuppressBatchUpdate(boolean suppressBatchUpdate) {
        this._suppressBatchUpdate = suppressBatchUpdate;
    }
}

