/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.logic.jdbc.metadata.procedure;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.torque.engine.database.model.UnifiedSchema;
import org.seasar.dbflute.helper.jdbc.facade.DfJdbcFacade;
import org.seasar.dbflute.util.DfCollectionUtil;
import org.seasar.dbflute.util.Srl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DfProcedureParameterExtractorOracle {
    private static final Log _log = LogFactory.getLog(DfProcedureParameterExtractorOracle.class);
    protected final DataSource _dataSource;
    protected final boolean _suppressLogging;

    public DfProcedureParameterExtractorOracle(DataSource dataSource, boolean suppressLogging) {
        this._dataSource = dataSource;
        this._suppressLogging = suppressLogging;
    }

    public List<ProcedureArgumentInfo> extractProcedureArgumentInfoList(UnifiedSchema unifiedSchema) {
        return this.selectProcedureArgumentInfoList(unifiedSchema);
    }

    protected List<ProcedureArgumentInfo> selectProcedureArgumentInfoList(UnifiedSchema unifiedSchema) {
        List<Map<String, String>> resultList;
        DfJdbcFacade facade = new DfJdbcFacade(this._dataSource);
        String sql = this.buildProcedureArgumentSql(unifiedSchema);
        ArrayList<String> columnList = new ArrayList<String>();
        columnList.add("PACKAGE_NAME");
        columnList.add("OBJECT_NAME");
        columnList.add("OVERLOAD");
        columnList.add("SEQUENCE");
        columnList.add("ARGUMENT_NAME");
        columnList.add("DATA_TYPE");
        columnList.add("TYPE_OWNER");
        columnList.add("TYPE_NAME");
        columnList.add("TYPE_SUBNAME");
        try {
            this.log(sql);
            resultList = facade.selectStringList(sql, columnList);
        }
        catch (Exception continued) {
            this.log("Failed to select procedure argument info: " + continued.getMessage());
            return DfCollectionUtil.emptyList();
        }
        List infoList = DfCollectionUtil.newArrayList();
        for (Map<String, String> map : resultList) {
            ProcedureArgumentInfo info = new ProcedureArgumentInfo();
            info.setPackageName(map.get("PACKAGE_NAME"));
            info.setObjectName(map.get("OBJECT_NAME"));
            info.setOverload(map.get("OVERLOAD"));
            info.setSequence(map.get("SEQUENCE"));
            info.setArgumentName(map.get("ARGUMENT_NAME"));
            info.setDataType(map.get("DATA_TYPE"));
            String typeOwner = map.get("TYPE_OWNER");
            info.setTypeOwner(typeOwner);
            String typeName = map.get("TYPE_NAME");
            if (Srl.is_NotNull_and_NotTrimmedEmpty((String)typeName)) {
                info.setTypeName(Srl.connectPrefix((String)typeName, (String)typeOwner, (String)"."));
            }
            info.setTypeSubName(map.get("TYPE_SUBNAME"));
            infoList.add(info);
        }
        return infoList;
    }

    protected String buildProcedureArgumentSql(UnifiedSchema unifiedSchema) {
        StringBuilder sb = new StringBuilder();
        sb.append("select *");
        sb.append(" from ALL_ARGUMENTS");
        sb.append(" where OWNER = '" + unifiedSchema.getPureSchema() + "'");
        sb.append(" order by PACKAGE_NAME, OBJECT_NAME, OVERLOAD, SEQUENCE");
        return sb.toString();
    }

    protected void log(String msg) {
        if (this._suppressLogging) {
            return;
        }
        _log.info((Object)msg);
    }

    public static class ProcedureArgumentInfo {
        protected String _packageName;
        protected String _objectName;
        protected String _overload;
        protected String _sequence;
        protected String _argumentName;
        protected String _dataType;
        protected String _typeOwner;
        protected String _typeName;
        protected String _typeSubName;

        public String buildArrayTypeName() {
            String typeName = this.getTypeName();
            String typeSubName = this.getTypeSubName();
            if (Srl.is_NotNull_and_NotTrimmedEmpty((String)typeSubName)) {
                return typeName + "." + typeSubName;
            }
            return typeName;
        }

        public String getPackageName() {
            return this._packageName;
        }

        public void setPackageName(String packageName) {
            this._packageName = packageName;
        }

        public String getObjectName() {
            return this._objectName;
        }

        public void setObjectName(String objectName) {
            this._objectName = objectName;
        }

        public String getOverload() {
            return this._overload;
        }

        public void setOverload(String overload) {
            this._overload = overload;
        }

        public String getSequence() {
            return this._sequence;
        }

        public void setSequence(String sequence) {
            this._sequence = sequence;
        }

        public String getArgumentName() {
            return this._argumentName;
        }

        public void setArgumentName(String argumentName) {
            this._argumentName = argumentName;
        }

        public String getDataType() {
            return this._dataType;
        }

        public void setDataType(String dataType) {
            this._dataType = dataType;
        }

        public String getTypeName() {
            return this._typeName;
        }

        public void setTypeName(String typeName) {
            this._typeName = typeName;
        }

        public String getTypeOwner() {
            return this._typeOwner;
        }

        public void setTypeOwner(String typeOwner) {
            this._typeOwner = typeOwner;
        }

        public String getTypeSubName() {
            return this._typeSubName;
        }

        public void setTypeSubName(String typeSubName) {
            this._typeSubName = typeSubName;
        }
    }
}

