/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.properties;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.Properties;
import org.seasar.dbflute.properties.DfAbstractHelperProperties;
import org.seasar.dbflute.util.DfStringUtil;

public final class DfAllClassCopyrightProperties
extends DfAbstractHelperProperties {
    protected String _copyright;

    public DfAllClassCopyrightProperties(Properties prop) {
        super(prop);
    }

    public String getAllClassCopyright() {
        if (this._copyright != null) {
            return this._copyright;
        }
        String prop = this.stringProp("torque.allClassCopyright", "");
        String sourceCodeLn = this.getBasicProperties().getSourceCodeLineSeparator();
        prop = DfStringUtil.replace((String)prop, (String)"\r\n", (String)"\n");
        this._copyright = prop = DfStringUtil.replace((String)prop, (String)"\n", (String)sourceCodeLn);
        return this._copyright;
    }

    public void reflectAllExCopyright(String path) {
        BufferedReader bufferedReader;
        String copyright = this.getAllClassCopyright();
        if (copyright == null || copyright.trim().length() == 0) {
            return;
        }
        File exfile = new File(path);
        String encoding = this.getBasicProperties().getTemplateFileEncoding();
        try {
            bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(exfile), encoding));
        }
        catch (UnsupportedEncodingException e) {
            String msg = "The encoding is unsupported: encoding=" + encoding;
            throw new IllegalStateException(msg, e);
        }
        catch (FileNotFoundException e) {
            String msg = "The file of extended class was NOT found: exfile=" + exfile;
            throw new IllegalStateException(msg, e);
        }
        StringBuilder sb = new StringBuilder();
        String sourceCodeLn = this.getBasicProperties().getSourceCodeLineSeparator();
        String lineString = null;
        int index = 0;
        try {
            while ((lineString = bufferedReader.readLine()) != null) {
                if (index == 0) {
                    if (!lineString.trim().startsWith("package ")) {
                        return;
                    }
                    sb.append(copyright);
                }
                sb.append(lineString);
                sb.append(sourceCodeLn);
                ++index;
            }
        }
        catch (IOException e) {
            String msg = "bufferedReader.readLine() threw the exception: current line=" + lineString;
            throw new IllegalStateException(msg, e);
        }
        finally {
            try {
                bufferedReader.close();
            }
            catch (IOException ignored) {}
        }
        BufferedWriter bufferedWriter = null;
        try {
            bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(exfile), encoding));
            bufferedWriter.write(sb.toString());
            bufferedWriter.flush();
        }
        catch (UnsupportedEncodingException e) {
            String msg = "The encoding is unsupported: encoding=" + encoding;
            throw new IllegalStateException(msg, e);
        }
        catch (FileNotFoundException e) {
            String msg = "The file of base behavior was not found: bsbhvFile=" + exfile;
            throw new IllegalStateException(msg, e);
        }
        catch (IOException e) {
            String msg = "bufferedWriter.write() threw the exception: bsbhvFile=" + exfile;
            throw new IllegalStateException(msg, e);
        }
        finally {
            if (bufferedWriter != null) {
                try {
                    bufferedWriter.close();
                }
                catch (IOException ignored) {}
            }
        }
    }
}

