/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.logic.jdbc.handler;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.dbflute.helper.StringSet;
import org.seasar.dbflute.logic.jdbc.handler.DfAbstractMetaDataHandler;
import org.seasar.dbflute.logic.jdbc.metadata.info.DfTableMetaInfo;
import org.seasar.dbflute.properties.assistant.DfAdditionalSchemaInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DfTableHandler
extends DfAbstractMetaDataHandler {
    private static final Log _log = LogFactory.getLog(DfTableHandler.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<DfTableMetaInfo> getTableList(DatabaseMetaData dbMeta, String schemaName) throws SQLException {
        ArrayList<DfTableMetaInfo> tableList;
        block6: {
            schemaName = this.filterSchemaName(schemaName);
            String[] objectTypes = this.getRealObjectTypeTargetArray(schemaName);
            tableList = new ArrayList<DfTableMetaInfo>();
            ResultSet resultSet = null;
            try {
                _log.info((Object)("...Getting tables: schema=" + schemaName + " objectTypes=" + Arrays.asList(objectTypes)));
                resultSet = dbMeta.getTables(null, schemaName, "%", objectTypes);
                while (resultSet.next()) {
                    String tableName = resultSet.getString(3);
                    String tableType = resultSet.getString(4);
                    String tableSchema = resultSet.getString("TABLE_SCHEM");
                    String tableComment = resultSet.getString("REMARKS");
                    if (this.isTableExcept(schemaName, tableName)) {
                        _log.info((Object)(tableName + " is excepted!"));
                        continue;
                    }
                    if (this.isSystemTableForDBMS(tableName)) {
                        _log.info((Object)(tableName + " is excepted! {system table}"));
                        continue;
                    }
                    DfTableMetaInfo tableMetaInfo = new DfTableMetaInfo();
                    tableMetaInfo.setTableName(tableName);
                    tableMetaInfo.setTableType(tableType);
                    tableMetaInfo.setTableSchema(tableSchema);
                    tableMetaInfo.setTableComment(tableComment);
                    tableList.add(tableMetaInfo);
                }
                Object var12_11 = null;
                if (resultSet == null) break block6;
            }
            catch (Throwable throwable) {
                Object var12_12 = null;
                if (resultSet != null) {
                    resultSet.close();
                }
                throw throwable;
            }
            resultSet.close();
        }
        this.resolveSameNameTable(tableList);
        return tableList;
    }

    public boolean isSystemTableForDBMS(String tableName) {
        if (this.isOracle() && tableName.startsWith("BIN$")) {
            return true;
        }
        if (this.isSQLServer()) {
            StringSet systemSet = StringSet.createAsFlexible();
            systemSet.add("sysobjects");
            systemSet.add("sysconstraints");
            systemSet.add("syssegments");
            if (systemSet.contains(tableName)) {
                return true;
            }
        }
        return false;
    }

    protected String[] getRealObjectTypeTargetArray(String schemaName) {
        Map<String, DfAdditionalSchemaInfo> additionalSchemaMap;
        DfAdditionalSchemaInfo schemaInfo;
        if (schemaName != null && (schemaInfo = (additionalSchemaMap = this.getAdditionalSchemaMap()).get(schemaName)) != null) {
            List<String> objectTypeTargetList = schemaInfo.getObjectTypeTargetList();
            this.assertObjectTypeTargetListNotEmpty(schemaName, objectTypeTargetList);
            return objectTypeTargetList.toArray(new String[objectTypeTargetList.size()]);
        }
        List<String> objectTypeTargetList = this.getProperties().getDatabaseProperties().getObjectTypeTargetList();
        this.assertObjectTypeTargetListNotEmpty(schemaName, objectTypeTargetList);
        return objectTypeTargetList.toArray(new String[objectTypeTargetList.size()]);
    }

    protected void assertObjectTypeTargetListNotEmpty(String schemaName, List<String> objectTypeTargetList) {
        if (objectTypeTargetList == null || objectTypeTargetList.isEmpty()) {
            String msg = "The property 'objectTypeTargetList' should be required:";
            msg = msg + " schemaName=" + schemaName;
            throw new IllegalStateException(msg);
        }
    }

    protected void resolveSameNameTable(List<DfTableMetaInfo> tableMetaInfoList) {
        String tableName;
        HashSet<String> tableNameSet = new HashSet<String>();
        HashSet<String> sameNameTableNameSet = new HashSet<String>();
        for (DfTableMetaInfo info : tableMetaInfoList) {
            tableName = info.getTableName();
            if (tableNameSet.contains(tableName)) {
                sameNameTableNameSet.add(tableName);
            }
            tableNameSet.add(tableName);
        }
        if (tableNameSet.size() == tableMetaInfoList.size()) {
            return;
        }
        for (DfTableMetaInfo tableMetaInfo : tableMetaInfoList) {
            tableName = tableMetaInfo.getTableName();
            if (!sameNameTableNameSet.contains(tableName)) continue;
            _log.info((Object)("$ sameNameTable --> " + tableMetaInfo));
            tableMetaInfo.setExistSameNameTable(true);
        }
    }
}

