/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.logic.jdbc.handler;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.seasar.dbflute.DfBuildProperties;
import org.seasar.dbflute.helper.jdbc.determiner.DfJdbcDeterminer;
import org.seasar.dbflute.logic.factory.DfJdbcDeterminerFactory;
import org.seasar.dbflute.properties.DfBasicProperties;
import org.seasar.dbflute.properties.assistant.DfAdditionalSchemaInfo;
import org.seasar.dbflute.util.DfNameHintUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DfAbstractMetaDataHandler {
    private List<String> _tableExceptList;
    private List<String> _tableTargetList;
    private Map<String, List<String>> _columnExceptMap;
    private Map<String, DfAdditionalSchemaInfo> _additionalSchemaMap;

    protected final List<String> getTableExceptList() {
        if (this._tableExceptList == null) {
            this._tableExceptList = this.getProperties().getDatabaseProperties().getTableExceptList();
        }
        return this._tableExceptList;
    }

    protected final List<String> getTableTargetList() {
        if (this._tableTargetList == null) {
            this._tableTargetList = this.getProperties().getDatabaseProperties().getTableTargetList();
        }
        return this._tableTargetList;
    }

    protected final Map<String, List<String>> getColumnExceptMap() {
        if (this._columnExceptMap == null) {
            this._columnExceptMap = this.getProperties().getDatabaseProperties().getColumnExceptMap();
        }
        return this._columnExceptMap;
    }

    protected final Map<String, DfAdditionalSchemaInfo> getAdditionalSchemaMap() {
        if (this._additionalSchemaMap == null) {
            this._additionalSchemaMap = this.getProperties().getDatabaseProperties().getAdditionalSchemaMap();
        }
        return this._additionalSchemaMap;
    }

    public boolean isTableExcept(String schemaName, String tableName) {
        List<String> tableExceptList;
        if (tableName == null) {
            throw new IllegalArgumentException("The argument 'tableName' should not be null.");
        }
        List<String> tableTargetList = this.getRealTableTargetList(schemaName);
        return !this.isTargetByHint(tableName, tableTargetList, tableExceptList = this.getRealTableExceptList(schemaName));
    }

    protected List<String> getRealTableExceptList(String schemaName) {
        Map<String, DfAdditionalSchemaInfo> additionalSchemaMap;
        DfAdditionalSchemaInfo schemaInfo;
        if (schemaName != null && (schemaInfo = (additionalSchemaMap = this.getAdditionalSchemaMap()).get(schemaName)) != null) {
            return schemaInfo.getTableExceptList();
        }
        return this.getTableExceptList();
    }

    protected List<String> getRealTableTargetList(String schemaName) {
        Map<String, DfAdditionalSchemaInfo> additionalSchemaMap;
        DfAdditionalSchemaInfo schemaInfo;
        if (schemaName != null && (schemaInfo = (additionalSchemaMap = this.getAdditionalSchemaMap()).get(schemaName)) != null) {
            return schemaInfo.getTableTargetList();
        }
        return this.getTableTargetList();
    }

    public boolean isColumnExcept(String schemaName, String tableName, String columnName) {
        if (tableName == null) {
            throw new IllegalArgumentException("The argument 'tableName' should not be null.");
        }
        if (columnName == null) {
            throw new IllegalArgumentException("The argument 'columnName' should not be null.");
        }
        Map<String, List<String>> columnExceptMap = this.getRealColumnExceptMap(schemaName);
        List<String> columnExceptList = columnExceptMap.get(tableName);
        if (columnExceptList == null) {
            return false;
        }
        return !this.isTargetByHint(columnName, new ArrayList<String>(), columnExceptList);
    }

    protected Map<String, List<String>> getRealColumnExceptMap(String schemaName) {
        Map<String, DfAdditionalSchemaInfo> additionalSchemaMap;
        DfAdditionalSchemaInfo schemaInfo;
        if (schemaName != null && (schemaInfo = (additionalSchemaMap = this.getAdditionalSchemaMap()).get(schemaName)) != null) {
            return new HashMap<String, List<String>>();
        }
        return this.getColumnExceptMap();
    }

    protected boolean isTargetByHint(String name, List<String> targetList, List<String> exceptList) {
        return DfNameHintUtil.isTargetByHint(name, targetList, exceptList);
    }

    protected String filterSchemaName(String schemaName) {
        if (schemaName != null && schemaName.trim().length() == 0 && !this.isSchemaNameEmptyAllowed()) {
            return null;
        }
        return schemaName;
    }

    protected boolean isSchemaNameEmptyAllowed() {
        return this.createJdbcDeterminer().isSchemaNameEmptyAllowed();
    }

    protected boolean isPrimaryKeyExtractingSupported() {
        return this.createJdbcDeterminer().isPrimaryKeyExtractingSupported();
    }

    protected boolean isForeignKeyExtractingSupported() {
        return this.createJdbcDeterminer().isForeignKeyExtractingSupported();
    }

    protected DfJdbcDeterminer createJdbcDeterminer() {
        return new DfJdbcDeterminerFactory(this.getBasicProperties()).createJdbcDeterminer();
    }

    protected DfBuildProperties getProperties() {
        return DfBuildProperties.getInstance();
    }

    protected DfBasicProperties getBasicProperties() {
        return DfBuildProperties.getInstance().getBasicProperties();
    }

    protected boolean isOracle() {
        return this.getBasicProperties().isDatabaseOracle();
    }

    protected boolean isPostgreSQL() {
        return this.getBasicProperties().isDatabasePostgreSQL();
    }

    protected boolean isDB2() {
        return this.getBasicProperties().isDatabaseDB2();
    }

    protected boolean isSQLServer() {
        return this.getBasicProperties().isDatabaseSqlServer();
    }

    protected boolean isMsAccess() {
        return this.getBasicProperties().isDatabaseMsAccess();
    }

    protected String ln() {
        return "\n";
    }

    protected <KEY, VALUE> LinkedHashMap<KEY, VALUE> newLinkedHashMap() {
        return new LinkedHashMap();
    }
}

