/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.helper.io.data.impl;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.dbflute.helper.io.data.DfSeparatedDataHandler;
import org.seasar.dbflute.helper.io.data.DfSeparatedDataResultInfo;
import org.seasar.dbflute.helper.io.data.DfSeparatedDataSeveralHandlingInfo;
import org.seasar.dbflute.helper.io.data.impl.DfSeparatedDataWriterImpl;
import org.seasar.dbflute.properties.filereader.DfMapStringFileReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DfSeparatedDataHandlerImpl
implements DfSeparatedDataHandler {
    private static final Log _log = LogFactory.getLog(DfSeparatedDataHandlerImpl.class);
    protected boolean _loggingInsertSql;
    protected DataSource _dataSource;

    @Override
    public DfSeparatedDataResultInfo writeSeveralData(DfSeparatedDataSeveralHandlingInfo info) {
        DfSeparatedDataResultInfo resultInfo = new DfSeparatedDataResultInfo();
        LinkedHashMap<String, Set<String>> notFoundColumnMap = new LinkedHashMap<String, Set<String>>();
        resultInfo.setNotFoundColumnMap(notFoundColumnMap);
        File baseDir = new File(info.getBasePath());
        String[] dataDirectoryElements = baseDir.list(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return !name.startsWith(".");
            }
        });
        if (dataDirectoryElements == null) {
            return resultInfo;
        }
        FilenameFilter filter = this.createFilenameFilter(info.getTypeName());
        try {
            for (String elementName : dataDirectoryElements) {
                if (this.isUnsupportedEncodingDirectory(elementName)) {
                    _log.warn((Object)("The encoding(directory name) is unsupported: encoding=" + elementName));
                    continue;
                }
                File encodingNameDirectory = new File(info.getBasePath() + "/" + elementName);
                String[] fileNameList = encodingNameDirectory.list(filter);
                Comparator<String> fileNameAscComparator = new Comparator<String>(){

                    @Override
                    public int compare(String o1, String o2) {
                        return o1.compareTo(o2);
                    }
                };
                TreeSet<String> sortedFileNameSet = new TreeSet<String>(fileNameAscComparator);
                for (String fileName : fileNameList) {
                    sortedFileNameSet.add(fileName);
                }
                Map<String, Map<String, String>> convertValueMap = this.getConvertValueMap(info, elementName);
                Map<String, String> defaultValueMap = this.getDefaultValueMap(info, elementName);
                for (String fileName : sortedFileNameSet) {
                    String fileNamePath = info.getBasePath() + "/" + elementName + "/" + fileName;
                    DfSeparatedDataWriterImpl writerImpl = new DfSeparatedDataWriterImpl();
                    writerImpl.setLoggingInsertSql(this.isLoggingInsertSql());
                    writerImpl.setDataSource(this._dataSource);
                    writerImpl.setFilename(fileNamePath);
                    writerImpl.setEncoding(elementName);
                    writerImpl.setDelimiter(info.getDelimter());
                    writerImpl.setErrorContinue(true);
                    writerImpl.setConvertValueMap(convertValueMap);
                    writerImpl.setDefaultValueMap(defaultValueMap);
                    writerImpl.writeData(notFoundColumnMap);
                }
            }
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return resultInfo;
    }

    protected boolean isUnsupportedEncodingDirectory(String encoding) {
        try {
            new String(new byte[0], 0, 0, encoding);
            return false;
        }
        catch (UnsupportedEncodingException e) {
            return true;
        }
    }

    private Map<String, Map<String, String>> getConvertValueMap(DfSeparatedDataSeveralHandlingInfo info, String encoding) {
        DfMapStringFileReader reader = new DfMapStringFileReader();
        String path = info.getBasePath() + "/" + encoding + "/convertValueMap.dataprop";
        Map<String, Map<String, String>> resultMap = reader.readMapAsStringMapValue(path);
        if (resultMap != null && !resultMap.isEmpty()) {
            return resultMap;
        }
        path = info.getBasePath() + "/" + encoding + "/convert-value.txt";
        resultMap = reader.readMapAsStringMapValue(path);
        return resultMap;
    }

    private Map<String, String> getDefaultValueMap(DfSeparatedDataSeveralHandlingInfo info, String encoding) {
        DfMapStringFileReader reader = new DfMapStringFileReader();
        String path = info.getBasePath() + "/" + encoding + "/defaultValueMap.dataprop";
        Map<String, String> resultMap = reader.readMapAsStringValue(path);
        if (resultMap != null && !resultMap.isEmpty()) {
            return resultMap;
        }
        path = info.getBasePath() + "/" + encoding + "/default-value.txt";
        resultMap = reader.readMapAsStringValue(path);
        return resultMap;
    }

    protected FilenameFilter createFilenameFilter(final String typeName) {
        FilenameFilter filter = new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith("." + typeName);
            }
        };
        return filter;
    }

    public boolean isLoggingInsertSql() {
        return this._loggingInsertSql;
    }

    public void setLoggingInsertSql(boolean loggingInsertSql) {
        this._loggingInsertSql = loggingInsertSql;
    }

    public DataSource getDataSource() {
        return this._dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this._dataSource = dataSource;
    }
}

