/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.s2dao.sqlhandler;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Map;
import javax.sql.DataSource;
import org.seasar.dbflute.helper.StringKeyMap;
import org.seasar.dbflute.jdbc.StatementFactory;
import org.seasar.dbflute.jdbc.ValueType;
import org.seasar.dbflute.s2dao.jdbc.TnResultSetHandler;
import org.seasar.dbflute.s2dao.metadata.TnPropertyType;
import org.seasar.dbflute.s2dao.metadata.impl.TnPropertyTypeImpl;
import org.seasar.dbflute.s2dao.procedure.TnProcedureMetaData;
import org.seasar.dbflute.s2dao.procedure.TnProcedureParameterType;
import org.seasar.dbflute.s2dao.sqlhandler.TnBasicSelectHandler;
import org.seasar.dbflute.s2dao.valuetype.TnValueTypes;

public class TnProcedureHandler
extends TnBasicSelectHandler {
    private TnProcedureMetaData procedureMetaData;

    public TnProcedureHandler(DataSource dataSource, String sql, TnResultSetHandler resultSetHandler, StatementFactory statementFactory, TnProcedureMetaData procedureMetaData) {
        super(dataSource, sql, resultSetHandler, statementFactory);
        this.procedureMetaData = procedureMetaData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object execute(Connection connection, Object[] args, Class[] argTypes) {
        Object dto = this.getArgumentDto(args);
        this.logSql(args, argTypes);
        CallableStatement cs = null;
        try {
            ResultSet resultSet;
            cs = this.prepareCallableStatement(connection);
            this.bindArgs(cs, dto);
            Object returnValue = null;
            if (cs.execute() && (resultSet = cs.getResultSet()) != null) {
                TnResultSetHandler handler = this.createReturnResultSetHandler(resultSet);
                try {
                    returnValue = handler.handle(resultSet);
                }
                finally {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
            }
            Object object = this.handleOutParameters(cs, dto, returnValue);
            return object;
        }
        catch (SQLException e) {
            this.handleSQLException(e, cs);
            Object var7_9 = null;
            return var7_9;
        }
        finally {
            this.close(cs);
        }
    }

    protected TnResultSetHandler createReturnResultSetHandler(ResultSet resultSet) {
        return new TnMapListResultSetHandler();
    }

    protected String getDisplaySql(Object[] args) {
        String sql = this.getSql();
        Object dto = this.getArgumentDto(args);
        if (args == null || dto == null) {
            return sql;
        }
        StringBuilder sb = new StringBuilder(100);
        int pos = 0;
        int pos2 = 0;
        for (TnProcedureParameterType ppt : this.procedureMetaData.parameterTypes()) {
            pos2 = sql.indexOf(63, pos);
            if (pos2 < 0) break;
            sb.append(sql.substring(pos, pos2));
            pos = pos2 + 1;
            if (ppt.isInType()) {
                sb.append(this.getBindVariableText(ppt.getValue(dto)));
                continue;
            }
            sb.append(sql.substring(pos2, pos));
        }
        sb.append(sql.substring(pos));
        return sb.toString();
    }

    protected CallableStatement prepareCallableStatement(Connection connection) {
        if (this.getSql() == null) {
            throw new IllegalStateException("The SQL should not be null!");
        }
        return this.getStatementFactory().createCallableStatement(connection, this.getSql());
    }

    protected void bindArgs(CallableStatement cs, Object dto) throws SQLException {
        if (dto == null) {
            return;
        }
        int i = 0;
        for (TnProcedureParameterType ppt : this.procedureMetaData.parameterTypes()) {
            ValueType valueType = ppt.getValueType();
            if (ppt.isOutType()) {
                valueType.registerOutParameter(cs, i + 1);
            }
            if (ppt.isInType()) {
                Object value = ppt.getValue(dto);
                valueType.bindValue((PreparedStatement)cs, i + 1, value);
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object handleResultSet(CallableStatement cs) throws SQLException {
        ResultSet rs = null;
        try {
            rs = this.getResultSet(cs);
            Object object = this.getResultSetHandler().handle(rs);
            return object;
        }
        finally {
            this.close(rs);
        }
    }

    protected ResultSet getResultSet(Statement statement) {
        try {
            return statement.getResultSet();
        }
        catch (SQLException e) {
            this.handleSQLException(e, statement);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object handleOutParameters(CallableStatement cs, Object dto, Object returnValue) throws SQLException {
        if (dto == null) {
            return null;
        }
        int i = 0;
        for (TnProcedureParameterType ppt : this.procedureMetaData.parameterTypes()) {
            ValueType valueType = ppt.getValueType();
            if (ppt.isOutType()) {
                Object value = valueType.getValue(cs, i + 1);
                if (value instanceof ResultSet) {
                    ResultSet resultSet = (ResultSet)value;
                    TnResultSetHandler handler = this.createOutParameterResultSetHandler(ppt, resultSet);
                    try {
                        value = handler.handle(resultSet);
                    }
                    finally {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                }
                ppt.setValue(dto, value);
            } else if (ppt.isReturnType()) {
                ppt.setValue(dto, returnValue);
            }
            ++i;
        }
        return dto;
    }

    protected Object getArgumentDto(Object[] args) {
        if (args.length == 0) {
            return null;
        }
        if (args.length == 1) {
            if (args[0] == null) {
                throw new IllegalArgumentException("args[0] should not be null!");
            }
            return args[0];
        }
        throw new IllegalArgumentException("args");
    }

    protected TnResultSetHandler createOutParameterResultSetHandler(TnProcedureParameterType ppt, ResultSet resultSet) {
        return new TnMapListResultSetHandler();
    }

    protected static class TnMapListResultSetHandler
    extends TnAbstractMapResultSetHandler {
        protected TnMapListResultSetHandler() {
        }

        public Object handle(ResultSet resultSet) throws SQLException {
            TnPropertyType[] propertyTypes = this.createPropertyTypes(resultSet.getMetaData());
            ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
            while (resultSet.next()) {
                list.add(this.createRow(resultSet, propertyTypes));
            }
            return list;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static abstract class TnAbstractMapResultSetHandler
    implements TnResultSetHandler {
        protected TnAbstractMapResultSetHandler() {
        }

        protected Map<String, Object> createRow(ResultSet rs, TnPropertyType[] propertyTypes) throws SQLException {
            StringKeyMap<Object> row = StringKeyMap.createAsFlexibleOrdered();
            for (int i = 0; i < propertyTypes.length; ++i) {
                Object value = propertyTypes[i].getValueType().getValue(rs, i + 1);
                row.put(propertyTypes[i].getPropertyName(), value);
            }
            return row;
        }

        protected TnPropertyType[] createPropertyTypes(ResultSetMetaData rsmd) throws SQLException {
            int count = rsmd.getColumnCount();
            TnPropertyType[] propertyTypes = new TnPropertyType[count];
            for (int i = 0; i < count; ++i) {
                String propertyName = rsmd.getColumnLabel(i + 1);
                ValueType valueType = TnValueTypes.getValueType(rsmd.getColumnType(i + 1));
                propertyTypes[i] = new TnPropertyTypeImpl(propertyName, valueType);
            }
            return propertyTypes;
        }
    }
}

