/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.dml;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.h2.command.Prepared;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.log.LogFile;
import org.h2.log.LogSystem;
import org.h2.message.Message;
import org.h2.result.ResultInterface;
import org.h2.store.DiskFile;
import org.h2.store.FileLister;
import org.h2.store.PageStore;
import org.h2.util.FileUtils;
import org.h2.util.IOUtils;
import org.h2.util.ObjectArray;

public class BackupCommand
extends Prepared {
    private Expression fileNameExpr;

    public BackupCommand(Session session) {
        super(session);
    }

    public void setFileName(Expression expression) {
        this.fileNameExpr = expression;
    }

    public int update() throws SQLException {
        String string = this.fileNameExpr.getValue(this.session).getString();
        this.session.getUser().checkAdmin();
        this.backupTo(string);
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void backupTo(String string) throws SQLException {
        Database database = this.session.getDatabase();
        if (!database.isPersistent()) {
            throw Message.getSQLException(90126);
        }
        try {
            String string2 = database.getName();
            string2 = FileUtils.getFileName(string2);
            OutputStream outputStream = FileUtils.openFileOutputStream(string, false);
            ZipOutputStream zipOutputStream = new ZipOutputStream(outputStream);
            LogSystem logSystem = database.getLog();
            try {
                String string3;
                logSystem.flush();
                logSystem.updateKeepFiles(1);
                if (database.isPageStoreEnabled()) {
                    string3 = database.getName() + ".h2.db";
                    this.backupPageStore(zipOutputStream, string3, database.getPageStore());
                } else {
                    string3 = database.getName() + ".data.db";
                    this.backupDiskFile(zipOutputStream, string3, database.getDataFile());
                    string3 = database.getName() + ".index.db";
                    this.backupDiskFile(zipOutputStream, string3, database.getIndexFile());
                }
                String string4 = FileUtils.getParent(string3);
                Object object = database.getLobSyncObject();
                synchronized (object) {
                    Object object2;
                    if (!database.isPageStoreEnabled()) {
                        object2 = logSystem.getActiveLogFiles();
                        int n = ((ObjectArray)object2).size();
                        for (int i = 0; i < ((ObjectArray)object2).size(); ++i) {
                            LogFile logFile = (LogFile)((ObjectArray)object2).get(i);
                            string3 = logFile.getFileName();
                            this.backupFile(zipOutputStream, string4, string3);
                            database.setProgress(3, string2, i, n);
                        }
                    }
                    object2 = database.getDatabasePath();
                    String string5 = FileUtils.getParent((String)object2);
                    ArrayList<String> arrayList = FileLister.getDatabaseFiles(string5, string2, true);
                    for (String string6 : arrayList) {
                        if (!string6.endsWith(".lob.db")) continue;
                        this.backupFile(zipOutputStream, string4, string6);
                    }
                }
                zipOutputStream.close();
                outputStream.close();
            }
            finally {
                logSystem.updateKeepFiles(-1);
            }
        }
        catch (IOException iOException) {
            throw Message.convertIOException(iOException, string);
        }
    }

    private void backupPageStore(ZipOutputStream zipOutputStream, String string, PageStore pageStore) throws SQLException, IOException {
        Database database = this.session.getDatabase();
        string = FileUtils.getFileName(string);
        zipOutputStream.putNextEntry(new ZipEntry(string));
        int n = pageStore.getPageCount();
        int n2 = 0;
        while ((n2 = pageStore.copyDirect(n2, zipOutputStream)) >= 0) {
            database.setProgress(3, string, n2, n);
        }
        zipOutputStream.closeEntry();
    }

    private void backupDiskFile(ZipOutputStream zipOutputStream, String string, DiskFile diskFile) throws SQLException, IOException {
        Database database = this.session.getDatabase();
        string = FileUtils.getFileName(string);
        zipOutputStream.putNextEntry(new ZipEntry(string));
        int n = -1;
        int n2 = diskFile.getReadCount();
        while ((n = diskFile.copyDirect(n, zipOutputStream)) >= 0) {
            database.setProgress(3, string, n, n2);
        }
        zipOutputStream.closeEntry();
    }

    private void backupFile(ZipOutputStream zipOutputStream, String string, String string2) throws IOException {
        String string3 = FileUtils.getAbsolutePath(string2);
        if (!string3.startsWith(string = FileUtils.getAbsolutePath(string))) {
            Message.throwInternalError(string3 + " does not start with " + string);
        }
        string3 = string3.substring(string.length());
        string3 = BackupCommand.correctFileName(string3);
        zipOutputStream.putNextEntry(new ZipEntry(string3));
        InputStream inputStream = FileUtils.openFileInputStream(string2);
        IOUtils.copyAndCloseInput(inputStream, zipOutputStream);
        zipOutputStream.closeEntry();
    }

    public boolean isTransactional() {
        return true;
    }

    public static String correctFileName(String string) {
        if ((string = string.replace('\\', '/')).startsWith("/")) {
            string = string.substring(1);
        }
        return string;
    }

    public boolean needRecompile() {
        return false;
    }

    public ResultInterface queryMeta() {
        return null;
    }
}

