/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.properties;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.torque.engine.database.model.UnifiedSchema;
import org.seasar.dbflute.config.DfEnvironmentType;
import org.seasar.dbflute.exception.DfIllegalPropertyTypeException;
import org.seasar.dbflute.exception.DfJDBCException;
import org.seasar.dbflute.helper.StringKeyMap;
import org.seasar.dbflute.logic.jdbc.connection.DfCurrentSchemaConnector;
import org.seasar.dbflute.properties.DfAdditionalForeignKeyProperties;
import org.seasar.dbflute.properties.DfBasicProperties;
import org.seasar.dbflute.properties.DfDatabaseProperties;
import org.seasar.dbflute.properties.DfLittleAdjustmentProperties;
import org.seasar.dbflute.properties.filereader.DfListStringFileReader;
import org.seasar.dbflute.properties.filereader.DfMapStringFileReader;
import org.seasar.dbflute.properties.filereader.DfStringFileReader;
import org.seasar.dbflute.properties.handler.DfPropertiesHandler;
import org.seasar.dbflute.util.DfNameHintUtil;
import org.seasar.dbflute.util.DfPropertyUtil;
import org.seasar.dbflute.util.DfStringUtil;
import org.seasar.dbflute.util.DfSystemUtil;
import org.seasar.dbflute.util.DfTypeUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DfAbstractHelperProperties {
    private static final Log _log = LogFactory.getLog(DfAbstractHelperProperties.class);
    public static final String JAVA_targetLanguage = "java";
    public static final String CSHARP_targetLanguage = "csharp";
    public static final String PHP_targetLanguage = "php";
    public static final String CSHARPOLD_targetLanguage = "csharpold";
    public static final String DEFAULT_targetLanguage = "java";
    public static final String DEFAULT_templateFileEncoding = "UTF-8";
    public static final String DEFAULT_sourceFileEncoding = "UTF-8";
    public static final String DEFAULT_projectSchemaXMLEncoding = "UTF-8";
    public static final Map<String, Object> DEFAULT_EMPTY_MAP = new LinkedHashMap<String, Object>();
    public static final List<Object> DEFAULT_EMPTY_LIST = new ArrayList<Object>();
    public static final String DEFAULT_EMPTY_MAP_STRING = "map:{}";
    public static final String DEFAULT_EMPTY_LIST_STRING = "list:{}";
    protected Properties _buildProperties;

    public DfAbstractHelperProperties(Properties prop) {
        if (prop == null) {
            String msg = "Look! Read the message below." + this.ln();
            msg = msg + "/- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -" + this.ln();
            msg = msg + "The build-properties is required!" + this.ln();
            msg = msg + this.ln();
            msg = msg + "[Advice]" + this.ln();
            msg = msg + "Check your environment of DBFlute client and module!" + this.ln();
            msg = msg + "And set up from first again after confirmation of correct procedure." + this.ln();
            msg = msg + this.ln();
            msg = msg + "[Properties]" + this.ln() + null + this.ln();
            msg = msg + "- - - - - - - - - -/";
            throw new IllegalStateException(msg);
        }
        this._buildProperties = prop;
    }

    protected Properties getProperties() {
        return this._buildProperties;
    }

    public String getProperty(String key, String defaultValue, Map<String, ? extends Object> map) {
        Object obj = map.get(key);
        if (obj != null) {
            if (!(obj instanceof String)) {
                String msg = "The key's value should be string:";
                msg = msg + " " + DfTypeUtil.toClassTitle((Object)obj) + "=" + obj;
                throw new IllegalStateException(msg);
            }
            String value = (String)obj;
            if (value.trim().length() > 0) {
                return value;
            }
            return defaultValue;
        }
        return defaultValue;
    }

    public String getPropertyIfNotBuildProp(String key, String defaultValue, Map<String, ? extends Object> map) {
        Object obj = map.get(key);
        if (obj != null) {
            if (!(obj instanceof String)) {
                String msg = "The key's value should be string:";
                msg = msg + " " + DfTypeUtil.toClassTitle((Object)obj) + "=" + obj;
                throw new IllegalStateException(msg);
            }
            String value = (String)obj;
            if (value.trim().length() > 0) {
                return value;
            }
            return defaultValue;
        }
        return this.stringProp("torque." + key, defaultValue);
    }

    public boolean isProperty(String key, boolean defaultValue, Map<String, ? extends Object> map) {
        String anotherKey;
        Object obj = map.get(key);
        if (obj == null && (anotherKey = DfAbstractHelperProperties.deriveBooleanAnotherKey(key)) != null) {
            obj = map.get(anotherKey);
        }
        if (obj != null) {
            if (!(obj instanceof String)) {
                String msg = "The key's value should be boolean:";
                msg = msg + " " + DfTypeUtil.toClassTitle((Object)obj) + "=" + obj;
                throw new IllegalStateException(msg);
            }
            String value = (String)obj;
            if (value.trim().length() > 0) {
                return value.trim().equalsIgnoreCase("true");
            }
            return defaultValue;
        }
        return defaultValue;
    }

    public boolean isPropertyIfNotBuildProp(String key, boolean defaultValue, Map<String, ? extends Object> map) {
        String anotherKey;
        Object obj = map.get(key);
        if (obj == null && (anotherKey = DfAbstractHelperProperties.deriveBooleanAnotherKey(key)) != null) {
            obj = map.get(anotherKey);
        }
        if (obj != null) {
            if (!(obj instanceof String)) {
                String msg = "The key's value should be boolean:";
                msg = msg + " " + DfTypeUtil.toClassTitle((Object)obj) + "=" + obj;
                throw new IllegalStateException(msg);
            }
            String value = (String)obj;
            if (value.trim().length() > 0) {
                return value.trim().equalsIgnoreCase("true");
            }
            return defaultValue;
        }
        return this.booleanProp("torque." + key, defaultValue);
    }

    static String deriveBooleanAnotherKey(String key) {
        if (key.length() > "is".length() && key.startsWith("is") && Character.isUpperCase(key.substring("is".length()).charAt(0))) {
            return DfStringUtil.initUncap((String)key.substring("is".length()));
        }
        return null;
    }

    protected final String stringProp(String key) {
        try {
            String outsidePropString = this.getOutsidePropString(key);
            if (outsidePropString != null && outsidePropString.trim().length() > 0) {
                return outsidePropString;
            }
            return DfPropertyUtil.stringProp(this._buildProperties, key);
        }
        catch (RuntimeException e) {
            _log.warn((Object)("FlPropertyUtil#stringProp() threw the exception with The key[" + key + "]"), (Throwable)e);
            throw e;
        }
    }

    protected final String stringProp(String key, String defaultValue) {
        try {
            String outsidePropString = this.getOutsidePropString(key);
            if (outsidePropString != null && outsidePropString.trim().length() > 0) {
                return outsidePropString;
            }
            return DfPropertyUtil.stringProp(this._buildProperties, key);
        }
        catch (DfPropertyUtil.PropertyNotFoundException e) {
            return defaultValue;
        }
        catch (RuntimeException e) {
            _log.warn((Object)("FlPropertyUtil#stringProp() threw the exception with The key[" + key + "]"), (Throwable)e);
            throw e;
        }
    }

    protected final String stringPropNoEmpty(String key, String defaultValue) {
        try {
            String outsidePropString = this.getOutsidePropString(key);
            if (outsidePropString != null && outsidePropString.trim().length() > 0) {
                return outsidePropString;
            }
            String value = DfPropertyUtil.stringProp(this._buildProperties, key);
            if (value != null && value.trim().length() != 0) {
                return value;
            }
            return defaultValue;
        }
        catch (DfPropertyUtil.PropertyNotFoundException e) {
            return defaultValue;
        }
        catch (RuntimeException e) {
            _log.warn((Object)("FlPropertyUtil#stringProp() threw the exception with The key[" + key + "]"), (Throwable)e);
            throw e;
        }
    }

    protected final boolean booleanProp(String key) {
        try {
            return DfPropertyUtil.booleanProp(this._buildProperties, key);
        }
        catch (RuntimeException e) {
            _log.warn((Object)("FlPropertyUtil#booleanProp() threw the exception with The key[" + key + "]"), (Throwable)e);
            throw e;
        }
    }

    protected final boolean booleanProp(String key, boolean defaultValue) {
        try {
            return DfPropertyUtil.booleanProp(this._buildProperties, key);
        }
        catch (DfPropertyUtil.PropertyNotFoundException e) {
            return defaultValue;
        }
        catch (DfPropertyUtil.PropertyBooleanFormatException e) {
            return defaultValue;
        }
        catch (RuntimeException e) {
            _log.warn((Object)("FlPropertyUtil#intProp() threw the exception with The key[" + key + "]"), (Throwable)e);
            throw e;
        }
    }

    protected final int intProp(String key) {
        try {
            return DfPropertyUtil.intProp(this._buildProperties, key);
        }
        catch (RuntimeException e) {
            _log.warn((Object)("FlPropertyUtil#intProp() threw the exception with The key[" + key + "]"), (Throwable)e);
            throw e;
        }
    }

    protected final int intProp(String key, int defaultValue) {
        try {
            return DfPropertyUtil.intProp(this._buildProperties, key);
        }
        catch (DfPropertyUtil.PropertyNotFoundException e) {
            return defaultValue;
        }
        catch (DfPropertyUtil.PropertyIntegerFormatException e) {
            return defaultValue;
        }
        catch (RuntimeException e) {
            _log.warn((Object)("FlPropertyUtil#intProp() threw the exception with The key[" + key + "]"), (Throwable)e);
            throw e;
        }
    }

    protected final List<Object> listProp(String key) {
        try {
            List<Object> outsidePropList = this.getOutsidePropList(key);
            if (!outsidePropList.isEmpty()) {
                return outsidePropList;
            }
            return DfPropertyUtil.listProp(this._buildProperties, key, ";");
        }
        catch (RuntimeException e) {
            _log.warn((Object)("DfPropertyUtil#listProp() threw the exception with The key[" + key + "]"), (Throwable)e);
            throw e;
        }
    }

    protected final List<Object> listProp(String key, List<Object> defaultValue) {
        try {
            List<Object> outsidePropList = this.getOutsidePropList(key);
            if (!outsidePropList.isEmpty()) {
                return outsidePropList;
            }
            List<Object> result = DfPropertyUtil.listProp(this._buildProperties, key, ";");
            if (result.isEmpty()) {
                return defaultValue;
            }
            return result;
        }
        catch (DfPropertyUtil.PropertyNotFoundException e) {
            return defaultValue;
        }
        catch (RuntimeException e) {
            _log.warn((Object)("DfPropertyUtil#listProp() threw the exception with The key[" + key + "]"), (Throwable)e);
            throw e;
        }
    }

    protected final Map<String, Object> mapProp(String key) {
        try {
            Map<String, Object> outsidePropMap = this.getOutsidePropMap(key);
            if (!outsidePropMap.isEmpty()) {
                return outsidePropMap;
            }
            return DfPropertyUtil.mapProp(this._buildProperties, key, ";");
        }
        catch (RuntimeException e) {
            _log.warn((Object)("DfPropertyUtil#mapProp() threw the exception with The key[" + key + "]"), (Throwable)e);
            throw e;
        }
    }

    protected final Map<String, Object> mapProp(String key, Map<String, Object> defaultValue) {
        try {
            Map<String, Object> outsidePropMap = this.getOutsidePropMap(key);
            if (!outsidePropMap.isEmpty()) {
                return outsidePropMap;
            }
            Map<String, Object> result = DfPropertyUtil.mapProp(this._buildProperties, key, ";");
            if (result.isEmpty()) {
                return defaultValue;
            }
            return result;
        }
        catch (DfPropertyUtil.PropertyNotFoundException e) {
            return defaultValue;
        }
        catch (RuntimeException e) {
            _log.warn((Object)("DfPropertyUtil#mapProp() threw the exception with The key[" + key + "]"), (Throwable)e);
            throw e;
        }
    }

    protected String getOutsidePropString(String key) {
        String propName = DfStringUtil.replace((String)key, (String)"torque.", (String)"");
        DfStringFileReader reader = new DfStringFileReader();
        if (!this.isEnvironmentDefault()) {
            String environmentType = this.getEnvironmentType();
            String path = "./dfprop/" + environmentType + "/" + propName + ".dfprop";
            String str = reader.readString(path);
            if (str.trim().length() > 0) {
                return str;
            }
        }
        return reader.readString("./dfprop/" + propName + ".dfprop");
    }

    protected Map<String, Object> getOutsidePropMap(String key) {
        String propName = DfStringUtil.replace((String)key, (String)"torque.", (String)"");
        DfMapStringFileReader reader = new DfMapStringFileReader();
        String mainpath = "./dfprop/" + propName + ".dfprop";
        String envpath = "./dfprop/" + this.getEnvironmentType() + "/" + propName + ".dfprop";
        if (this.isEnvironmentDefault()) {
            Map<String, Object> map = reader.readMap(mainpath);
            this.setupOutsidePropExMap(reader, map, mainpath);
            return map;
        }
        Map<String, Object> map = reader.readMap(envpath);
        if (map.isEmpty()) {
            map = reader.readMap(mainpath);
            this.setupOutsidePropExMap(reader, map, mainpath);
        }
        this.setupOutsidePropExMap(reader, map, envpath);
        return map;
    }

    protected void setupOutsidePropExMap(DfMapStringFileReader reader, Map<String, Object> map, String path) {
        if (!path.endsWith(".dfprop")) {
            String msg = "The path should end with '.dfprop':";
            msg = msg + " path=" + path;
            throw new IllegalStateException(msg);
        }
        path = path.substring(0, path.length() - ".dfprop".length()) + "+.dfprop";
        Map<String, Object> exMap = reader.readMap(path);
        map.putAll(exMap);
    }

    protected List<Object> getOutsidePropList(String key) {
        String propName = DfStringUtil.replace((String)key, (String)"torque.", (String)"");
        DfListStringFileReader reader = new DfListStringFileReader();
        if (!this.isEnvironmentDefault()) {
            String environmentType = this.getEnvironmentType();
            String path = "./dfprop/" + environmentType + "/" + propName + ".dfprop";
            List<Object> list = reader.readList(path);
            if (!list.isEmpty()) {
                return list;
            }
        }
        return reader.readList("./dfprop/" + propName + ".dfprop");
    }

    public DfPropertiesHandler handler() {
        return DfPropertiesHandler.getInstance();
    }

    protected DfBasicProperties getBasicProperties() {
        return DfPropertiesHandler.getInstance().getBasicProperties(this.getProperties());
    }

    protected DfDatabaseProperties getDatabaseProperties() {
        return DfPropertiesHandler.getInstance().getDatabaseProperties(this.getProperties());
    }

    protected DfAdditionalForeignKeyProperties getAdditionalForeignKeyProperties() {
        return DfPropertiesHandler.getInstance().getAdditionalForeignKeyProperties(this.getProperties());
    }

    protected DfLittleAdjustmentProperties getLittleAdjustmentProperties() {
        return DfPropertiesHandler.getInstance().getLittleAdjustmentProperties(this.getProperties());
    }

    protected <VALUE> VALUE getByFlexibleKey(Map<String, VALUE> map, String key) {
        StringKeyMap stringKeyMap = StringKeyMap.createAsFlexible();
        stringKeyMap.putAll(map);
        return (VALUE)stringKeyMap.get(key);
    }

    protected boolean isHitByTheHint(String name, String hint) {
        return DfNameHintUtil.isHitByTheHint(name, hint);
    }

    protected final boolean isEnvironmentDefault() {
        return DfEnvironmentType.getInstance().isDefault();
    }

    protected final String getEnvironmentType() {
        return DfEnvironmentType.getInstance().getEnvironmentType();
    }

    protected Connection createConnection(String driver, String url, UnifiedSchema unifiedSchema, Properties info) {
        this.setupConnectionDriver(driver);
        try {
            Connection conn = DriverManager.getConnection(url, info);
            this.setupConnectionVariousSetting(unifiedSchema, conn);
            return conn;
        }
        catch (SQLException e) {
            String msg = "Failed to connect: url=" + url + " info=" + info;
            throw new IllegalStateException(msg, e);
        }
    }

    protected Connection createConnection(String driver, String url, UnifiedSchema unifiedSchema, String user, String password) {
        this.setupConnectionDriver(driver);
        try {
            Connection conn = DriverManager.getConnection(url, user, password);
            this.setupConnectionVariousSetting(unifiedSchema, conn);
            return conn;
        }
        catch (SQLException e) {
            String msg = "Failed to connect: url=" + url + " user=" + user;
            throw new IllegalStateException(msg, e);
        }
    }

    private void setupConnectionDriver(String driver) {
        try {
            Class.forName(driver);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private void setupConnectionVariousSetting(UnifiedSchema unifiedSchema, Connection conn) throws SQLException {
        conn.setAutoCommit(true);
        if (unifiedSchema.existsPureSchema()) {
            DfCurrentSchemaConnector connector = new DfCurrentSchemaConnector(unifiedSchema, this.getBasicProperties());
            connector.connectSchema(conn);
        }
    }

    protected String getConnectedCatalog(String driver, String url, String user, String password) throws SQLException {
        this.setupConnectionDriver(driver);
        try {
            Connection conn = DriverManager.getConnection(url, user, password);
            return conn.getCatalog();
        }
        catch (SQLException e) {
            String msg = "Failed to connect: url=" + url + " user=" + user;
            throw new DfJDBCException(msg, e);
        }
    }

    protected String castToString(Object obj, String property) {
        if (!(obj instanceof String)) {
            String msg = "The type of the property '" + property + "' should be String:";
            msg = msg + " obj=" + obj + " type=" + (obj != null ? obj.getClass() : null);
            throw new DfIllegalPropertyTypeException(msg);
        }
        return (String)obj;
    }

    protected <ELEMENT> List<ELEMENT> castToList(Object obj, String property) {
        if (!(obj instanceof List)) {
            String msg = "The type of the property '" + property + "' should be List:";
            msg = msg + " obj=" + obj + " type=" + (obj != null ? obj.getClass() : null);
            throw new DfIllegalPropertyTypeException(msg);
        }
        return (List)obj;
    }

    protected String ln() {
        return DfSystemUtil.getLineSeparator();
    }

    protected <KEY, VALUE> LinkedHashMap<KEY, VALUE> newLinkedHashMap() {
        return new LinkedHashMap();
    }

    protected String filterDoubleQuotation(String str) {
        return DfPropertyUtil.convertAll(str, "\"", "'");
    }

    protected String removeLineSeparator(String str) {
        str = this.removeCR(str);
        str = this.removeLF(str);
        return str;
    }

    protected String removeLF(String str) {
        return str.replaceAll("\n", "");
    }

    protected String removeCR(String str) {
        return str.replaceAll("\r", "");
    }

    protected boolean processBooleanString(String value) {
        return value != null && value.trim().equalsIgnoreCase("true");
    }
}

