/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.ymir.zpt;

import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.skirnir.freyja.Attribute;
import net.skirnir.freyja.TagEvaluatorUtils;
import net.skirnir.freyja.TemplateContext;
import net.skirnir.freyja.VariableResolver;
import org.seasar.framework.container.annotation.tiger.Binding;
import org.seasar.framework.container.annotation.tiger.BindingType;
import org.seasar.kvasir.util.PropertyUtils;
import org.seasar.ymir.FollowingURLResolver;
import org.seasar.ymir.Request;
import org.seasar.ymir.YmirContext;
import org.seasar.ymir.util.ServletUtils;
import org.seasar.ymir.zpt.TagRenderingInterceptor;
import org.seasar.ymir.zpt.TagRenderingInterceptorChain;

public class SessionIdEmbeddingInterceptor
implements TagRenderingInterceptor {
    private static final String ATTR_ACTION = "action";
    private static final String ATTR_HREF = "href";
    private static final String ATTR_SRC = "src";
    private static final String[] SPECIALATTRIBUTEPATTERNSTRINGS = new String[]{"action", "href", "src"};
    private FollowingURLResolver followingURLResolver_;

    @Binding(bindingType=BindingType.MUST)
    public void setFollowingURLResolver(FollowingURLResolver followingURLResolver) {
        this.followingURLResolver_ = followingURLResolver;
    }

    public String[] getSpecialAttributePatternStrings() {
        return SPECIALATTRIBUTEPATTERNSTRINGS;
    }

    public String[] getSpecialTagPatternStrings() {
        return null;
    }

    public String render(TemplateContext context, String name, Attribute[] attributes, String body, TagRenderingInterceptorChain chain) {
        ArrayList<Attribute> list = new ArrayList<Attribute>();
        for (Attribute attribute : attributes) {
            String attrValue;
            String attrName = attribute.getName();
            if ((ATTR_ACTION.equals(attrName) || ATTR_HREF.equals(attrName) || ATTR_SRC.equals(attrName)) && (attrValue = TagEvaluatorUtils.defilter((String)attribute.getValue())) != null) {
                String processed = attrValue;
                if (this.shouldOmitSessionId()) {
                    processed = this.omitSessionId(processed);
                } else if (this.shouldAddSessionId(processed) && !ServletUtils.isSessionIdEmbedded((String)processed)) {
                    processed = this.addSessionId(context, processed);
                }
                processed = this.resolveURL(context, processed);
                if (!processed.equals(attrValue)) {
                    attribute = new Attribute(attrName, TagEvaluatorUtils.filter((String)processed), attribute.getQuote());
                }
            }
            list.add(attribute);
        }
        return chain.render(context, name, list.toArray(new Attribute[0]), body);
    }

    private boolean shouldOmitSessionId() {
        return PropertyUtils.valueOf((String)YmirContext.getYmir().getApplication().getProperty("core.session.omitSessionId"), (boolean)false);
    }

    protected String omitSessionId(String url) {
        return ServletUtils.omitSessionId((String)url);
    }

    protected boolean shouldAddSessionId(String url) {
        if (url.indexOf(58) >= 0) {
            return false;
        }
        String stripped = ServletUtils.stripParameters((String)url);
        return stripped.endsWith(".html") || stripped.endsWith(".do") || stripped.endsWith(".zpt");
    }

    private String addSessionId(TemplateContext context, String url) {
        HttpServletResponse response = (HttpServletResponse)context.getVariableResolver().getVariable(context, "response");
        if (response != null) {
            return response.encodeURL(url);
        }
        return url;
    }

    protected String resolveURL(TemplateContext context, String url) {
        Request request;
        HttpServletResponse httpResponse;
        VariableResolver resolver = context.getVariableResolver();
        HttpServletRequest httpRequest = (HttpServletRequest)resolver.getVariable(context, "request");
        if (this.followingURLResolver_.isResolved(url, httpRequest, httpResponse = (HttpServletResponse)resolver.getVariable(context, "response"), request = (Request)resolver.getVariable(context, "ymirRequest"))) {
            return url;
        }
        return this.followingURLResolver_.resolveURL(url, httpRequest, httpResponse, request);
    }
}

