/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.ymir.zpt.checkbox;

import java.util.Map;
import net.skirnir.freyja.Attribute;
import net.skirnir.freyja.TagEvaluatorUtils;
import net.skirnir.freyja.TemplateContext;
import org.seasar.ymir.YmirContext;
import org.seasar.ymir.zpt.TagRenderingInterceptor;
import org.seasar.ymir.zpt.TagRenderingInterceptorChain;

public class CheckboxInterceptor
implements TagRenderingInterceptor {
    private static final String[] SPECIALTAGPATTERNSTRINGS = new String[]{"input"};
    private static final String ATTR_TYPE = "type";
    private static final String ATTR_NAME = "name";

    public String[] getSpecialAttributePatternStrings() {
        return null;
    }

    public String[] getSpecialTagPatternStrings() {
        return SPECIALTAGPATTERNSTRINGS;
    }

    public String render(TemplateContext context, String name, Attribute[] attributes, String body, TagRenderingInterceptorChain chain) {
        Attribute nameAttr;
        Map attr = TagEvaluatorUtils.toMap((Attribute[])attributes);
        Attribute typeAttr = (Attribute)attr.get(ATTR_TYPE);
        if (typeAttr != null && "checkbox".equalsIgnoreCase(typeAttr.getValue()) && (nameAttr = (Attribute)attr.get(ATTR_NAME)) != null) {
            return chain.render(context, name, attributes, body) + "<input type=\"hidden\" name=\"" + TagEvaluatorUtils.filter((String)this.getKey()) + "\" value=\"" + nameAttr.getValue() + "\" />";
        }
        return chain.render(context, name, attributes, body);
    }

    String getKey() {
        return YmirContext.getYmir().getApplication().getProperty("core.checkbox.key", "org.seasar.ymir.checkbox");
    }
}

