/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.ymir.zpt;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.skirnir.freyja.Attribute;
import net.skirnir.freyja.Element;
import net.skirnir.freyja.IllegalSyntaxException;
import net.skirnir.freyja.TagElement;
import org.seasar.ymir.zpt.TemplateParsingInterceptor;
import org.seasar.ymir.zpt.TemplateParsingInterceptorChain;

public class TemplateParsingInterceptorChainImpl
implements TemplateParsingInterceptorChain {
    private TemplateParsingInterceptor templateParsingInterceptor_;
    private TemplateParsingInterceptorChain chain_;
    private Pattern[] tagPatterns_;
    private Pattern[] attrPatterns_;

    public TemplateParsingInterceptorChainImpl(TemplateParsingInterceptor templateParsingInterceptor, TemplateParsingInterceptorChain chain) {
        this.templateParsingInterceptor_ = templateParsingInterceptor;
        this.chain_ = chain;
        this.tagPatterns_ = this.compilePatterns(templateParsingInterceptor.getSpecialTagPatternStrings());
        this.attrPatterns_ = this.compilePatterns(templateParsingInterceptor.getSpecialAttributePatternStrings());
    }

    Pattern[] compilePatterns(String[] patternStrings) {
        if (patternStrings == null) {
            return new Pattern[0];
        }
        Pattern[] patterns = new Pattern[patternStrings.length];
        for (int i = 0; i < patternStrings.length; ++i) {
            try {
                patterns[i] = Pattern.compile(patternStrings[i]);
                continue;
            }
            catch (PatternSyntaxException ex) {
                throw (IllegalArgumentException)new IllegalArgumentException("Syntax error: " + patternStrings[i]).initCause(ex);
            }
        }
        return patterns;
    }

    boolean isSpecialTag(String tagName) {
        for (int i = 0; i < this.tagPatterns_.length; ++i) {
            Matcher m = this.tagPatterns_[i].matcher(tagName);
            if (!m.find()) continue;
            return true;
        }
        return false;
    }

    boolean isSpecialAttribute(String attrName) {
        for (int i = 0; i < this.attrPatterns_.length; ++i) {
            Matcher m = this.attrPatterns_[i].matcher(attrName);
            if (!m.find()) continue;
            return true;
        }
        return false;
    }

    public Element[] tagElementCreated(TagElement tagElement) throws IllegalSyntaxException {
        if (this.shouldProcess(tagElement)) {
            return this.templateParsingInterceptor_.tagElementCreated(tagElement, this.chain_);
        }
        return this.chain_.tagElementCreated(tagElement);
    }

    boolean shouldProcess(TagElement tagElement) {
        if (this.isSpecialTag(tagElement.getName())) {
            return true;
        }
        Attribute[] attributes = tagElement.getAttributes();
        for (int i = 0; i < attributes.length; ++i) {
            if (!this.isSpecialAttribute(attributes[i].getName())) continue;
            return true;
        }
        return false;
    }
}

