/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.ymir.zpt;

import java.text.MessageFormat;
import java.util.Locale;
import net.skirnir.freyja.TemplateContext;
import net.skirnir.freyja.VariableResolver;
import net.skirnir.freyja.render.Note;
import net.skirnir.freyja.zpt.tales.PathResolver;
import org.seasar.framework.container.ComponentNotFoundRuntimeException;
import org.seasar.framework.container.S2Container;
import org.seasar.kvasir.util.collection.AttributeReader;
import org.seasar.kvasir.util.collection.I18NPropertyReader;
import org.seasar.kvasir.util.collection.PropertyReader;
import org.seasar.ymir.Ymir;
import org.seasar.ymir.YmirContext;
import org.seasar.ymir.locale.LocaleManager;
import org.seasar.ymir.message.MessageNotFoundRuntimeException;
import org.seasar.ymir.message.Messages;
import org.seasar.ymir.message.MessagesNotFoundRuntimeException;

public abstract class PathResolverBase
implements PathResolver {
    public static final String NAME_VALUE = "%value";
    private static final String PROPERTYPREFIX_LABEL = "label.";

    public boolean accept(TemplateContext context, VariableResolver varResolver, Object obj, String child) {
        return obj instanceof Note || obj instanceof I18NPropertyReader || obj instanceof PropertyReader || obj instanceof AttributeReader;
    }

    public Object resolve(TemplateContext context, VariableResolver varResolver, Object obj, String child) {
        if (obj instanceof Note) {
            Note note = (Note)obj;
            if (child.equals(NAME_VALUE)) {
                return this.getMessageResourceValue(context, varResolver, note.getValue(), note.getParameters());
            }
        } else {
            if (obj instanceof I18NPropertyReader) {
                String value;
                String messageKey;
                I18NPropertyReader reader = (I18NPropertyReader)obj;
                if (child.startsWith("%")) {
                    messageKey = child.substring(1);
                    value = reader.getProperty(messageKey, this.findLocale(context, varResolver));
                } else {
                    messageKey = child;
                    value = reader.getProperty(messageKey);
                }
                if (value == null && obj instanceof Messages) {
                    throw new MessageNotFoundRuntimeException("Message corresponding key ('" + messageKey + "') does not exist in default Messages (" + "messages.xproperties" + ")").setMessageKey(messageKey).setLocale(child.startsWith("%") ? this.findLocale(context, varResolver) : new Locale(""));
                }
                return value;
            }
            if (obj instanceof PropertyReader) {
                return ((PropertyReader)obj).getProperty(child);
            }
            if (obj instanceof AttributeReader) {
                return ((AttributeReader)obj).getAttribute(child);
            }
        }
        return null;
    }

    String getMessageResourceValue(TemplateContext context, VariableResolver varResolver, String noteValue, Object[] noteParameters) {
        Messages messages;
        String messagesName;
        if (noteValue == null) {
            return null;
        }
        int slash = noteValue.indexOf(47);
        if (slash >= 0) {
            messagesName = noteValue.substring(0, slash);
            noteValue = noteValue.substring(slash + 1);
        } else {
            messagesName = "messages";
        }
        try {
            messages = this.findMessages(messagesName);
        }
        catch (ClassCastException ex) {
            throw new RuntimeException("Not Messages Object: messages' name may be incorrect: key=" + noteValue + ", messages' name=" + messagesName, ex);
        }
        catch (ComponentNotFoundRuntimeException ex) {
            throw new MessagesNotFoundRuntimeException("Messages object not found: messages' name may be incorrect: key=" + noteValue + ", messages' name=" + messagesName, (Throwable)ex).setMessagesName(messagesName).setMessageKey(noteValue);
        }
        if (messages != null) {
            Locale locale = this.findLocale(context, varResolver);
            String v = messages.getProperty(noteValue, locale);
            if (v != null) {
                for (int i = 0; i < noteParameters.length; ++i) {
                    String localizedValue;
                    if (!(noteParameters[i] instanceof String) || (localizedValue = messages.getProperty(PROPERTYPREFIX_LABEL + noteParameters[i], locale)) == null) continue;
                    noteParameters[i] = localizedValue;
                }
                noteValue = MessageFormat.format(v, noteParameters);
            } else {
                StringBuffer sb = new StringBuffer();
                sb.append("Message corresponding key ('").append(noteValue).append("') does not exist in ");
                if (messagesName != null) {
                    sb.append("Messages ('").append(messagesName).append("')");
                } else {
                    sb.append("default Messages (").append("messages.xproperties").append(")");
                }
                throw new MessageNotFoundRuntimeException(sb.toString()).setMessagesName(messagesName).setMessageKey(noteValue).setLocale(locale);
            }
        }
        return noteValue;
    }

    Messages findMessages(String messagesName) {
        Ymir ymir = YmirContext.getYmir();
        if (ymir == null) {
            return null;
        }
        return (Messages)ymir.getApplication().getS2Container().getComponent((Object)messagesName);
    }

    Locale findLocale(TemplateContext context, VariableResolver varResolver) {
        return ((LocaleManager)((S2Container)varResolver.getVariable(context, "container")).getComponent(LocaleManager.class)).getLocale();
    }
}

