/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.ymir.zpt;

import java.net.MalformedURLException;
import java.util.Locale;
import javax.servlet.ServletContext;
import net.skirnir.freyja.TemplateContext;
import net.skirnir.freyja.VariableResolver;
import org.seasar.kvasir.util.LocaleUtils;
import org.seasar.ymir.zpt.YmirPageTypePrefixHandler;

public class I18NPageTypePrefixHandler
extends YmirPageTypePrefixHandler {
    protected String filterPath(TemplateContext context, VariableResolver varResolver, String path) {
        ServletContext servletContext = (ServletContext)varResolver.getVariable(context, "application");
        Locale locale = (Locale)varResolver.getVariable(context, "locale");
        if (servletContext != null && locale != null) {
            path = this.determineResourcePath(servletContext, path, locale);
        }
        return path;
    }

    String determineResourcePath(ServletContext servletContext, String path, Locale locale) {
        String pathSuffix;
        String pathPrefix;
        if (!path.startsWith("/")) {
            return path;
        }
        int dot = path.lastIndexOf(46);
        int slash = path.lastIndexOf(47);
        if (slash < dot) {
            pathPrefix = path.substring(0, dot);
            pathSuffix = path.substring(dot);
        } else {
            pathPrefix = path;
            pathSuffix = "";
        }
        String[] suffixes = LocaleUtils.getSuffixes((Locale)locale);
        for (int i = 0; i < suffixes.length; ++i) {
            String localizedPath = pathPrefix + "_" + suffixes[i] + pathSuffix;
            try {
                if (servletContext.getResource(localizedPath) == null) continue;
                return localizedPath;
            }
            catch (MalformedURLException ignore) {
                // empty catch block
            }
        }
        return path;
    }
}

