/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.ymir.zpt;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Pattern;
import net.skirnir.freyja.Attribute;
import net.skirnir.freyja.Element;
import net.skirnir.freyja.IllegalSyntaxException;
import net.skirnir.freyja.TagElement;
import net.skirnir.freyja.TagEvaluatorUtils;

public class MutableTagElement
extends TagElement {
    private static final Attribute[] ATTRIBUTES_EMPTY = new Attribute[0];
    private String name_;
    private Map<String, Attribute> originalAttrMap_ = new LinkedHashMap<String, Attribute>();
    private Map<String, Attribute> attrMap_ = new LinkedHashMap<String, Attribute>();
    private Element[] bodyElements_;

    public static MutableTagElement newInstance() {
        return new MutableTagElement();
    }

    public static MutableTagElement newInstance(String name) {
        return new MutableTagElement(name);
    }

    public static MutableTagElement newInstance(String name, Attribute[] attributes) {
        return new MutableTagElement(name, attributes);
    }

    public static MutableTagElement newInstance(String name, Element[] bodyElements) {
        return new MutableTagElement(name, bodyElements);
    }

    public static MutableTagElement newInstance(String name, Attribute[] attributes, Element[] bodyElements) {
        return new MutableTagElement(name, attributes, bodyElements);
    }

    public static MutableTagElement toMutable(TagElement element) {
        if (element == null || element instanceof MutableTagElement) {
            return (MutableTagElement)element;
        }
        return new MutableTagElement(element);
    }

    protected MutableTagElement() {
        super(null, null, null);
    }

    protected MutableTagElement(TagElement element) {
        super(null, null, null);
        this.name_ = element.getName();
        for (Attribute attr : element.getAttributes()) {
            String lattrName = attr.getName().toLowerCase();
            this.originalAttrMap_.put(lattrName, attr);
            this.attrMap_.put(lattrName, attr);
        }
        this.bodyElements_ = element.getBodyElements();
        this.setColumnNumber(element.getColumnNumber());
        this.setLineNumber(element.getLineNumber());
    }

    protected MutableTagElement(String name) {
        this(name, ATTRIBUTES_EMPTY, null);
    }

    protected MutableTagElement(String name, Attribute[] attributes) {
        this(name, attributes, null);
    }

    protected MutableTagElement(String name, Element[] bodyElements) {
        this(name, ATTRIBUTES_EMPTY, bodyElements);
    }

    protected MutableTagElement(String name, Attribute[] attributes, Element[] bodyElements) {
        super(null, null, null);
        this.setName(name);
        if (attributes != null) {
            for (Attribute attr : attributes) {
                String lattrName = attr.getName().toLowerCase();
                this.originalAttrMap_.put(lattrName, attr);
                this.attrMap_.put(lattrName, attr);
            }
        }
        this.setBodyElements(bodyElements);
    }

    public String getName() {
        return this.name_;
    }

    public void setName(String name) {
        this.name_ = name;
    }

    public Attribute getOriginalAttribute(String attrName) {
        return this.originalAttrMap_.get(attrName.toLowerCase());
    }

    public String getDefilteredOriginalAttributeValue(String attrName) {
        Attribute attr = this.getOriginalAttribute(attrName);
        if (attr == null) {
            return null;
        }
        return TagEvaluatorUtils.defilter((String)attr.getValue());
    }

    public void addAttribute(Attribute attr) {
        this.attrMap_.put(attr.getName().toLowerCase(), attr);
    }

    public void addAttribute(String name, Object defilteredValue) {
        String filteredValue = defilteredValue == null ? null : TagEvaluatorUtils.filter((String)defilteredValue.toString());
        this.addAttribute(new Attribute(name, filteredValue));
    }

    public void removeAttribute(String attrName) {
        this.attrMap_.remove(attrName.toLowerCase());
    }

    public void removeAttributes(String[] attrNamePatterns, String ... validAttrNames) throws IllegalSyntaxException {
        ArrayList<Pattern> patterns = new ArrayList<Pattern>();
        for (String attrNamePattern : attrNamePatterns) {
            patterns.add(Pattern.compile(attrNamePattern));
        }
        HashSet<String> validNames = new HashSet<String>(Arrays.asList(validAttrNames));
        Iterator<Map.Entry<String, Attribute>> itr = this.attrMap_.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry<String, Attribute> entry = itr.next();
            for (Pattern pattern : patterns) {
                String name;
                if (!pattern.matcher(name = entry.getKey()).find()) continue;
                itr.remove();
                if (validNames.contains(name)) continue;
                Attribute attr = entry.getValue();
                throw (IllegalSyntaxException)new IllegalSyntaxException("Unknown attribute: " + name).setLineNumber(attr.getLineNumber()).setColumnNumber(attr.getColumnNumber());
            }
        }
    }

    public Attribute[] getAttributes() {
        return this.attrMap_.values().toArray(ATTRIBUTES_EMPTY);
    }

    public Attribute getAttribute(String attrName) {
        return this.attrMap_.get(attrName.toLowerCase());
    }

    public String getDefilteredAttributeValue(String attrName) {
        Attribute attr = this.getAttribute(attrName);
        if (attr == null) {
            return null;
        }
        return TagEvaluatorUtils.defilter((String)attr.getValue());
    }

    public Element[] getBodyElements() {
        return this.bodyElements_;
    }

    public void setBodyElements(Element[] bodyElements) {
        this.bodyElements_ = bodyElements;
    }
}

